/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.init.MobEffects;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityWitherSkull
extends EntityFireball {
    private static final DataParameter<Boolean> INVULNERABLE = EntityDataManager.createKey(EntityWitherSkull.class, DataSerializers.BOOLEAN);

    public EntityWitherSkull(World p_i1793_1_) {
        super(p_i1793_1_);
        this.setSize(0.3125f, 0.3125f);
    }

    public EntityWitherSkull(World p_i1794_1_, EntityLivingBase p_i1794_2_, double p_i1794_3_, double p_i1794_5_, double p_i1794_7_) {
        super(p_i1794_1_, p_i1794_2_, p_i1794_3_, p_i1794_5_, p_i1794_7_);
        this.setSize(0.3125f, 0.3125f);
    }

    public static void registerFixesWitherSkull(DataFixer p_registerFixesWitherSkull_0_) {
        EntityFireball.registerFixesFireball(p_registerFixesWitherSkull_0_, "WitherSkull");
    }

    @Override
    protected float getMotionFactor() {
        return this.isInvulnerable() ? 0.73f : super.getMotionFactor();
    }

    @SideOnly(value=Side.CLIENT)
    public EntityWitherSkull(World p_i1795_1_, double p_i1795_2_, double p_i1795_4_, double p_i1795_6_, double p_i1795_8_, double p_i1795_10_, double p_i1795_12_) {
        super(p_i1795_1_, p_i1795_2_, p_i1795_4_, p_i1795_6_, p_i1795_8_, p_i1795_10_, p_i1795_12_);
        this.setSize(0.3125f, 0.3125f);
    }

    @Override
    public boolean isBurning() {
        return false;
    }

    @Override
    public float getExplosionResistance(Explosion p_getExplosionResistance_1_, World p_getExplosionResistance_2_, BlockPos p_getExplosionResistance_3_, IBlockState p_getExplosionResistance_4_) {
        float f = super.getExplosionResistance(p_getExplosionResistance_1_, p_getExplosionResistance_2_, p_getExplosionResistance_3_, p_getExplosionResistance_4_);
        Block block = p_getExplosionResistance_4_.getBlock();
        if (this.isInvulnerable() && block.canEntityDestroy(p_getExplosionResistance_4_, p_getExplosionResistance_2_, p_getExplosionResistance_3_, this)) {
            f = Math.min(0.8f, f);
        }
        return f;
    }

    @Override
    protected void onImpact(RayTraceResult p_onImpact_1_) {
        if (!this.world.isRemote) {
            if (p_onImpact_1_.entityHit != null) {
                if (this.shootingEntity != null) {
                    if (p_onImpact_1_.entityHit.attackEntityFrom(DamageSource.causeMobDamage(this.shootingEntity), 8.0f)) {
                        if (p_onImpact_1_.entityHit.isEntityAlive()) {
                            this.applyEnchantments(this.shootingEntity, p_onImpact_1_.entityHit);
                        } else {
                            this.shootingEntity.heal(5.0f);
                        }
                    }
                } else {
                    p_onImpact_1_.entityHit.attackEntityFrom(DamageSource.MAGIC, 5.0f);
                }
                if (p_onImpact_1_.entityHit instanceof EntityLivingBase) {
                    int i = 0;
                    if (this.world.getDifficulty() == EnumDifficulty.NORMAL) {
                        i = 10;
                    } else if (this.world.getDifficulty() == EnumDifficulty.HARD) {
                        i = 40;
                    }
                    if (i > 0) {
                        ((EntityLivingBase)p_onImpact_1_.entityHit).addPotionEffect(new PotionEffect(MobEffects.WITHER, 20 * i, 1));
                    }
                }
            }
            this.world.newExplosion(this, this.posX, this.posY, this.posZ, 1.0f, false, this.world.getGameRules().getBoolean("mobGriefing"));
            this.setDead();
        }
    }

    @Override
    public boolean canBeCollidedWith() {
        return false;
    }

    @Override
    public boolean attackEntityFrom(DamageSource p_attackEntityFrom_1_, float p_attackEntityFrom_2_) {
        return false;
    }

    @Override
    protected void entityInit() {
        this.dataManager.register(INVULNERABLE, false);
    }

    public boolean isInvulnerable() {
        return this.dataManager.get(INVULNERABLE);
    }

    public void setInvulnerable(boolean p_setInvulnerable_1_) {
        this.dataManager.set(INVULNERABLE, p_setInvulnerable_1_);
    }

    @Override
    protected boolean isFireballFiery() {
        return false;
    }
}

