/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.init;

import com.mojang.authlib.GameProfile;
import java.io.PrintStream;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockPumpkin;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.BehaviorProjectileDispense;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityExpBottle;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityEgg;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.entity.projectile.EntitySpectralArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionHelper;
import net.minecraft.potion.PotionType;
import net.minecraft.server.DebugLoggingPrintStream;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityShulkerBox;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.LoggingPrintStream;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fluids.DispenseFluidContainer;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Bootstrap {
    public static final PrintStream SYSOUT = System.out;
    private static boolean alreadyRegistered;
    private static final Logger LOGGER;

    public static boolean isRegistered() {
        return alreadyRegistered;
    }

    static void registerDispenserBehaviors() {
        BlockDispenser.DISPENSE_BEHAVIOR_REGISTRY.putObject(Items.ARROW, new BehaviorProjectileDispense(){

            @Override
            protected IProjectile getProjectileEntity(World p_getProjectileEntity_1_, IPosition p_getProjectileEntity_2_, ItemStack p_getProjectileEntity_3_) {
                EntityTippedArrow entitytippedarrow = new EntityTippedArrow(p_getProjectileEntity_1_, p_getProjectileEntity_2_.getX(), p_getProjectileEntity_2_.getY(), p_getProjectileEntity_2_.getZ());
                entitytippedarrow.pickupStatus = EntityArrow.PickupStatus.ALLOWED;
                return entitytippedarrow;
            }
        });
        BlockDispenser.DISPENSE_BEHAVIOR_REGISTRY.putObject(Items.TIPPED_ARROW, new BehaviorProjectileDispense(){

            @Override
            protected IProjectile getProjectileEntity(World p_getProjectileEntity_1_, IPosition p_getProjectileEntity_2_, ItemStack p_getProjectileEntity_3_) {
                EntityTippedArrow entitytippedarrow = new EntityTippedArrow(p_getProjectileEntity_1_, p_getProjectileEntity_2_.getX(), p_getProjectileEntity_2_.getY(), p_getProjectileEntity_2_.getZ());
                entitytippedarrow.setPotionEffect(p_getProjectileEntity_3_);
                entitytippedarrow.pickupStatus = EntityArrow.PickupStatus.ALLOWED;
                return entitytippedarrow;
            }
        });
        BlockDispenser.DISPENSE_BEHAVIOR_REGISTRY.putObject(Items.SPECTRAL_ARROW, new BehaviorProjectileDispense(){

            @Override
            protected IProjectile getProjectileEntity(World p_getProjectileEntity_1_, IPosition p_getProjectileEntity_2_, ItemStack p_getProjectileEntity_3_) {
                EntitySpectralArrow entityarrow = new EntitySpectralArrow(p_getProjectileEntity_1_, p_getProjectileEntity_2_.getX(), p_getProjectileEntity_2_.getY(), p_getProjectileEntity_2_.getZ());
                entityarrow.pickupStatus = EntityArrow.PickupStatus.ALLOWED;
                return entityarrow;
            }
        });
        BlockDispenser.DISPENSE_BEHAVIOR_REGISTRY.putObject(Items.EGG, new BehaviorProjectileDispense(){

            @Override
            protected IProjectile getProjectileEntity(World p_getProjectileEntity_1_, IPosition p_getProjectileEntity_2_, ItemStack p_getProjectileEntity_3_) {
                return new EntityEgg(p_getProjectileEntity_1_, p_getProjectileEntity_2_.getX(), p_getProjectileEntity_2_.getY(), p_getProjectileEntity_2_.getZ());
            }
        });
        BlockDispenser.DISPENSE_BEHAVIOR_REGISTRY.putObject(Items.SNOWBALL, new BehaviorProjectileDispense(){

            @Override
            protected IProjectile getProjectileEntity(World p_getProjectileEntity_1_, IPosition p_getProjectileEntity_2_, ItemStack p_getProjectileEntity_3_) {
                return new EntitySnowball(p_getProjectileEntity_1_, p_getProjectileEntity_2_.getX(), p_getProjectileEntity_2_.getY(), p_getProjectileEntity_2_.getZ());
            }
        });
        BlockDispenser.DISPENSE_BEHAVIOR_REGISTRY.putObject(Items.EXPERIENCE_BOTTLE, new BehaviorProjectileDispense(){

            @Override
            protected IProjectile getProjectileEntity(World p_getProjectileEntity_1_, IPosition p_getProjectileEntity_2_, ItemStack p_getProjectileEntity_3_) {
                return new EntityExpBottle(p_getProjectileEntity_1_, p_getProjectileEntity_2_.getX(), p_getProjectileEntity_2_.getY(), p_getProjectileEntity_2_.getZ());
            }

            @Override
            protected float getProjectileInaccuracy() {
                return super.getProjectileInaccuracy() * 0.5f;
            }

            @Override
            protected float getProjectileVelocity() {
                return super.getProjectileVelocity() * 1.25f;
            }
        });
        BlockDispenser.DISPENSE_BEHAVIOR_REGISTRY.putObject(Items.SPLASH_POTION, new IBehaviorDispenseItem(){

            @Override
            public ItemStack dispense(IBlockSource p_dispense_1_, final ItemStack p_dispense_2_) {
                return new BehaviorProjectileDispense(){

                    @Override
                    protected IProjectile getProjectileEntity(World p_getProjectileEntity_1_, IPosition p_getProjectileEntity_2_, ItemStack p_getProjectileEntity_3_) {
                        return new EntityPotion(p_getProjectileEntity_1_, p_getProjectileEntity_2_.getX(), p_getProjectileEntity_2_.getY(), p_getProjectileEntity_2_.getZ(), p_dispense_2_.copy());
                    }

                    @Override
                    protected float getProjectileInaccuracy() {
                        return super.getProjectileInaccuracy() * 0.5f;
                    }

                    @Override
                    protected float getProjectileVelocity() {
                        return super.getProjectileVelocity() * 1.25f;
                    }
                }.dispense(p_dispense_1_, p_dispense_2_);
            }
        });
        BlockDispenser.DISPENSE_BEHAVIOR_REGISTRY.putObject(Items.LINGERING_POTION, new IBehaviorDispenseItem(){

            @Override
            public ItemStack dispense(IBlockSource p_dispense_1_, final ItemStack p_dispense_2_) {
                return new BehaviorProjectileDispense(){

                    @Override
                    protected IProjectile getProjectileEntity(World p_getProjectileEntity_1_, IPosition p_getProjectileEntity_2_, ItemStack p_getProjectileEntity_3_) {
                        return new EntityPotion(p_getProjectileEntity_1_, p_getProjectileEntity_2_.getX(), p_getProjectileEntity_2_.getY(), p_getProjectileEntity_2_.getZ(), p_dispense_2_.copy());
                    }

                    @Override
                    protected float getProjectileInaccuracy() {
                        return super.getProjectileInaccuracy() * 0.5f;
                    }

                    @Override
                    protected float getProjectileVelocity() {
                        return super.getProjectileVelocity() * 1.25f;
                    }
                }.dispense(p_dispense_1_, p_dispense_2_);
            }
        });
        BlockDispenser.DISPENSE_BEHAVIOR_REGISTRY.putObject(Items.SPAWN_EGG, new BehaviorDefaultDispenseItem(){

            @Override
            public ItemStack dispenseStack(IBlockSource p_dispenseStack_1_, ItemStack p_dispenseStack_2_) {
                EnumFacing enumfacing = p_dispenseStack_1_.getBlockState().getValue(BlockDispenser.FACING);
                double d0 = p_dispenseStack_1_.getX() + (double)enumfacing.getFrontOffsetX();
                double d1 = (float)(p_dispenseStack_1_.getBlockPos().getY() + enumfacing.getFrontOffsetY()) + 0.2f;
                double d2 = p_dispenseStack_1_.getZ() + (double)enumfacing.getFrontOffsetZ();
                Entity entity = ItemMonsterPlacer.spawnCreature(p_dispenseStack_1_.getWorld(), ItemMonsterPlacer.getNamedIdFrom(p_dispenseStack_2_), d0, d1, d2);
                if (entity instanceof EntityLivingBase && p_dispenseStack_2_.hasDisplayName()) {
                    entity.setCustomNameTag(p_dispenseStack_2_.getDisplayName());
                }
                ItemMonsterPlacer.applyItemEntityDataToEntity(p_dispenseStack_1_.getWorld(), null, p_dispenseStack_2_, entity);
                p_dispenseStack_2_.shrink(1);
                return p_dispenseStack_2_;
            }
        });
        BlockDispenser.DISPENSE_BEHAVIOR_REGISTRY.putObject(Items.FIREWORKS, new BehaviorDefaultDispenseItem(){

            @Override
            public ItemStack dispenseStack(IBlockSource p_dispenseStack_1_, ItemStack p_dispenseStack_2_) {
                EnumFacing enumfacing = p_dispenseStack_1_.getBlockState().getValue(BlockDispenser.FACING);
                double d0 = p_dispenseStack_1_.getX() + (double)enumfacing.getFrontOffsetX();
                double d1 = (float)p_dispenseStack_1_.getBlockPos().getY() + 0.2f;
                double d2 = p_dispenseStack_1_.getZ() + (double)enumfacing.getFrontOffsetZ();
                EntityFireworkRocket entityfireworkrocket = new EntityFireworkRocket(p_dispenseStack_1_.getWorld(), d0, d1, d2, p_dispenseStack_2_);
                p_dispenseStack_1_.getWorld().spawnEntity(entityfireworkrocket);
                p_dispenseStack_2_.shrink(1);
                return p_dispenseStack_2_;
            }

            @Override
            protected void playDispenseSound(IBlockSource p_playDispenseSound_1_) {
                p_playDispenseSound_1_.getWorld().playEvent(1004, p_playDispenseSound_1_.getBlockPos(), 0);
            }
        });
        BlockDispenser.DISPENSE_BEHAVIOR_REGISTRY.putObject(Items.FIRE_CHARGE, new BehaviorDefaultDispenseItem(){

            @Override
            public ItemStack dispenseStack(IBlockSource p_dispenseStack_1_, ItemStack p_dispenseStack_2_) {
                EnumFacing enumfacing = p_dispenseStack_1_.getBlockState().getValue(BlockDispenser.FACING);
                IPosition iposition = BlockDispenser.getDispensePosition(p_dispenseStack_1_);
                double d0 = iposition.getX() + (double)((float)enumfacing.getFrontOffsetX() * 0.3f);
                double d1 = iposition.getY() + (double)((float)enumfacing.getFrontOffsetY() * 0.3f);
                double d2 = iposition.getZ() + (double)((float)enumfacing.getFrontOffsetZ() * 0.3f);
                World world = p_dispenseStack_1_.getWorld();
                Random random = world.rand;
                double d3 = random.nextGaussian() * 0.05 + (double)enumfacing.getFrontOffsetX();
                double d4 = random.nextGaussian() * 0.05 + (double)enumfacing.getFrontOffsetY();
                double d5 = random.nextGaussian() * 0.05 + (double)enumfacing.getFrontOffsetZ();
                world.spawnEntity(new EntitySmallFireball(world, d0, d1, d2, d3, d4, d5));
                p_dispenseStack_2_.shrink(1);
                return p_dispenseStack_2_;
            }

            @Override
            protected void playDispenseSound(IBlockSource p_playDispenseSound_1_) {
                p_playDispenseSound_1_.getWorld().playEvent(1018, p_playDispenseSound_1_.getBlockPos(), 0);
            }
        });
        BlockDispenser.DISPENSE_BEHAVIOR_REGISTRY.putObject(Items.BOAT, new BehaviorDispenseBoat(EntityBoat.Type.OAK));
        BlockDispenser.DISPENSE_BEHAVIOR_REGISTRY.putObject(Items.SPRUCE_BOAT, new BehaviorDispenseBoat(EntityBoat.Type.SPRUCE));
        BlockDispenser.DISPENSE_BEHAVIOR_REGISTRY.putObject(Items.BIRCH_BOAT, new BehaviorDispenseBoat(EntityBoat.Type.BIRCH));
        BlockDispenser.DISPENSE_BEHAVIOR_REGISTRY.putObject(Items.JUNGLE_BOAT, new BehaviorDispenseBoat(EntityBoat.Type.JUNGLE));
        BlockDispenser.DISPENSE_BEHAVIOR_REGISTRY.putObject(Items.DARK_OAK_BOAT, new BehaviorDispenseBoat(EntityBoat.Type.DARK_OAK));
        BlockDispenser.DISPENSE_BEHAVIOR_REGISTRY.putObject(Items.ACACIA_BOAT, new BehaviorDispenseBoat(EntityBoat.Type.ACACIA));
        BehaviorDefaultDispenseItem ibehaviordispenseitem = new BehaviorDefaultDispenseItem(){
            private final BehaviorDefaultDispenseItem dispenseBehavior = new BehaviorDefaultDispenseItem();

            @Override
            public ItemStack dispenseStack(IBlockSource p_dispenseStack_1_, ItemStack p_dispenseStack_2_) {
                ItemBucket itembucket = (ItemBucket)p_dispenseStack_2_.getItem();
                BlockPos blockpos = p_dispenseStack_1_.getBlockPos().offset(p_dispenseStack_1_.getBlockState().getValue(BlockDispenser.FACING));
                return itembucket.tryPlaceContainedLiquid(null, p_dispenseStack_1_.getWorld(), blockpos) ? new ItemStack(Items.BUCKET) : this.dispenseBehavior.dispense(p_dispenseStack_1_, p_dispenseStack_2_);
            }
        };
        BlockDispenser.DISPENSE_BEHAVIOR_REGISTRY.putObject(Items.LAVA_BUCKET, ibehaviordispenseitem);
        BlockDispenser.DISPENSE_BEHAVIOR_REGISTRY.putObject(Items.WATER_BUCKET, ibehaviordispenseitem);
        BlockDispenser.DISPENSE_BEHAVIOR_REGISTRY.putObject(Items.MILK_BUCKET, DispenseFluidContainer.getInstance());
        BlockDispenser.DISPENSE_BEHAVIOR_REGISTRY.putObject(Items.BUCKET, DispenseFluidContainer.getInstance());
        BlockDispenser.DISPENSE_BEHAVIOR_REGISTRY.putObject(Items.FLINT_AND_STEEL, new BehaviorDispenseOptional(){

            @Override
            protected ItemStack dispenseStack(IBlockSource p_dispenseStack_1_, ItemStack p_dispenseStack_2_) {
                World world = p_dispenseStack_1_.getWorld();
                this.successful = true;
                BlockPos blockpos = p_dispenseStack_1_.getBlockPos().offset(p_dispenseStack_1_.getBlockState().getValue(BlockDispenser.FACING));
                if (world.isAirBlock(blockpos)) {
                    world.setBlockState(blockpos, Blocks.FIRE.getDefaultState());
                    if (p_dispenseStack_2_.attemptDamageItem(1, world.rand)) {
                        p_dispenseStack_2_.setCount(0);
                    }
                } else if (world.getBlockState(blockpos).getBlock() == Blocks.TNT) {
                    Blocks.TNT.onBlockDestroyedByPlayer(world, blockpos, Blocks.TNT.getDefaultState().withProperty(BlockTNT.EXPLODE, true));
                    world.setBlockToAir(blockpos);
                } else {
                    this.successful = false;
                }
                return p_dispenseStack_2_;
            }
        });
        BlockDispenser.DISPENSE_BEHAVIOR_REGISTRY.putObject(Items.DYE, new BehaviorDispenseOptional(){

            @Override
            protected ItemStack dispenseStack(IBlockSource p_dispenseStack_1_, ItemStack p_dispenseStack_2_) {
                this.successful = true;
                if (EnumDyeColor.WHITE == EnumDyeColor.byDyeDamage(p_dispenseStack_2_.getMetadata())) {
                    BlockPos blockpos;
                    World world = p_dispenseStack_1_.getWorld();
                    if (ItemDye.applyBonemeal(p_dispenseStack_2_, world, blockpos = p_dispenseStack_1_.getBlockPos().offset(p_dispenseStack_1_.getBlockState().getValue(BlockDispenser.FACING)))) {
                        if (!world.isRemote) {
                            world.playEvent(2005, blockpos, 0);
                        }
                    } else {
                        this.successful = false;
                    }
                    return p_dispenseStack_2_;
                }
                return super.dispenseStack(p_dispenseStack_1_, p_dispenseStack_2_);
            }
        });
        BlockDispenser.DISPENSE_BEHAVIOR_REGISTRY.putObject(Item.getItemFromBlock(Blocks.TNT), new BehaviorDefaultDispenseItem(){

            @Override
            protected ItemStack dispenseStack(IBlockSource p_dispenseStack_1_, ItemStack p_dispenseStack_2_) {
                World world = p_dispenseStack_1_.getWorld();
                BlockPos blockpos = p_dispenseStack_1_.getBlockPos().offset(p_dispenseStack_1_.getBlockState().getValue(BlockDispenser.FACING));
                EntityTNTPrimed entitytntprimed = new EntityTNTPrimed(world, (double)blockpos.getX() + 0.5, blockpos.getY(), (double)blockpos.getZ() + 0.5, null);
                world.spawnEntity(entitytntprimed);
                world.playSound(null, entitytntprimed.posX, entitytntprimed.posY, entitytntprimed.posZ, SoundEvents.ENTITY_TNT_PRIMED, SoundCategory.BLOCKS, 1.0f, 1.0f);
                p_dispenseStack_2_.shrink(1);
                return p_dispenseStack_2_;
            }
        });
        BlockDispenser.DISPENSE_BEHAVIOR_REGISTRY.putObject(Items.SKULL, new BehaviorDispenseOptional(){

            @Override
            protected ItemStack dispenseStack(IBlockSource p_dispenseStack_1_, ItemStack p_dispenseStack_2_) {
                World world = p_dispenseStack_1_.getWorld();
                EnumFacing enumfacing = p_dispenseStack_1_.getBlockState().getValue(BlockDispenser.FACING);
                BlockPos blockpos = p_dispenseStack_1_.getBlockPos().offset(enumfacing);
                BlockSkull blockskull = Blocks.SKULL;
                this.successful = true;
                if (world.isAirBlock(blockpos) && blockskull.canDispenserPlace(world, blockpos, p_dispenseStack_2_)) {
                    if (!world.isRemote) {
                        world.setBlockState(blockpos, blockskull.getDefaultState().withProperty(BlockSkull.FACING, EnumFacing.UP), 3);
                        TileEntity tileentity = world.getTileEntity(blockpos);
                        if (tileentity instanceof TileEntitySkull) {
                            if (p_dispenseStack_2_.getMetadata() == 3) {
                                GameProfile gameprofile = null;
                                if (p_dispenseStack_2_.hasTagCompound()) {
                                    String s;
                                    NBTTagCompound nbttagcompound = p_dispenseStack_2_.getTagCompound();
                                    if (nbttagcompound.hasKey("SkullOwner", 10)) {
                                        gameprofile = NBTUtil.readGameProfileFromNBT(nbttagcompound.getCompoundTag("SkullOwner"));
                                    } else if (nbttagcompound.hasKey("SkullOwner", 8) && !StringUtils.isNullOrEmpty(s = nbttagcompound.getString("SkullOwner"))) {
                                        gameprofile = new GameProfile((UUID)null, s);
                                    }
                                }
                                ((TileEntitySkull)tileentity).setPlayerProfile(gameprofile);
                            } else {
                                ((TileEntitySkull)tileentity).setType(p_dispenseStack_2_.getMetadata());
                            }
                            ((TileEntitySkull)tileentity).setSkullRotation(enumfacing.getOpposite().getHorizontalIndex() * 4);
                            Blocks.SKULL.checkWitherSpawn(world, blockpos, (TileEntitySkull)tileentity);
                        }
                        p_dispenseStack_2_.shrink(1);
                    }
                } else if (ItemArmor.dispenseArmor(p_dispenseStack_1_, p_dispenseStack_2_).isEmpty()) {
                    this.successful = false;
                }
                return p_dispenseStack_2_;
            }
        });
        BlockDispenser.DISPENSE_BEHAVIOR_REGISTRY.putObject(Item.getItemFromBlock(Blocks.PUMPKIN), new BehaviorDispenseOptional(){

            @Override
            protected ItemStack dispenseStack(IBlockSource p_dispenseStack_1_, ItemStack p_dispenseStack_2_) {
                World world = p_dispenseStack_1_.getWorld();
                BlockPos blockpos = p_dispenseStack_1_.getBlockPos().offset(p_dispenseStack_1_.getBlockState().getValue(BlockDispenser.FACING));
                BlockPumpkin blockpumpkin = (BlockPumpkin)Blocks.PUMPKIN;
                this.successful = true;
                if (world.isAirBlock(blockpos) && blockpumpkin.canDispenserPlace(world, blockpos)) {
                    if (!world.isRemote) {
                        world.setBlockState(blockpos, blockpumpkin.getDefaultState(), 3);
                    }
                    p_dispenseStack_2_.shrink(1);
                } else {
                    ItemStack itemstack = ItemArmor.dispenseArmor(p_dispenseStack_1_, p_dispenseStack_2_);
                    if (itemstack.isEmpty()) {
                        this.successful = false;
                    }
                }
                return p_dispenseStack_2_;
            }
        });
        for (EnumDyeColor enumdyecolor : EnumDyeColor.values()) {
            BlockDispenser.DISPENSE_BEHAVIOR_REGISTRY.putObject(Item.getItemFromBlock(BlockShulkerBox.getBlockByColor(enumdyecolor)), new BehaviorDispenseShulkerBox());
        }
    }

    public static void register() {
        if (!alreadyRegistered) {
            alreadyRegistered = true;
            Bootstrap.redirectOutputToLog();
            SoundEvent.registerSounds();
            Block.registerBlocks();
            BlockFire.init();
            Potion.registerPotions();
            Enchantment.registerEnchantments();
            Item.registerItems();
            PotionType.registerPotionTypes();
            PotionHelper.init();
            EntityList.init();
            StatList.init();
            Biome.registerBiomes();
            Bootstrap.registerDispenserBehaviors();
            GameData.vanillaSnapshot();
        }
    }

    private static void redirectOutputToLog() {
        if (LOGGER.isDebugEnabled()) {
            System.setErr(new DebugLoggingPrintStream("STDERR", System.err));
            System.setOut(new DebugLoggingPrintStream("STDOUT", SYSOUT));
        } else {
            System.setErr(new LoggingPrintStream("STDERR", System.err));
            System.setOut(new LoggingPrintStream("STDOUT", SYSOUT));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void printToSYSOUT(String p_printToSYSOUT_0_) {
        SYSOUT.println(p_printToSYSOUT_0_);
    }

    static {
        LOGGER = LogManager.getLogger();
    }

    static class BehaviorDispenseShulkerBox
    extends BehaviorDispenseOptional {
        private BehaviorDispenseShulkerBox() {
        }

        @Override
        protected ItemStack dispenseStack(IBlockSource p_dispenseStack_1_, ItemStack p_dispenseStack_2_) {
            Block block = Block.getBlockFromItem(p_dispenseStack_2_.getItem());
            World world = p_dispenseStack_1_.getWorld();
            EnumFacing enumfacing = p_dispenseStack_1_.getBlockState().getValue(BlockDispenser.FACING);
            BlockPos blockpos = p_dispenseStack_1_.getBlockPos().offset(enumfacing);
            this.successful = world.mayPlace(block, blockpos, false, EnumFacing.DOWN, null);
            if (this.successful) {
                EnumFacing enumfacing1 = world.isAirBlock(blockpos.down()) ? enumfacing : EnumFacing.UP;
                IBlockState iblockstate = block.getDefaultState().withProperty(BlockShulkerBox.FACING, enumfacing1);
                world.setBlockState(blockpos, iblockstate);
                TileEntity tileentity = world.getTileEntity(blockpos);
                ItemStack itemstack = p_dispenseStack_2_.splitStack(1);
                if (itemstack.hasTagCompound()) {
                    ((TileEntityShulkerBox)tileentity).loadFromNbt(itemstack.getTagCompound().getCompoundTag("BlockEntityTag"));
                }
                if (itemstack.hasDisplayName()) {
                    ((TileEntityShulkerBox)tileentity).setCustomName(itemstack.getDisplayName());
                }
                world.updateComparatorOutputLevel(blockpos, iblockstate.getBlock());
            }
            return p_dispenseStack_2_;
        }
    }

    public static abstract class BehaviorDispenseOptional
    extends BehaviorDefaultDispenseItem {
        protected boolean successful = true;

        @Override
        protected void playDispenseSound(IBlockSource p_playDispenseSound_1_) {
            p_playDispenseSound_1_.getWorld().playEvent(this.successful ? 1000 : 1001, p_playDispenseSound_1_.getBlockPos(), 0);
        }
    }

    public static class BehaviorDispenseBoat
    extends BehaviorDefaultDispenseItem {
        private final BehaviorDefaultDispenseItem dispenseBehavior = new BehaviorDefaultDispenseItem();
        private final EntityBoat.Type boatType;

        public BehaviorDispenseBoat(EntityBoat.Type p_i47023_1_) {
            this.boatType = p_i47023_1_;
        }

        @Override
        public ItemStack dispenseStack(IBlockSource p_dispenseStack_1_, ItemStack p_dispenseStack_2_) {
            double d3;
            EnumFacing enumfacing = p_dispenseStack_1_.getBlockState().getValue(BlockDispenser.FACING);
            World world = p_dispenseStack_1_.getWorld();
            double d0 = p_dispenseStack_1_.getX() + (double)((float)enumfacing.getFrontOffsetX() * 1.125f);
            double d1 = p_dispenseStack_1_.getY() + (double)((float)enumfacing.getFrontOffsetY() * 1.125f);
            double d2 = p_dispenseStack_1_.getZ() + (double)((float)enumfacing.getFrontOffsetZ() * 1.125f);
            BlockPos blockpos = p_dispenseStack_1_.getBlockPos().offset(enumfacing);
            Material material = world.getBlockState(blockpos).getMaterial();
            if (Material.WATER.equals(material)) {
                d3 = 1.0;
            } else {
                if (!Material.AIR.equals(material) || !Material.WATER.equals(world.getBlockState(blockpos.down()).getMaterial())) {
                    return this.dispenseBehavior.dispense(p_dispenseStack_1_, p_dispenseStack_2_);
                }
                d3 = 0.0;
            }
            EntityBoat entityboat = new EntityBoat(world, d0, d1 + d3, d2);
            entityboat.setBoatType(this.boatType);
            entityboat.rotationYaw = enumfacing.getHorizontalAngle();
            world.spawnEntity(entityboat);
            p_dispenseStack_2_.shrink(1);
            return p_dispenseStack_2_;
        }

        @Override
        protected void playDispenseSound(IBlockSource p_playDispenseSound_1_) {
            p_playDispenseSound_1_.getWorld().playEvent(1000, p_playDispenseSound_1_.getBlockPos(), 0);
        }
    }
}

