/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.inventory;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class Container {
    public NonNullList<ItemStack> inventoryItemStacks = NonNullList.create();
    public List<Slot> inventorySlots = Lists.newArrayList();
    public int windowId;
    @SideOnly(value=Side.CLIENT)
    private short transactionID;
    private int dragMode = -1;
    private int dragEvent;
    private final Set<Slot> dragSlots = Sets.newHashSet();
    protected List<IContainerListener> listeners = Lists.newArrayList();
    private final Set<EntityPlayer> playerList = Sets.newHashSet();

    protected Slot addSlotToContainer(Slot p_addSlotToContainer_1_) {
        p_addSlotToContainer_1_.slotNumber = this.inventorySlots.size();
        this.inventorySlots.add(p_addSlotToContainer_1_);
        this.inventoryItemStacks.add(ItemStack.EMPTY);
        return p_addSlotToContainer_1_;
    }

    public void addListener(IContainerListener p_addListener_1_) {
        if (this.listeners.contains(p_addListener_1_)) {
            throw new IllegalArgumentException("Listener already listening");
        }
        this.listeners.add(p_addListener_1_);
        p_addListener_1_.updateCraftingInventory(this, this.getInventory());
        this.detectAndSendChanges();
    }

    public NonNullList<ItemStack> getInventory() {
        NonNullList<ItemStack> nonnulllist = NonNullList.create();
        for (int i = 0; i < this.inventorySlots.size(); ++i) {
            nonnulllist.add(this.inventorySlots.get(i).getStack());
        }
        return nonnulllist;
    }

    @SideOnly(value=Side.CLIENT)
    public void removeListener(IContainerListener p_removeListener_1_) {
        this.listeners.remove(p_removeListener_1_);
    }

    public void detectAndSendChanges() {
        for (int i = 0; i < this.inventorySlots.size(); ++i) {
            ItemStack itemstack = this.inventorySlots.get(i).getStack();
            ItemStack itemstack1 = this.inventoryItemStacks.get(i);
            if (ItemStack.areItemStacksEqual(itemstack1, itemstack)) continue;
            itemstack1 = itemstack.isEmpty() ? ItemStack.EMPTY : itemstack.copy();
            this.inventoryItemStacks.set(i, itemstack1);
            for (int j = 0; j < this.listeners.size(); ++j) {
                this.listeners.get(j).sendSlotContents(this, i, itemstack1);
            }
        }
    }

    public boolean enchantItem(EntityPlayer p_enchantItem_1_, int p_enchantItem_2_) {
        return false;
    }

    @Nullable
    public Slot getSlotFromInventory(IInventory p_getSlotFromInventory_1_, int p_getSlotFromInventory_2_) {
        for (int i = 0; i < this.inventorySlots.size(); ++i) {
            Slot slot = this.inventorySlots.get(i);
            if (!slot.isHere(p_getSlotFromInventory_1_, p_getSlotFromInventory_2_)) continue;
            return slot;
        }
        return null;
    }

    public Slot getSlot(int p_getSlot_1_) {
        return this.inventorySlots.get(p_getSlot_1_);
    }

    public ItemStack transferStackInSlot(EntityPlayer p_transferStackInSlot_1_, int p_transferStackInSlot_2_) {
        Slot slot = this.inventorySlots.get(p_transferStackInSlot_2_);
        return slot != null ? slot.getStack() : ItemStack.EMPTY;
    }

    public ItemStack slotClick(int p_slotClick_1_, int p_slotClick_2_, ClickType p_slotClick_3_, EntityPlayer p_slotClick_4_) {
        ItemStack itemstack = ItemStack.EMPTY;
        InventoryPlayer inventoryplayer = p_slotClick_4_.inventory;
        if (p_slotClick_3_ == ClickType.QUICK_CRAFT) {
            int i = this.dragEvent;
            this.dragEvent = Container.getDragEvent(p_slotClick_2_);
            if ((i != 1 || this.dragEvent != 2) && i != this.dragEvent) {
                this.resetDrag();
            } else if (inventoryplayer.getItemStack().isEmpty()) {
                this.resetDrag();
            } else if (this.dragEvent == 0) {
                this.dragMode = Container.extractDragMode(p_slotClick_2_);
                if (Container.isValidDragMode(this.dragMode, p_slotClick_4_)) {
                    this.dragEvent = 1;
                    this.dragSlots.clear();
                } else {
                    this.resetDrag();
                }
            } else if (this.dragEvent == 1) {
                Slot slot = this.inventorySlots.get(p_slotClick_1_);
                ItemStack itemstack1 = inventoryplayer.getItemStack();
                if (slot != null && Container.canAddItemToSlot(slot, itemstack1, true) && slot.isItemValid(itemstack1) && (this.dragMode == 2 || itemstack1.getCount() > this.dragSlots.size()) && this.canDragIntoSlot(slot)) {
                    this.dragSlots.add(slot);
                }
            } else if (this.dragEvent == 2) {
                if (!this.dragSlots.isEmpty()) {
                    ItemStack itemstack5 = inventoryplayer.getItemStack().copy();
                    int l = inventoryplayer.getItemStack().getCount();
                    for (Slot slot1 : this.dragSlots) {
                        ItemStack itemstack2 = inventoryplayer.getItemStack();
                        if (slot1 == null || !Container.canAddItemToSlot(slot1, itemstack2, true) || !slot1.isItemValid(itemstack2) || this.dragMode != 2 && itemstack2.getCount() < this.dragSlots.size() || !this.canDragIntoSlot(slot1)) continue;
                        ItemStack itemstack3 = itemstack5.copy();
                        int j = slot1.getHasStack() ? slot1.getStack().getCount() : 0;
                        Container.computeStackSize(this.dragSlots, this.dragMode, itemstack3, j);
                        int k = Math.min(itemstack3.getMaxStackSize(), slot1.getItemStackLimit(itemstack3));
                        if (itemstack3.getCount() > k) {
                            itemstack3.setCount(k);
                        }
                        l -= itemstack3.getCount() - j;
                        slot1.putStack(itemstack3);
                    }
                    itemstack5.setCount(l);
                    inventoryplayer.setItemStack(itemstack5);
                }
                this.resetDrag();
            } else {
                this.resetDrag();
            }
        } else if (this.dragEvent != 0) {
            this.resetDrag();
        } else if (!(p_slotClick_3_ != ClickType.PICKUP && p_slotClick_3_ != ClickType.QUICK_MOVE || p_slotClick_2_ != 0 && p_slotClick_2_ != 1)) {
            if (p_slotClick_1_ == -999) {
                if (!inventoryplayer.getItemStack().isEmpty()) {
                    if (p_slotClick_2_ == 0) {
                        p_slotClick_4_.dropItem(inventoryplayer.getItemStack(), true);
                        inventoryplayer.setItemStack(ItemStack.EMPTY);
                    }
                    if (p_slotClick_2_ == 1) {
                        p_slotClick_4_.dropItem(inventoryplayer.getItemStack().splitStack(1), true);
                    }
                }
            } else if (p_slotClick_3_ == ClickType.QUICK_MOVE) {
                ItemStack itemstack10;
                if (p_slotClick_1_ < 0) {
                    return ItemStack.EMPTY;
                }
                Slot slot6 = this.inventorySlots.get(p_slotClick_1_);
                if (slot6 != null && slot6.canTakeStack(p_slotClick_4_) && !(itemstack10 = this.transferStackInSlot(p_slotClick_4_, p_slotClick_1_)).isEmpty()) {
                    Item item = itemstack10.getItem();
                    itemstack = itemstack10.copy();
                    if (slot6.getStack().getItem() == item) {
                        this.retrySlotClick(p_slotClick_1_, p_slotClick_2_, true, p_slotClick_4_);
                    }
                }
            } else {
                if (p_slotClick_1_ < 0) {
                    return ItemStack.EMPTY;
                }
                Slot slot7 = this.inventorySlots.get(p_slotClick_1_);
                if (slot7 != null) {
                    ItemStack itemstack11 = slot7.getStack();
                    ItemStack itemstack13 = inventoryplayer.getItemStack();
                    if (!itemstack11.isEmpty()) {
                        itemstack = itemstack11.copy();
                    }
                    if (itemstack11.isEmpty()) {
                        if (!itemstack13.isEmpty() && slot7.isItemValid(itemstack13)) {
                            int l2;
                            int n = l2 = p_slotClick_2_ == 0 ? itemstack13.getCount() : 1;
                            if (l2 > slot7.getItemStackLimit(itemstack13)) {
                                l2 = slot7.getItemStackLimit(itemstack13);
                            }
                            slot7.putStack(itemstack13.splitStack(l2));
                        }
                    } else if (slot7.canTakeStack(p_slotClick_4_)) {
                        int i2;
                        if (itemstack13.isEmpty()) {
                            if (itemstack11.isEmpty()) {
                                slot7.putStack(ItemStack.EMPTY);
                                inventoryplayer.setItemStack(ItemStack.EMPTY);
                            } else {
                                int k2 = p_slotClick_2_ == 0 ? itemstack11.getCount() : (itemstack11.getCount() + 1) / 2;
                                inventoryplayer.setItemStack(slot7.decrStackSize(k2));
                                if (itemstack11.isEmpty()) {
                                    slot7.putStack(ItemStack.EMPTY);
                                }
                                slot7.onTake(p_slotClick_4_, inventoryplayer.getItemStack());
                            }
                        } else if (slot7.isItemValid(itemstack13)) {
                            if (itemstack11.getItem() == itemstack13.getItem() && itemstack11.getMetadata() == itemstack13.getMetadata() && ItemStack.areItemStackTagsEqual(itemstack11, itemstack13)) {
                                int j2;
                                int n = j2 = p_slotClick_2_ == 0 ? itemstack13.getCount() : 1;
                                if (j2 > slot7.getItemStackLimit(itemstack13) - itemstack11.getCount()) {
                                    j2 = slot7.getItemStackLimit(itemstack13) - itemstack11.getCount();
                                }
                                if (j2 > itemstack13.getMaxStackSize() - itemstack11.getCount()) {
                                    j2 = itemstack13.getMaxStackSize() - itemstack11.getCount();
                                }
                                itemstack13.shrink(j2);
                                itemstack11.grow(j2);
                            } else if (itemstack13.getCount() <= slot7.getItemStackLimit(itemstack13)) {
                                slot7.putStack(itemstack13);
                                inventoryplayer.setItemStack(itemstack11);
                            }
                        } else if (!(itemstack11.getItem() != itemstack13.getItem() || itemstack13.getMaxStackSize() <= 1 || itemstack11.getHasSubtypes() && itemstack11.getMetadata() != itemstack13.getMetadata() || !ItemStack.areItemStackTagsEqual(itemstack11, itemstack13) || itemstack11.isEmpty() || (i2 = itemstack11.getCount()) + itemstack13.getCount() > itemstack13.getMaxStackSize())) {
                            itemstack13.grow(i2);
                            itemstack11 = slot7.decrStackSize(i2);
                            if (itemstack11.isEmpty()) {
                                slot7.putStack(ItemStack.EMPTY);
                            }
                            slot7.onTake(p_slotClick_4_, inventoryplayer.getItemStack());
                        }
                    }
                    slot7.onSlotChanged();
                }
            }
        } else if (p_slotClick_3_ == ClickType.SWAP && p_slotClick_2_ >= 0 && p_slotClick_2_ < 9) {
            Slot slot5 = this.inventorySlots.get(p_slotClick_1_);
            ItemStack itemstack9 = inventoryplayer.getStackInSlot(p_slotClick_2_);
            ItemStack itemstack12 = slot5.getStack();
            if (!itemstack9.isEmpty() || !itemstack12.isEmpty()) {
                if (itemstack9.isEmpty()) {
                    if (slot5.canTakeStack(p_slotClick_4_)) {
                        inventoryplayer.setInventorySlotContents(p_slotClick_2_, itemstack12);
                        slot5.onSwapCraft(itemstack12.getCount());
                        slot5.putStack(ItemStack.EMPTY);
                        slot5.onTake(p_slotClick_4_, itemstack12);
                    }
                } else if (itemstack12.isEmpty()) {
                    if (slot5.isItemValid(itemstack9)) {
                        int k1 = slot5.getItemStackLimit(itemstack9);
                        if (itemstack9.getCount() > k1) {
                            slot5.putStack(itemstack9.splitStack(k1));
                        } else {
                            slot5.putStack(itemstack9);
                            inventoryplayer.setInventorySlotContents(p_slotClick_2_, ItemStack.EMPTY);
                        }
                    }
                } else if (slot5.canTakeStack(p_slotClick_4_) && slot5.isItemValid(itemstack9)) {
                    int l1 = slot5.getItemStackLimit(itemstack9);
                    if (itemstack9.getCount() > l1) {
                        slot5.putStack(itemstack9.splitStack(l1));
                        slot5.onTake(p_slotClick_4_, itemstack12);
                        if (!inventoryplayer.addItemStackToInventory(itemstack12)) {
                            p_slotClick_4_.dropItem(itemstack12, true);
                        }
                    } else {
                        slot5.putStack(itemstack9);
                        inventoryplayer.setInventorySlotContents(p_slotClick_2_, itemstack12);
                        slot5.onTake(p_slotClick_4_, itemstack12);
                    }
                }
            }
        } else if (p_slotClick_3_ == ClickType.CLONE && p_slotClick_4_.capabilities.isCreativeMode && inventoryplayer.getItemStack().isEmpty() && p_slotClick_1_ >= 0) {
            Slot slot4 = this.inventorySlots.get(p_slotClick_1_);
            if (slot4 != null && slot4.getHasStack()) {
                ItemStack itemstack8 = slot4.getStack().copy();
                itemstack8.setCount(itemstack8.getMaxStackSize());
                inventoryplayer.setItemStack(itemstack8);
            }
        } else if (p_slotClick_3_ == ClickType.THROW && inventoryplayer.getItemStack().isEmpty() && p_slotClick_1_ >= 0) {
            Slot slot3 = this.inventorySlots.get(p_slotClick_1_);
            if (slot3 != null && slot3.getHasStack() && slot3.canTakeStack(p_slotClick_4_)) {
                ItemStack itemstack7 = slot3.decrStackSize(p_slotClick_2_ == 0 ? 1 : slot3.getStack().getCount());
                slot3.onTake(p_slotClick_4_, itemstack7);
                p_slotClick_4_.dropItem(itemstack7, true);
            }
        } else if (p_slotClick_3_ == ClickType.PICKUP_ALL && p_slotClick_1_ >= 0) {
            Slot slot2 = this.inventorySlots.get(p_slotClick_1_);
            ItemStack itemstack6 = inventoryplayer.getItemStack();
            if (!(itemstack6.isEmpty() || slot2 != null && slot2.getHasStack() && slot2.canTakeStack(p_slotClick_4_))) {
                int i1 = p_slotClick_2_ == 0 ? 0 : this.inventorySlots.size() - 1;
                int j1 = p_slotClick_2_ == 0 ? 1 : -1;
                for (int i3 = 0; i3 < 2; ++i3) {
                    for (int j3 = i1; j3 >= 0 && j3 < this.inventorySlots.size() && itemstack6.getCount() < itemstack6.getMaxStackSize(); j3 += j1) {
                        Slot slot8 = this.inventorySlots.get(j3);
                        if (!slot8.getHasStack() || !Container.canAddItemToSlot(slot8, itemstack6, true) || !slot8.canTakeStack(p_slotClick_4_) || !this.canMergeSlot(itemstack6, slot8)) continue;
                        ItemStack itemstack14 = slot8.getStack();
                        if (i3 == 0 && itemstack14.getCount() == itemstack14.getMaxStackSize()) continue;
                        int k3 = Math.min(itemstack6.getMaxStackSize() - itemstack6.getCount(), itemstack14.getCount());
                        ItemStack itemstack4 = slot8.decrStackSize(k3);
                        itemstack6.grow(k3);
                        if (itemstack4.isEmpty()) {
                            slot8.putStack(ItemStack.EMPTY);
                        }
                        slot8.onTake(p_slotClick_4_, itemstack4);
                    }
                }
            }
            this.detectAndSendChanges();
        }
        return itemstack;
    }

    public boolean canMergeSlot(ItemStack p_canMergeSlot_1_, Slot p_canMergeSlot_2_) {
        return true;
    }

    protected void retrySlotClick(int p_retrySlotClick_1_, int p_retrySlotClick_2_, boolean p_retrySlotClick_3_, EntityPlayer p_retrySlotClick_4_) {
        this.slotClick(p_retrySlotClick_1_, p_retrySlotClick_2_, ClickType.QUICK_MOVE, p_retrySlotClick_4_);
    }

    public void onContainerClosed(EntityPlayer p_onContainerClosed_1_) {
        InventoryPlayer inventoryplayer = p_onContainerClosed_1_.inventory;
        if (!inventoryplayer.getItemStack().isEmpty()) {
            p_onContainerClosed_1_.dropItem(inventoryplayer.getItemStack(), false);
            inventoryplayer.setItemStack(ItemStack.EMPTY);
        }
    }

    public void onCraftMatrixChanged(IInventory p_onCraftMatrixChanged_1_) {
        this.detectAndSendChanges();
    }

    public void putStackInSlot(int p_putStackInSlot_1_, ItemStack p_putStackInSlot_2_) {
        this.getSlot(p_putStackInSlot_1_).putStack(p_putStackInSlot_2_);
    }

    @SideOnly(value=Side.CLIENT)
    public void setAll(List<ItemStack> p_setAll_1_) {
        for (int i = 0; i < p_setAll_1_.size(); ++i) {
            this.getSlot(i).putStack(p_setAll_1_.get(i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void updateProgressBar(int p_updateProgressBar_1_, int p_updateProgressBar_2_) {
    }

    @SideOnly(value=Side.CLIENT)
    public short getNextTransactionID(InventoryPlayer p_getNextTransactionID_1_) {
        this.transactionID = (short)(this.transactionID + 1);
        return this.transactionID;
    }

    public boolean getCanCraft(EntityPlayer p_getCanCraft_1_) {
        return !this.playerList.contains(p_getCanCraft_1_);
    }

    public void setCanCraft(EntityPlayer p_setCanCraft_1_, boolean p_setCanCraft_2_) {
        if (p_setCanCraft_2_) {
            this.playerList.remove(p_setCanCraft_1_);
        } else {
            this.playerList.add(p_setCanCraft_1_);
        }
    }

    public abstract boolean canInteractWith(EntityPlayer var1);

    protected boolean mergeItemStack(ItemStack p_mergeItemStack_1_, int p_mergeItemStack_2_, int p_mergeItemStack_3_, boolean p_mergeItemStack_4_) {
        boolean flag = false;
        int i = p_mergeItemStack_2_;
        if (p_mergeItemStack_4_) {
            i = p_mergeItemStack_3_ - 1;
        }
        if (p_mergeItemStack_1_.isStackable()) {
            while (!p_mergeItemStack_1_.isEmpty() && !(!p_mergeItemStack_4_ ? i >= p_mergeItemStack_3_ : i < p_mergeItemStack_2_)) {
                Slot slot = this.inventorySlots.get(i);
                ItemStack itemstack = slot.getStack();
                if (!(itemstack.isEmpty() || itemstack.getItem() != p_mergeItemStack_1_.getItem() || p_mergeItemStack_1_.getHasSubtypes() && p_mergeItemStack_1_.getMetadata() != itemstack.getMetadata() || !ItemStack.areItemStackTagsEqual(p_mergeItemStack_1_, itemstack))) {
                    int maxSize;
                    int j = itemstack.getCount() + p_mergeItemStack_1_.getCount();
                    if (j <= (maxSize = Math.min(slot.getSlotStackLimit(), p_mergeItemStack_1_.getMaxStackSize()))) {
                        p_mergeItemStack_1_.setCount(0);
                        itemstack.setCount(j);
                        slot.onSlotChanged();
                        flag = true;
                    } else if (itemstack.getCount() < maxSize) {
                        p_mergeItemStack_1_.shrink(maxSize - itemstack.getCount());
                        itemstack.setCount(maxSize);
                        slot.onSlotChanged();
                        flag = true;
                    }
                }
                if (p_mergeItemStack_4_) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!p_mergeItemStack_1_.isEmpty()) {
            i = p_mergeItemStack_4_ ? p_mergeItemStack_3_ - 1 : p_mergeItemStack_2_;
            while (!(!p_mergeItemStack_4_ ? i >= p_mergeItemStack_3_ : i < p_mergeItemStack_2_)) {
                Slot slot1 = this.inventorySlots.get(i);
                ItemStack itemstack1 = slot1.getStack();
                if (itemstack1.isEmpty() && slot1.isItemValid(p_mergeItemStack_1_)) {
                    if (p_mergeItemStack_1_.getCount() > slot1.getSlotStackLimit()) {
                        slot1.putStack(p_mergeItemStack_1_.splitStack(slot1.getSlotStackLimit()));
                    } else {
                        slot1.putStack(p_mergeItemStack_1_.splitStack(p_mergeItemStack_1_.getCount()));
                    }
                    slot1.onSlotChanged();
                    flag = true;
                    break;
                }
                if (p_mergeItemStack_4_) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public static int extractDragMode(int p_extractDragMode_0_) {
        return p_extractDragMode_0_ >> 2 & 3;
    }

    public static int getDragEvent(int p_getDragEvent_0_) {
        return p_getDragEvent_0_ & 3;
    }

    @SideOnly(value=Side.CLIENT)
    public static int getQuickcraftMask(int p_getQuickcraftMask_0_, int p_getQuickcraftMask_1_) {
        return p_getQuickcraftMask_0_ & 3 | (p_getQuickcraftMask_1_ & 3) << 2;
    }

    public static boolean isValidDragMode(int p_isValidDragMode_0_, EntityPlayer p_isValidDragMode_1_) {
        return p_isValidDragMode_0_ == 0 ? true : (p_isValidDragMode_0_ == 1 ? true : p_isValidDragMode_0_ == 2 && p_isValidDragMode_1_.capabilities.isCreativeMode);
    }

    protected void resetDrag() {
        this.dragEvent = 0;
        this.dragSlots.clear();
    }

    public static boolean canAddItemToSlot(Slot p_canAddItemToSlot_0_, ItemStack p_canAddItemToSlot_1_, boolean p_canAddItemToSlot_2_) {
        boolean flag;
        boolean bl = flag = p_canAddItemToSlot_0_ == null || !p_canAddItemToSlot_0_.getHasStack();
        return !flag && p_canAddItemToSlot_1_.isItemEqual(p_canAddItemToSlot_0_.getStack()) && ItemStack.areItemStackTagsEqual(p_canAddItemToSlot_0_.getStack(), p_canAddItemToSlot_1_) ? p_canAddItemToSlot_0_.getStack().getCount() + (p_canAddItemToSlot_2_ ? 0 : p_canAddItemToSlot_1_.getCount()) <= p_canAddItemToSlot_1_.getMaxStackSize() : flag;
    }

    public static void computeStackSize(Set<Slot> p_computeStackSize_0_, int p_computeStackSize_1_, ItemStack p_computeStackSize_2_, int p_computeStackSize_3_) {
        switch (p_computeStackSize_1_) {
            case 0: {
                p_computeStackSize_2_.setCount(MathHelper.floor((float)p_computeStackSize_2_.getCount() / (float)p_computeStackSize_0_.size()));
                break;
            }
            case 1: {
                p_computeStackSize_2_.setCount(1);
                break;
            }
            case 2: {
                p_computeStackSize_2_.setCount(p_computeStackSize_2_.getMaxStackSize());
            }
        }
        p_computeStackSize_2_.grow(p_computeStackSize_3_);
    }

    public boolean canDragIntoSlot(Slot p_canDragIntoSlot_1_) {
        return true;
    }

    public static int calcRedstone(TileEntity p_calcRedstone_0_) {
        return p_calcRedstone_0_ instanceof IInventory ? Container.calcRedstoneFromInventory((IInventory)((Object)p_calcRedstone_0_)) : 0;
    }

    public static int calcRedstoneFromInventory(IInventory p_calcRedstoneFromInventory_0_) {
        if (p_calcRedstoneFromInventory_0_ == null) {
            return 0;
        }
        int i = 0;
        float f = 0.0f;
        for (int j = 0; j < p_calcRedstoneFromInventory_0_.getSizeInventory(); ++j) {
            ItemStack itemstack = p_calcRedstoneFromInventory_0_.getStackInSlot(j);
            if (itemstack.isEmpty()) continue;
            f += (float)itemstack.getCount() / (float)Math.min(p_calcRedstoneFromInventory_0_.getInventoryStackLimit(), itemstack.getMaxStackSize());
            ++i;
        }
        return MathHelper.floor((f /= (float)p_calcRedstoneFromInventory_0_.getSizeInventory()) * 14.0f) + (i > 0 ? 1 : 0);
    }
}

