/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ContainerBeacon
extends Container {
    private final IInventory tileBeacon;
    private final BeaconSlot beaconSlot;

    public ContainerBeacon(IInventory p_i45804_1_, IInventory p_i45804_2_) {
        this.tileBeacon = p_i45804_2_;
        this.beaconSlot = new BeaconSlot(p_i45804_2_, 0, 136, 110);
        this.addSlotToContainer(this.beaconSlot);
        int i = 36;
        int j = 137;
        for (int k = 0; k < 3; ++k) {
            for (int l = 0; l < 9; ++l) {
                this.addSlotToContainer(new Slot(p_i45804_1_, l + k * 9 + 9, 36 + l * 18, 137 + k * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.addSlotToContainer(new Slot(p_i45804_1_, i1, 36 + i1 * 18, 195));
        }
    }

    @Override
    public void addListener(IContainerListener p_addListener_1_) {
        super.addListener(p_addListener_1_);
        p_addListener_1_.sendAllWindowProperties(this, this.tileBeacon);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateProgressBar(int p_updateProgressBar_1_, int p_updateProgressBar_2_) {
        this.tileBeacon.setField(p_updateProgressBar_1_, p_updateProgressBar_2_);
    }

    public IInventory getTileEntity() {
        return this.tileBeacon;
    }

    @Override
    public void onContainerClosed(EntityPlayer p_onContainerClosed_1_) {
        ItemStack itemstack;
        super.onContainerClosed(p_onContainerClosed_1_);
        if (p_onContainerClosed_1_ != null && !p_onContainerClosed_1_.world.isRemote && !(itemstack = this.beaconSlot.decrStackSize(this.beaconSlot.getSlotStackLimit())).isEmpty()) {
            p_onContainerClosed_1_.dropItem(itemstack, false);
        }
    }

    @Override
    public boolean canInteractWith(EntityPlayer p_canInteractWith_1_) {
        return this.tileBeacon.isUsableByPlayer(p_canInteractWith_1_);
    }

    @Override
    public ItemStack transferStackInSlot(EntityPlayer p_transferStackInSlot_1_, int p_transferStackInSlot_2_) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.inventorySlots.get(p_transferStackInSlot_2_);
        if (slot != null && slot.getHasStack()) {
            ItemStack itemstack1 = slot.getStack();
            itemstack = itemstack1.copy();
            if (p_transferStackInSlot_2_ == 0) {
                if (!this.mergeItemStack(itemstack1, 1, 37, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onSlotChange(itemstack1, itemstack);
            } else {
                if (this.mergeItemStack(itemstack1, 0, 1, false)) {
                    return ItemStack.EMPTY;
                }
                if (p_transferStackInSlot_2_ >= 1 && p_transferStackInSlot_2_ < 28 ? !this.mergeItemStack(itemstack1, 28, 37, false) : (p_transferStackInSlot_2_ >= 28 && p_transferStackInSlot_2_ < 37 ? !this.mergeItemStack(itemstack1, 1, 28, false) : !this.mergeItemStack(itemstack1, 1, 37, false))) {
                    return ItemStack.EMPTY;
                }
            }
            if (itemstack1.isEmpty()) {
                slot.putStack(ItemStack.EMPTY);
            } else {
                slot.onSlotChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(p_transferStackInSlot_1_, itemstack1);
        }
        return itemstack;
    }

    class BeaconSlot
    extends Slot {
        public BeaconSlot(IInventory p_i1801_2_, int p_i1801_3_, int p_i1801_4_, int p_i1801_5_) {
            super(p_i1801_2_, p_i1801_3_, p_i1801_4_, p_i1801_5_);
        }

        @Override
        public boolean isItemValid(ItemStack p_isItemValid_1_) {
            return p_isItemValid_1_.getItem().isBeaconPayment(p_isItemValid_1_);
        }

        @Override
        public int getSlotStackLimit() {
            return 1;
        }
    }
}

