/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.stats.AchievementList;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ContainerBrewingStand
extends Container {
    private final IInventory tileBrewingStand;
    private final Slot theSlot;
    private int prevBrewTime;
    private int prevFuel;

    public ContainerBrewingStand(InventoryPlayer p_i45802_1_, IInventory p_i45802_2_) {
        this.tileBrewingStand = p_i45802_2_;
        this.addSlotToContainer(new Potion(p_i45802_1_.player, p_i45802_2_, 0, 56, 51));
        this.addSlotToContainer(new Potion(p_i45802_1_.player, p_i45802_2_, 1, 79, 58));
        this.addSlotToContainer(new Potion(p_i45802_1_.player, p_i45802_2_, 2, 102, 51));
        this.theSlot = this.addSlotToContainer(new Ingredient(p_i45802_2_, 3, 79, 17));
        this.addSlotToContainer(new Fuel(p_i45802_2_, 4, 17, 17));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlotToContainer(new Slot(p_i45802_1_, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlotToContainer(new Slot(p_i45802_1_, k, 8 + k * 18, 142));
        }
    }

    @Override
    public void addListener(IContainerListener p_addListener_1_) {
        super.addListener(p_addListener_1_);
        p_addListener_1_.sendAllWindowProperties(this, this.tileBrewingStand);
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        for (int i = 0; i < this.listeners.size(); ++i) {
            IContainerListener icontainerlistener = (IContainerListener)this.listeners.get(i);
            if (this.prevBrewTime != this.tileBrewingStand.getField(0)) {
                icontainerlistener.sendProgressBarUpdate(this, 0, this.tileBrewingStand.getField(0));
            }
            if (this.prevFuel == this.tileBrewingStand.getField(1)) continue;
            icontainerlistener.sendProgressBarUpdate(this, 1, this.tileBrewingStand.getField(1));
        }
        this.prevBrewTime = this.tileBrewingStand.getField(0);
        this.prevFuel = this.tileBrewingStand.getField(1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateProgressBar(int p_updateProgressBar_1_, int p_updateProgressBar_2_) {
        this.tileBrewingStand.setField(p_updateProgressBar_1_, p_updateProgressBar_2_);
    }

    @Override
    public boolean canInteractWith(EntityPlayer p_canInteractWith_1_) {
        return this.tileBrewingStand.isUsableByPlayer(p_canInteractWith_1_);
    }

    @Override
    public ItemStack transferStackInSlot(EntityPlayer p_transferStackInSlot_1_, int p_transferStackInSlot_2_) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.inventorySlots.get(p_transferStackInSlot_2_);
        if (slot != null && slot.getHasStack()) {
            ItemStack itemstack1 = slot.getStack();
            itemstack = itemstack1.copy();
            if ((p_transferStackInSlot_2_ < 0 || p_transferStackInSlot_2_ > 2) && p_transferStackInSlot_2_ != 3 && p_transferStackInSlot_2_ != 4) {
                if (this.theSlot.isItemValid(itemstack1) ? !this.mergeItemStack(itemstack1, 3, 4, false) : (Potion.canHoldPotion(itemstack) && itemstack.getCount() == 1 ? !this.mergeItemStack(itemstack1, 0, 3, false) : (Fuel.isValidBrewingFuel(itemstack) ? !this.mergeItemStack(itemstack1, 4, 5, false) : (p_transferStackInSlot_2_ >= 5 && p_transferStackInSlot_2_ < 32 ? !this.mergeItemStack(itemstack1, 32, 41, false) : (p_transferStackInSlot_2_ >= 32 && p_transferStackInSlot_2_ < 41 ? !this.mergeItemStack(itemstack1, 5, 32, false) : !this.mergeItemStack(itemstack1, 5, 41, false)))))) {
                    return ItemStack.EMPTY;
                }
            } else {
                if (!this.mergeItemStack(itemstack1, 5, 41, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onSlotChange(itemstack1, itemstack);
            }
            if (itemstack1.isEmpty()) {
                slot.putStack(ItemStack.EMPTY);
            } else {
                slot.onSlotChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(p_transferStackInSlot_1_, itemstack1);
        }
        return itemstack;
    }

    static class Potion
    extends Slot {
        private final EntityPlayer player;

        public Potion(EntityPlayer p_i1804_1_, IInventory p_i1804_2_, int p_i1804_3_, int p_i1804_4_, int p_i1804_5_) {
            super(p_i1804_2_, p_i1804_3_, p_i1804_4_, p_i1804_5_);
            this.player = p_i1804_1_;
        }

        @Override
        public boolean isItemValid(ItemStack p_isItemValid_1_) {
            return Potion.canHoldPotion(p_isItemValid_1_);
        }

        @Override
        public int getSlotStackLimit() {
            return 1;
        }

        @Override
        public ItemStack onTake(EntityPlayer p_onTake_1_, ItemStack p_onTake_2_) {
            PotionType potiontype = PotionUtils.getPotionFromItem(p_onTake_2_);
            if (potiontype != PotionTypes.WATER && potiontype != PotionTypes.EMPTY) {
                ForgeEventFactory.onPlayerBrewedPotion(p_onTake_1_, p_onTake_2_);
                this.player.addStat(AchievementList.POTION);
            }
            super.onTake(p_onTake_1_, p_onTake_2_);
            return p_onTake_2_;
        }

        public static boolean canHoldPotion(ItemStack p_canHoldPotion_0_) {
            return BrewingRecipeRegistry.isValidInput(p_canHoldPotion_0_);
        }
    }

    static class Ingredient
    extends Slot {
        public Ingredient(IInventory p_i47069_1_, int p_i47069_2_, int p_i47069_3_, int p_i47069_4_) {
            super(p_i47069_1_, p_i47069_2_, p_i47069_3_, p_i47069_4_);
        }

        @Override
        public boolean isItemValid(ItemStack p_isItemValid_1_) {
            return BrewingRecipeRegistry.isValidIngredient(p_isItemValid_1_);
        }

        @Override
        public int getSlotStackLimit() {
            return 64;
        }
    }

    static class Fuel
    extends Slot {
        public Fuel(IInventory p_i47070_1_, int p_i47070_2_, int p_i47070_3_, int p_i47070_4_) {
            super(p_i47070_1_, p_i47070_2_, p_i47070_3_, p_i47070_4_);
        }

        @Override
        public boolean isItemValid(ItemStack p_isItemValid_1_) {
            return Fuel.isValidBrewingFuel(p_isItemValid_1_);
        }

        public static boolean isValidBrewingFuel(ItemStack p_isValidBrewingFuel_0_) {
            return p_isValidBrewingFuel_0_.getItem() == Items.BLAZE_POWDER;
        }

        @Override
        public int getSlotStackLimit() {
            return 64;
        }
    }
}

