/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.inventory;

import java.util.List;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ContainerEnchantment
extends Container {
    public IInventory tableInventory = new InventoryBasic("Enchant", true, 2){

        @Override
        public int getInventoryStackLimit() {
            return 64;
        }

        @Override
        public void markDirty() {
            super.markDirty();
            ContainerEnchantment.this.onCraftMatrixChanged(this);
        }
    };
    private final World worldPointer;
    private final BlockPos position;
    private final Random rand = new Random();
    public int xpSeed;
    public int[] enchantLevels = new int[3];
    public int[] enchantClue = new int[]{-1, -1, -1};
    public int[] worldClue = new int[]{-1, -1, -1};

    @SideOnly(value=Side.CLIENT)
    public ContainerEnchantment(InventoryPlayer p_i45797_1_, World p_i45797_2_) {
        this(p_i45797_1_, p_i45797_2_, BlockPos.ORIGIN);
    }

    public ContainerEnchantment(InventoryPlayer p_i45798_1_, World p_i45798_2_, BlockPos p_i45798_3_) {
        this.worldPointer = p_i45798_2_;
        this.position = p_i45798_3_;
        this.xpSeed = p_i45798_1_.player.getXPSeed();
        this.addSlotToContainer(new Slot(this.tableInventory, 0, 15, 47){

            @Override
            public boolean isItemValid(ItemStack p_isItemValid_1_) {
                return true;
            }

            @Override
            public int getSlotStackLimit() {
                return 1;
            }
        });
        this.addSlotToContainer(new Slot(this.tableInventory, 1, 35, 47){
            List<ItemStack> ores;
            {
                this.ores = OreDictionary.getOres("gemLapis");
            }

            @Override
            public boolean isItemValid(ItemStack p_isItemValid_1_) {
                for (ItemStack ore : this.ores) {
                    if (!OreDictionary.itemMatches(ore, p_isItemValid_1_, false)) continue;
                    return true;
                }
                return false;
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlotToContainer(new Slot(p_i45798_1_, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlotToContainer(new Slot(p_i45798_1_, k, 8 + k * 18, 142));
        }
    }

    protected void broadcastData(IContainerListener p_broadcastData_1_) {
        p_broadcastData_1_.sendProgressBarUpdate(this, 0, this.enchantLevels[0]);
        p_broadcastData_1_.sendProgressBarUpdate(this, 1, this.enchantLevels[1]);
        p_broadcastData_1_.sendProgressBarUpdate(this, 2, this.enchantLevels[2]);
        p_broadcastData_1_.sendProgressBarUpdate(this, 3, this.xpSeed & 0xFFFFFFF0);
        p_broadcastData_1_.sendProgressBarUpdate(this, 4, this.enchantClue[0]);
        p_broadcastData_1_.sendProgressBarUpdate(this, 5, this.enchantClue[1]);
        p_broadcastData_1_.sendProgressBarUpdate(this, 6, this.enchantClue[2]);
        p_broadcastData_1_.sendProgressBarUpdate(this, 7, this.worldClue[0]);
        p_broadcastData_1_.sendProgressBarUpdate(this, 8, this.worldClue[1]);
        p_broadcastData_1_.sendProgressBarUpdate(this, 9, this.worldClue[2]);
    }

    @Override
    public void addListener(IContainerListener p_addListener_1_) {
        super.addListener(p_addListener_1_);
        this.broadcastData(p_addListener_1_);
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        for (int i = 0; i < this.listeners.size(); ++i) {
            IContainerListener icontainerlistener = (IContainerListener)this.listeners.get(i);
            this.broadcastData(icontainerlistener);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateProgressBar(int p_updateProgressBar_1_, int p_updateProgressBar_2_) {
        if (p_updateProgressBar_1_ >= 0 && p_updateProgressBar_1_ <= 2) {
            this.enchantLevels[p_updateProgressBar_1_] = p_updateProgressBar_2_;
        } else if (p_updateProgressBar_1_ == 3) {
            this.xpSeed = p_updateProgressBar_2_;
        } else if (p_updateProgressBar_1_ >= 4 && p_updateProgressBar_1_ <= 6) {
            this.enchantClue[p_updateProgressBar_1_ - 4] = p_updateProgressBar_2_;
        } else if (p_updateProgressBar_1_ >= 7 && p_updateProgressBar_1_ <= 9) {
            this.worldClue[p_updateProgressBar_1_ - 7] = p_updateProgressBar_2_;
        } else {
            super.updateProgressBar(p_updateProgressBar_1_, p_updateProgressBar_2_);
        }
    }

    @Override
    public void onCraftMatrixChanged(IInventory p_onCraftMatrixChanged_1_) {
        if (p_onCraftMatrixChanged_1_ == this.tableInventory) {
            ItemStack itemstack = p_onCraftMatrixChanged_1_.getStackInSlot(0);
            if (!itemstack.isEmpty() && itemstack.isItemEnchantable()) {
                if (!this.worldPointer.isRemote) {
                    boolean l = false;
                    float power = 0.0f;
                    for (int j = -1; j <= 1; ++j) {
                        for (int k = -1; k <= 1; ++k) {
                            if (j == 0 && k == 0 || !this.worldPointer.isAirBlock(this.position.add(k, 0, j)) || !this.worldPointer.isAirBlock(this.position.add(k, 1, j))) continue;
                            power += ForgeHooks.getEnchantPower(this.worldPointer, this.position.add(k * 2, 0, j * 2));
                            power += ForgeHooks.getEnchantPower(this.worldPointer, this.position.add(k * 2, 1, j * 2));
                            if (k == 0 || j == 0) continue;
                            power += ForgeHooks.getEnchantPower(this.worldPointer, this.position.add(k * 2, 0, j));
                            power += ForgeHooks.getEnchantPower(this.worldPointer, this.position.add(k * 2, 1, j));
                            power += ForgeHooks.getEnchantPower(this.worldPointer, this.position.add(k, 0, j * 2));
                            power += ForgeHooks.getEnchantPower(this.worldPointer, this.position.add(k, 1, j * 2));
                        }
                    }
                    this.rand.setSeed(this.xpSeed);
                    for (int i1 = 0; i1 < 3; ++i1) {
                        this.enchantLevels[i1] = EnchantmentHelper.calcItemStackEnchantability(this.rand, i1, (int)power, itemstack);
                        this.enchantClue[i1] = -1;
                        this.worldClue[i1] = -1;
                        if (this.enchantLevels[i1] < i1 + 1) {
                            this.enchantLevels[i1] = 0;
                        }
                        this.enchantLevels[i1] = ForgeEventFactory.onEnchantmentLevelSet(this.worldPointer, this.position, i1, (int)power, itemstack, this.enchantLevels[i1]);
                    }
                    for (int j1 = 0; j1 < 3; ++j1) {
                        List<EnchantmentData> list;
                        if (this.enchantLevels[j1] <= 0 || (list = this.getEnchantmentList(itemstack, j1, this.enchantLevels[j1])) == null || list.isEmpty()) continue;
                        EnchantmentData enchantmentdata = list.get(this.rand.nextInt(list.size()));
                        this.enchantClue[j1] = Enchantment.getEnchantmentID(enchantmentdata.enchantmentobj);
                        this.worldClue[j1] = enchantmentdata.enchantmentLevel;
                    }
                    this.detectAndSendChanges();
                }
            } else {
                for (int i = 0; i < 3; ++i) {
                    this.enchantLevels[i] = 0;
                    this.enchantClue[i] = -1;
                    this.worldClue[i] = -1;
                }
            }
        }
    }

    @Override
    public boolean enchantItem(EntityPlayer p_enchantItem_1_, int p_enchantItem_2_) {
        ItemStack itemstack = this.tableInventory.getStackInSlot(0);
        ItemStack itemstack1 = this.tableInventory.getStackInSlot(1);
        int i = p_enchantItem_2_ + 1;
        if ((itemstack1.isEmpty() || itemstack1.getCount() < i) && !p_enchantItem_1_.capabilities.isCreativeMode) {
            return false;
        }
        if (this.enchantLevels[p_enchantItem_2_] > 0 && !itemstack.isEmpty() && (p_enchantItem_1_.experienceLevel >= i && p_enchantItem_1_.experienceLevel >= this.enchantLevels[p_enchantItem_2_] || p_enchantItem_1_.capabilities.isCreativeMode)) {
            List<EnchantmentData> list;
            if (!this.worldPointer.isRemote && !(list = this.getEnchantmentList(itemstack, p_enchantItem_2_, this.enchantLevels[p_enchantItem_2_])).isEmpty()) {
                boolean flag;
                p_enchantItem_1_.removeExperienceLevel(i);
                boolean bl = flag = itemstack.getItem() == Items.BOOK;
                if (flag) {
                    itemstack = new ItemStack(Items.ENCHANTED_BOOK);
                    this.tableInventory.setInventorySlotContents(0, itemstack);
                }
                for (int j = 0; j < list.size(); ++j) {
                    EnchantmentData enchantmentdata = list.get(j);
                    if (flag) {
                        Items.ENCHANTED_BOOK.addEnchantment(itemstack, enchantmentdata);
                        continue;
                    }
                    itemstack.addEnchantment(enchantmentdata.enchantmentobj, enchantmentdata.enchantmentLevel);
                }
                if (!p_enchantItem_1_.capabilities.isCreativeMode) {
                    itemstack1.shrink(i);
                    if (itemstack1.isEmpty()) {
                        this.tableInventory.setInventorySlotContents(1, ItemStack.EMPTY);
                    }
                }
                p_enchantItem_1_.addStat(StatList.ITEM_ENCHANTED);
                this.tableInventory.markDirty();
                this.xpSeed = p_enchantItem_1_.getXPSeed();
                this.onCraftMatrixChanged(this.tableInventory);
                this.worldPointer.playSound(null, this.position, SoundEvents.BLOCK_ENCHANTMENT_TABLE_USE, SoundCategory.BLOCKS, 1.0f, this.worldPointer.rand.nextFloat() * 0.1f + 0.9f);
            }
            return true;
        }
        return false;
    }

    private List<EnchantmentData> getEnchantmentList(ItemStack p_getEnchantmentList_1_, int p_getEnchantmentList_2_, int p_getEnchantmentList_3_) {
        this.rand.setSeed(this.xpSeed + p_getEnchantmentList_2_);
        List<EnchantmentData> list = EnchantmentHelper.buildEnchantmentList(this.rand, p_getEnchantmentList_1_, p_getEnchantmentList_3_, false);
        if (p_getEnchantmentList_1_.getItem() == Items.BOOK && list.size() > 1) {
            list.remove(this.rand.nextInt(list.size()));
        }
        return list;
    }

    @SideOnly(value=Side.CLIENT)
    public int getLapisAmount() {
        ItemStack itemstack = this.tableInventory.getStackInSlot(1);
        return itemstack.isEmpty() ? 0 : itemstack.getCount();
    }

    @Override
    public void onContainerClosed(EntityPlayer p_onContainerClosed_1_) {
        super.onContainerClosed(p_onContainerClosed_1_);
        if (!this.worldPointer.isRemote) {
            for (int i = 0; i < this.tableInventory.getSizeInventory(); ++i) {
                ItemStack itemstack = this.tableInventory.removeStackFromSlot(i);
                if (itemstack.isEmpty()) continue;
                p_onContainerClosed_1_.dropItem(itemstack, false);
            }
        }
    }

    @Override
    public boolean canInteractWith(EntityPlayer p_canInteractWith_1_) {
        return this.worldPointer.getBlockState(this.position).getBlock() != Blocks.ENCHANTING_TABLE ? false : p_canInteractWith_1_.getDistanceSq((double)this.position.getX() + 0.5, (double)this.position.getY() + 0.5, (double)this.position.getZ() + 0.5) <= 64.0;
    }

    @Override
    public ItemStack transferStackInSlot(EntityPlayer p_transferStackInSlot_1_, int p_transferStackInSlot_2_) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.inventorySlots.get(p_transferStackInSlot_2_);
        if (slot != null && slot.getHasStack()) {
            ItemStack itemstack1 = slot.getStack();
            itemstack = itemstack1.copy();
            if (p_transferStackInSlot_2_ == 0) {
                if (!this.mergeItemStack(itemstack1, 2, 38, true)) {
                    return ItemStack.EMPTY;
                }
            } else if (p_transferStackInSlot_2_ == 1) {
                if (!this.mergeItemStack(itemstack1, 2, 38, true)) {
                    return ItemStack.EMPTY;
                }
            } else if (itemstack1.getItem() == Items.DYE && EnumDyeColor.byDyeDamage(itemstack1.getMetadata()) == EnumDyeColor.BLUE) {
                if (!this.mergeItemStack(itemstack1, 1, 2, true)) {
                    return ItemStack.EMPTY;
                }
            } else {
                if (((Slot)this.inventorySlots.get(0)).getHasStack() || !((Slot)this.inventorySlots.get(0)).isItemValid(itemstack1)) {
                    return ItemStack.EMPTY;
                }
                if (itemstack1.hasTagCompound() && itemstack1.getCount() == 1) {
                    ((Slot)this.inventorySlots.get(0)).putStack(itemstack1.copy());
                    itemstack1.setCount(0);
                } else if (!itemstack1.isEmpty()) {
                    ((Slot)this.inventorySlots.get(0)).putStack(new ItemStack(itemstack1.getItem(), 1, itemstack1.getMetadata()));
                    itemstack1.shrink(1);
                }
            }
            if (itemstack1.isEmpty()) {
                slot.putStack(ItemStack.EMPTY);
            } else {
                slot.onSlotChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(p_transferStackInSlot_1_, itemstack1);
        }
        return itemstack;
    }
}

