/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotFurnaceFuel;
import net.minecraft.inventory.SlotFurnaceOutput;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ContainerFurnace
extends Container {
    private final IInventory tileFurnace;
    private int cookTime;
    private int totalCookTime;
    private int furnaceBurnTime;
    private int currentItemBurnTime;

    public ContainerFurnace(InventoryPlayer p_i45794_1_, IInventory p_i45794_2_) {
        this.tileFurnace = p_i45794_2_;
        this.addSlotToContainer(new Slot(p_i45794_2_, 0, 56, 17));
        this.addSlotToContainer(new SlotFurnaceFuel(p_i45794_2_, 1, 56, 53));
        this.addSlotToContainer(new SlotFurnaceOutput(p_i45794_1_.player, p_i45794_2_, 2, 116, 35));
        for (int lvt_3_1_ = 0; lvt_3_1_ < 3; ++lvt_3_1_) {
            for (int lvt_4_1_ = 0; lvt_4_1_ < 9; ++lvt_4_1_) {
                this.addSlotToContainer(new Slot(p_i45794_1_, lvt_4_1_ + lvt_3_1_ * 9 + 9, 8 + lvt_4_1_ * 18, 84 + lvt_3_1_ * 18));
            }
        }
        for (int lvt_3_2_ = 0; lvt_3_2_ < 9; ++lvt_3_2_) {
            this.addSlotToContainer(new Slot(p_i45794_1_, lvt_3_2_, 8 + lvt_3_2_ * 18, 142));
        }
    }

    @Override
    public void addListener(IContainerListener p_addListener_1_) {
        super.addListener(p_addListener_1_);
        p_addListener_1_.sendAllWindowProperties(this, this.tileFurnace);
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        for (int lvt_1_1_ = 0; lvt_1_1_ < this.listeners.size(); ++lvt_1_1_) {
            IContainerListener lvt_2_1_ = (IContainerListener)this.listeners.get(lvt_1_1_);
            if (this.cookTime != this.tileFurnace.getField(2)) {
                lvt_2_1_.sendProgressBarUpdate(this, 2, this.tileFurnace.getField(2));
            }
            if (this.furnaceBurnTime != this.tileFurnace.getField(0)) {
                lvt_2_1_.sendProgressBarUpdate(this, 0, this.tileFurnace.getField(0));
            }
            if (this.currentItemBurnTime != this.tileFurnace.getField(1)) {
                lvt_2_1_.sendProgressBarUpdate(this, 1, this.tileFurnace.getField(1));
            }
            if (this.totalCookTime == this.tileFurnace.getField(3)) continue;
            lvt_2_1_.sendProgressBarUpdate(this, 3, this.tileFurnace.getField(3));
        }
        this.cookTime = this.tileFurnace.getField(2);
        this.furnaceBurnTime = this.tileFurnace.getField(0);
        this.currentItemBurnTime = this.tileFurnace.getField(1);
        this.totalCookTime = this.tileFurnace.getField(3);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateProgressBar(int p_updateProgressBar_1_, int p_updateProgressBar_2_) {
        this.tileFurnace.setField(p_updateProgressBar_1_, p_updateProgressBar_2_);
    }

    @Override
    public boolean canInteractWith(EntityPlayer p_canInteractWith_1_) {
        return this.tileFurnace.isUsableByPlayer(p_canInteractWith_1_);
    }

    @Override
    public ItemStack transferStackInSlot(EntityPlayer p_transferStackInSlot_1_, int p_transferStackInSlot_2_) {
        ItemStack lvt_3_1_ = ItemStack.EMPTY;
        Slot lvt_4_1_ = (Slot)this.inventorySlots.get(p_transferStackInSlot_2_);
        if (lvt_4_1_ != null && lvt_4_1_.getHasStack()) {
            ItemStack lvt_5_1_ = lvt_4_1_.getStack();
            lvt_3_1_ = lvt_5_1_.copy();
            if (p_transferStackInSlot_2_ == 2) {
                if (!this.mergeItemStack(lvt_5_1_, 3, 39, true)) {
                    return ItemStack.EMPTY;
                }
                lvt_4_1_.onSlotChange(lvt_5_1_, lvt_3_1_);
            } else if (p_transferStackInSlot_2_ == 1 || p_transferStackInSlot_2_ == 0 ? !this.mergeItemStack(lvt_5_1_, 3, 39, false) : (!FurnaceRecipes.instance().getSmeltingResult(lvt_5_1_).isEmpty() ? !this.mergeItemStack(lvt_5_1_, 0, 1, false) : (TileEntityFurnace.isItemFuel(lvt_5_1_) ? !this.mergeItemStack(lvt_5_1_, 1, 2, false) : (p_transferStackInSlot_2_ >= 3 && p_transferStackInSlot_2_ < 30 ? !this.mergeItemStack(lvt_5_1_, 30, 39, false) : p_transferStackInSlot_2_ >= 30 && p_transferStackInSlot_2_ < 39 && !this.mergeItemStack(lvt_5_1_, 3, 30, false))))) {
                return ItemStack.EMPTY;
            }
            if (lvt_5_1_.isEmpty()) {
                lvt_4_1_.putStack(ItemStack.EMPTY);
            } else {
                lvt_4_1_.onSlotChanged();
            }
            if (lvt_5_1_.getCount() == lvt_3_1_.getCount()) {
                return ItemStack.EMPTY;
            }
            lvt_4_1_.onTake(p_transferStackInSlot_1_, lvt_5_1_);
        }
        return lvt_3_1_;
    }
}

