/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.inventory;

import net.minecraft.entity.passive.AbstractChestHorse;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ContainerHorseInventory
extends Container {
    private final IInventory horseInventory;
    private final AbstractHorse theHorse;

    public ContainerHorseInventory(IInventory p_i45791_1_, IInventory p_i45791_2_, final AbstractHorse p_i45791_3_, EntityPlayer p_i45791_4_) {
        this.horseInventory = p_i45791_2_;
        this.theHorse = p_i45791_3_;
        int lvt_5_1_ = 3;
        p_i45791_2_.openInventory(p_i45791_4_);
        int lvt_6_1_ = -18;
        this.addSlotToContainer(new Slot(p_i45791_2_, 0, 8, 18){

            @Override
            public boolean isItemValid(ItemStack p_isItemValid_1_) {
                return p_isItemValid_1_.getItem() == Items.SADDLE && !this.getHasStack() && p_i45791_3_.canBeSaddled();
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public boolean canBeHovered() {
                return p_i45791_3_.canBeSaddled();
            }
        });
        this.addSlotToContainer(new Slot(p_i45791_2_, 1, 8, 36){

            @Override
            public boolean isItemValid(ItemStack p_isItemValid_1_) {
                return p_i45791_3_.isArmor(p_isItemValid_1_);
            }

            @Override
            public int getSlotStackLimit() {
                return 1;
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public boolean canBeHovered() {
                return p_i45791_3_.wearsArmor();
            }
        });
        if (p_i45791_3_ instanceof AbstractChestHorse && ((AbstractChestHorse)p_i45791_3_).hasChest()) {
            for (int lvt_7_1_ = 0; lvt_7_1_ < 3; ++lvt_7_1_) {
                for (int lvt_8_1_ = 0; lvt_8_1_ < ((AbstractChestHorse)p_i45791_3_).getInventoryColumns(); ++lvt_8_1_) {
                    this.addSlotToContainer(new Slot(p_i45791_2_, 2 + lvt_8_1_ + lvt_7_1_ * ((AbstractChestHorse)p_i45791_3_).getInventoryColumns(), 80 + lvt_8_1_ * 18, 18 + lvt_7_1_ * 18));
                }
            }
        }
        for (int lvt_7_2_ = 0; lvt_7_2_ < 3; ++lvt_7_2_) {
            for (int lvt_8_2_ = 0; lvt_8_2_ < 9; ++lvt_8_2_) {
                this.addSlotToContainer(new Slot(p_i45791_1_, lvt_8_2_ + lvt_7_2_ * 9 + 9, 8 + lvt_8_2_ * 18, 102 + lvt_7_2_ * 18 + -18));
            }
        }
        for (int lvt_7_3_ = 0; lvt_7_3_ < 9; ++lvt_7_3_) {
            this.addSlotToContainer(new Slot(p_i45791_1_, lvt_7_3_, 8 + lvt_7_3_ * 18, 142));
        }
    }

    @Override
    public boolean canInteractWith(EntityPlayer p_canInteractWith_1_) {
        return this.horseInventory.isUsableByPlayer(p_canInteractWith_1_) && this.theHorse.isEntityAlive() && this.theHorse.getDistanceToEntity(p_canInteractWith_1_) < 8.0f;
    }

    @Override
    public ItemStack transferStackInSlot(EntityPlayer p_transferStackInSlot_1_, int p_transferStackInSlot_2_) {
        ItemStack lvt_3_1_ = ItemStack.EMPTY;
        Slot lvt_4_1_ = (Slot)this.inventorySlots.get(p_transferStackInSlot_2_);
        if (lvt_4_1_ != null && lvt_4_1_.getHasStack()) {
            ItemStack lvt_5_1_ = lvt_4_1_.getStack();
            lvt_3_1_ = lvt_5_1_.copy();
            if (p_transferStackInSlot_2_ < this.horseInventory.getSizeInventory() ? !this.mergeItemStack(lvt_5_1_, this.horseInventory.getSizeInventory(), this.inventorySlots.size(), true) : (this.getSlot(1).isItemValid(lvt_5_1_) && !this.getSlot(1).getHasStack() ? !this.mergeItemStack(lvt_5_1_, 1, 2, false) : (this.getSlot(0).isItemValid(lvt_5_1_) ? !this.mergeItemStack(lvt_5_1_, 0, 1, false) : this.horseInventory.getSizeInventory() <= 2 || !this.mergeItemStack(lvt_5_1_, 2, this.horseInventory.getSizeInventory(), false)))) {
                return ItemStack.EMPTY;
            }
            if (lvt_5_1_.isEmpty()) {
                lvt_4_1_.putStack(ItemStack.EMPTY);
            } else {
                lvt_4_1_.onSlotChanged();
            }
        }
        return lvt_3_1_;
    }

    @Override
    public void onContainerClosed(EntityPlayer p_onContainerClosed_1_) {
        super.onContainerClosed(p_onContainerClosed_1_);
        this.horseInventory.closeInventory(p_onContainerClosed_1_);
    }
}

