/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.inventory;

import net.minecraft.entity.IMerchant;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryMerchant;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotMerchantResult;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ContainerMerchant
extends Container {
    private final IMerchant theMerchant;
    private final InventoryMerchant merchantInventory;
    private final World world;

    public ContainerMerchant(InventoryPlayer p_i1821_1_, IMerchant p_i1821_2_, World p_i1821_3_) {
        this.theMerchant = p_i1821_2_;
        this.world = p_i1821_3_;
        this.merchantInventory = new InventoryMerchant(p_i1821_1_.player, p_i1821_2_);
        this.addSlotToContainer(new Slot(this.merchantInventory, 0, 36, 53));
        this.addSlotToContainer(new Slot(this.merchantInventory, 1, 62, 53));
        this.addSlotToContainer(new SlotMerchantResult(p_i1821_1_.player, p_i1821_2_, this.merchantInventory, 2, 120, 53));
        for (int lvt_4_1_ = 0; lvt_4_1_ < 3; ++lvt_4_1_) {
            for (int lvt_5_1_ = 0; lvt_5_1_ < 9; ++lvt_5_1_) {
                this.addSlotToContainer(new Slot(p_i1821_1_, lvt_5_1_ + lvt_4_1_ * 9 + 9, 8 + lvt_5_1_ * 18, 84 + lvt_4_1_ * 18));
            }
        }
        for (int lvt_4_2_ = 0; lvt_4_2_ < 9; ++lvt_4_2_) {
            this.addSlotToContainer(new Slot(p_i1821_1_, lvt_4_2_, 8 + lvt_4_2_ * 18, 142));
        }
    }

    public InventoryMerchant getMerchantInventory() {
        return this.merchantInventory;
    }

    @Override
    public void onCraftMatrixChanged(IInventory p_onCraftMatrixChanged_1_) {
        this.merchantInventory.resetRecipeAndSlots();
        super.onCraftMatrixChanged(p_onCraftMatrixChanged_1_);
    }

    public void setCurrentRecipeIndex(int p_setCurrentRecipeIndex_1_) {
        this.merchantInventory.setCurrentRecipeIndex(p_setCurrentRecipeIndex_1_);
    }

    @Override
    public boolean canInteractWith(EntityPlayer p_canInteractWith_1_) {
        return this.theMerchant.getCustomer() == p_canInteractWith_1_;
    }

    @Override
    public ItemStack transferStackInSlot(EntityPlayer p_transferStackInSlot_1_, int p_transferStackInSlot_2_) {
        ItemStack lvt_3_1_ = ItemStack.EMPTY;
        Slot lvt_4_1_ = (Slot)this.inventorySlots.get(p_transferStackInSlot_2_);
        if (lvt_4_1_ != null && lvt_4_1_.getHasStack()) {
            ItemStack lvt_5_1_ = lvt_4_1_.getStack();
            lvt_3_1_ = lvt_5_1_.copy();
            if (p_transferStackInSlot_2_ == 2) {
                if (!this.mergeItemStack(lvt_5_1_, 3, 39, true)) {
                    return ItemStack.EMPTY;
                }
                lvt_4_1_.onSlotChange(lvt_5_1_, lvt_3_1_);
            } else if (p_transferStackInSlot_2_ == 0 || p_transferStackInSlot_2_ == 1 ? !this.mergeItemStack(lvt_5_1_, 3, 39, false) : (p_transferStackInSlot_2_ >= 3 && p_transferStackInSlot_2_ < 30 ? !this.mergeItemStack(lvt_5_1_, 30, 39, false) : p_transferStackInSlot_2_ >= 30 && p_transferStackInSlot_2_ < 39 && !this.mergeItemStack(lvt_5_1_, 3, 30, false))) {
                return ItemStack.EMPTY;
            }
            if (lvt_5_1_.isEmpty()) {
                lvt_4_1_.putStack(ItemStack.EMPTY);
            } else {
                lvt_4_1_.onSlotChanged();
            }
            if (lvt_5_1_.getCount() == lvt_3_1_.getCount()) {
                return ItemStack.EMPTY;
            }
            lvt_4_1_.onTake(p_transferStackInSlot_1_, lvt_5_1_);
        }
        return lvt_3_1_;
    }

    @Override
    public void onContainerClosed(EntityPlayer p_onContainerClosed_1_) {
        super.onContainerClosed(p_onContainerClosed_1_);
        this.theMerchant.setCustomer(null);
        super.onContainerClosed(p_onContainerClosed_1_);
        if (this.world.isRemote) {
            return;
        }
        ItemStack lvt_2_1_ = this.merchantInventory.removeStackFromSlot(0);
        if (!lvt_2_1_.isEmpty()) {
            p_onContainerClosed_1_.dropItem(lvt_2_1_, false);
        }
        if (!(lvt_2_1_ = this.merchantInventory.removeStackFromSlot(1)).isEmpty()) {
            p_onContainerClosed_1_.dropItem(lvt_2_1_, false);
        }
    }
}

