/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.inventory;

import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ContainerPlayer
extends Container {
    private static final EntityEquipmentSlot[] VALID_EQUIPMENT_SLOTS = new EntityEquipmentSlot[]{EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET};
    public InventoryCrafting craftMatrix = new InventoryCrafting(this, 2, 2);
    public IInventory craftResult = new InventoryCraftResult();
    public boolean isLocalWorld;
    private final EntityPlayer player;

    public ContainerPlayer(InventoryPlayer p_i1819_1_, boolean p_i1819_2_, EntityPlayer p_i1819_3_) {
        this.isLocalWorld = p_i1819_2_;
        this.player = p_i1819_3_;
        this.addSlotToContainer(new SlotCrafting(p_i1819_1_.player, this.craftMatrix, this.craftResult, 0, 154, 28));
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                this.addSlotToContainer(new Slot(this.craftMatrix, j + i * 2, 98 + j * 18, 18 + i * 18));
            }
        }
        for (int k = 0; k < 4; ++k) {
            final EntityEquipmentSlot entityequipmentslot = VALID_EQUIPMENT_SLOTS[k];
            this.addSlotToContainer(new Slot(p_i1819_1_, 36 + (3 - k), 8, 8 + k * 18){

                @Override
                public int getSlotStackLimit() {
                    return 1;
                }

                @Override
                public boolean isItemValid(ItemStack p_isItemValid_1_) {
                    return p_isItemValid_1_.getItem().isValidArmor(p_isItemValid_1_, entityequipmentslot, ContainerPlayer.this.player);
                }

                @Override
                public boolean canTakeStack(EntityPlayer p_canTakeStack_1_) {
                    ItemStack itemstack = this.getStack();
                    return !itemstack.isEmpty() && !p_canTakeStack_1_.isCreative() && EnchantmentHelper.hasBindingCurse(itemstack) ? false : super.canTakeStack(p_canTakeStack_1_);
                }

                @Override
                @Nullable
                @SideOnly(value=Side.CLIENT)
                public String getSlotTexture() {
                    return ItemArmor.EMPTY_SLOT_NAMES[entityequipmentslot.getIndex()];
                }
            });
        }
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.addSlotToContainer(new Slot(p_i1819_1_, j1 + (l + 1) * 9, 8 + j1 * 18, 84 + l * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.addSlotToContainer(new Slot(p_i1819_1_, i1, 8 + i1 * 18, 142));
        }
        this.addSlotToContainer(new Slot(p_i1819_1_, 40, 77, 62){

            @Override
            @Nullable
            @SideOnly(value=Side.CLIENT)
            public String getSlotTexture() {
                return "minecraft:items/empty_armor_slot_shield";
            }
        });
        this.onCraftMatrixChanged(this.craftMatrix);
    }

    @Override
    public void onCraftMatrixChanged(IInventory p_onCraftMatrixChanged_1_) {
        this.craftResult.setInventorySlotContents(0, CraftingManager.getInstance().findMatchingRecipe(this.craftMatrix, this.player.world));
    }

    @Override
    public void onContainerClosed(EntityPlayer p_onContainerClosed_1_) {
        super.onContainerClosed(p_onContainerClosed_1_);
        for (int i = 0; i < 4; ++i) {
            ItemStack itemstack = this.craftMatrix.removeStackFromSlot(i);
            if (itemstack.isEmpty()) continue;
            p_onContainerClosed_1_.dropItem(itemstack, false);
        }
        this.craftResult.setInventorySlotContents(0, ItemStack.EMPTY);
    }

    @Override
    public boolean canInteractWith(EntityPlayer p_canInteractWith_1_) {
        return true;
    }

    @Override
    public ItemStack transferStackInSlot(EntityPlayer p_transferStackInSlot_1_, int p_transferStackInSlot_2_) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.inventorySlots.get(p_transferStackInSlot_2_);
        if (slot != null && slot.getHasStack()) {
            int i;
            ItemStack itemstack1 = slot.getStack();
            itemstack = itemstack1.copy();
            EntityEquipmentSlot entityequipmentslot = EntityLiving.getSlotForItemStack(itemstack);
            if (p_transferStackInSlot_2_ == 0) {
                if (!this.mergeItemStack(itemstack1, 9, 45, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onSlotChange(itemstack1, itemstack);
            } else if (p_transferStackInSlot_2_ >= 1 && p_transferStackInSlot_2_ < 5 ? !this.mergeItemStack(itemstack1, 9, 45, false) : (p_transferStackInSlot_2_ >= 5 && p_transferStackInSlot_2_ < 9 ? !this.mergeItemStack(itemstack1, 9, 45, false) : (entityequipmentslot.getSlotType() == EntityEquipmentSlot.Type.ARMOR && !((Slot)this.inventorySlots.get(8 - entityequipmentslot.getIndex())).getHasStack() ? !this.mergeItemStack(itemstack1, i = 8 - entityequipmentslot.getIndex(), i + 1, false) : (entityequipmentslot == EntityEquipmentSlot.OFFHAND && !((Slot)this.inventorySlots.get(45)).getHasStack() ? !this.mergeItemStack(itemstack1, 45, 46, false) : (p_transferStackInSlot_2_ >= 9 && p_transferStackInSlot_2_ < 36 ? !this.mergeItemStack(itemstack1, 36, 45, false) : (p_transferStackInSlot_2_ >= 36 && p_transferStackInSlot_2_ < 45 ? !this.mergeItemStack(itemstack1, 9, 36, false) : !this.mergeItemStack(itemstack1, 9, 45, false))))))) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.putStack(ItemStack.EMPTY);
            } else {
                slot.onSlotChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            ItemStack itemstack2 = slot.onTake(p_transferStackInSlot_1_, itemstack1);
            if (p_transferStackInSlot_2_ == 0) {
                p_transferStackInSlot_1_.dropItem(itemstack2, false);
            }
        }
        return itemstack;
    }

    @Override
    public boolean canMergeSlot(ItemStack p_canMergeSlot_1_, Slot p_canMergeSlot_2_) {
        return p_canMergeSlot_2_.inventory != this.craftResult && super.canMergeSlot(p_canMergeSlot_1_, p_canMergeSlot_2_);
    }
}

