/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.inventory;

import java.util.Map;
import net.minecraft.block.BlockAnvil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemNameTag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ContainerRepair
extends Container {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IInventory outputSlot = new InventoryCraftResult();
    private final IInventory inputSlots = new InventoryBasic("Repair", true, 2){

        @Override
        public void markDirty() {
            super.markDirty();
            ContainerRepair.this.onCraftMatrixChanged(this);
        }
    };
    private final World world;
    private final BlockPos selfPosition;
    public int maximumCost;
    public int materialCost;
    private String repairedItemName;
    private final EntityPlayer player;

    @SideOnly(value=Side.CLIENT)
    public ContainerRepair(InventoryPlayer p_i45806_1_, World p_i45806_2_, EntityPlayer p_i45806_3_) {
        this(p_i45806_1_, p_i45806_2_, BlockPos.ORIGIN, p_i45806_3_);
    }

    public ContainerRepair(InventoryPlayer p_i45807_1_, final World p_i45807_2_, final BlockPos p_i45807_3_, EntityPlayer p_i45807_4_) {
        this.selfPosition = p_i45807_3_;
        this.world = p_i45807_2_;
        this.player = p_i45807_4_;
        this.addSlotToContainer(new Slot(this.inputSlots, 0, 27, 47));
        this.addSlotToContainer(new Slot(this.inputSlots, 1, 76, 47));
        this.addSlotToContainer(new Slot(this.outputSlot, 2, 134, 47){

            @Override
            public boolean isItemValid(ItemStack p_isItemValid_1_) {
                return false;
            }

            @Override
            public boolean canTakeStack(EntityPlayer p_canTakeStack_1_) {
                return (p_canTakeStack_1_.capabilities.isCreativeMode || p_canTakeStack_1_.experienceLevel >= ContainerRepair.this.maximumCost) && ContainerRepair.this.maximumCost > 0 && this.getHasStack();
            }

            @Override
            public ItemStack onTake(EntityPlayer p_onTake_1_, ItemStack p_onTake_2_) {
                if (!p_onTake_1_.capabilities.isCreativeMode) {
                    p_onTake_1_.addExperienceLevel(-ContainerRepair.this.maximumCost);
                }
                float breakChance = ForgeHooks.onAnvilRepair(p_onTake_1_, p_onTake_2_, ContainerRepair.this.inputSlots.getStackInSlot(0), ContainerRepair.this.inputSlots.getStackInSlot(1));
                ItemStack itemstack = ContainerRepair.this.inputSlots.getStackInSlot(0);
                if (itemstack.getCount() != 1 && !p_onTake_1_.capabilities.isCreativeMode && !(itemstack.getItem() instanceof ItemNameTag)) {
                    itemstack.setCount(itemstack.getCount() - 1);
                } else {
                    ContainerRepair.this.inputSlots.setInventorySlotContents(0, ItemStack.EMPTY);
                }
                if (ContainerRepair.this.materialCost > 0) {
                    ItemStack itemstack1 = ContainerRepair.this.inputSlots.getStackInSlot(1);
                    if (!itemstack1.isEmpty() && itemstack1.getCount() > ContainerRepair.this.materialCost) {
                        itemstack1.shrink(ContainerRepair.this.materialCost);
                        ContainerRepair.this.inputSlots.setInventorySlotContents(1, itemstack1);
                    } else {
                        ContainerRepair.this.inputSlots.setInventorySlotContents(1, ItemStack.EMPTY);
                    }
                } else {
                    ContainerRepair.this.inputSlots.setInventorySlotContents(1, ItemStack.EMPTY);
                }
                ContainerRepair.this.maximumCost = 0;
                IBlockState iblockstate = p_i45807_2_.getBlockState(p_i45807_3_);
                if (!p_onTake_1_.capabilities.isCreativeMode && !p_i45807_2_.isRemote && iblockstate.getBlock() == Blocks.ANVIL && p_onTake_1_.getRNG().nextFloat() < breakChance) {
                    int l = iblockstate.getValue(BlockAnvil.DAMAGE);
                    if (++l > 2) {
                        p_i45807_2_.setBlockToAir(p_i45807_3_);
                        p_i45807_2_.playEvent(1029, p_i45807_3_, 0);
                    } else {
                        p_i45807_2_.setBlockState(p_i45807_3_, iblockstate.withProperty(BlockAnvil.DAMAGE, l), 2);
                        p_i45807_2_.playEvent(1030, p_i45807_3_, 0);
                    }
                } else if (!p_i45807_2_.isRemote) {
                    p_i45807_2_.playEvent(1030, p_i45807_3_, 0);
                }
                return p_onTake_2_;
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlotToContainer(new Slot(p_i45807_1_, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlotToContainer(new Slot(p_i45807_1_, k, 8 + k * 18, 142));
        }
    }

    @Override
    public void onCraftMatrixChanged(IInventory p_onCraftMatrixChanged_1_) {
        super.onCraftMatrixChanged(p_onCraftMatrixChanged_1_);
        if (p_onCraftMatrixChanged_1_ == this.inputSlots) {
            this.updateRepairOutput();
        }
    }

    public void updateRepairOutput() {
        ItemStack itemstack = this.inputSlots.getStackInSlot(0);
        this.maximumCost = 1;
        int i = 0;
        int j = 0;
        int k = 0;
        if (itemstack.isEmpty()) {
            this.outputSlot.setInventorySlotContents(0, ItemStack.EMPTY);
            this.maximumCost = 0;
        } else {
            ItemStack itemstack1 = itemstack.copy();
            if (itemstack1.getCount() > 1 && !this.player.capabilities.isCreativeMode && !(itemstack1.getItem() instanceof ItemNameTag)) {
                itemstack1.setCount(1);
            }
            ItemStack itemstack2 = this.inputSlots.getStackInSlot(1);
            Map<Enchantment, Integer> map = EnchantmentHelper.getEnchantments(itemstack1);
            j = j + itemstack.getRepairCost() + (itemstack2.isEmpty() ? 0 : itemstack2.getRepairCost());
            this.materialCost = 0;
            boolean flag = false;
            if (!itemstack2.isEmpty()) {
                if (!ForgeHooks.onAnvilChange(this, itemstack, itemstack2, this.outputSlot, this.repairedItemName, j)) {
                    return;
                }
                boolean bl = flag = itemstack2.getItem() == Items.ENCHANTED_BOOK && !Items.ENCHANTED_BOOK.getEnchantments(itemstack2).hasNoTags();
                if (itemstack1.isItemStackDamageable() && itemstack1.getItem().getIsRepairable(itemstack, itemstack2)) {
                    int i3;
                    int l2 = Math.min(itemstack1.getItemDamage(), itemstack1.getMaxDamage() / 4);
                    if (l2 <= 0) {
                        this.outputSlot.setInventorySlotContents(0, ItemStack.EMPTY);
                        this.maximumCost = 0;
                        return;
                    }
                    for (i3 = 0; l2 > 0 && i3 < itemstack2.getCount(); ++i3) {
                        int j3 = itemstack1.getItemDamage() - l2;
                        itemstack1.setItemDamage(j3);
                        ++i;
                        l2 = Math.min(itemstack1.getItemDamage(), itemstack1.getMaxDamage() / 4);
                    }
                    this.materialCost = i3;
                } else {
                    if (!(flag || itemstack1.getItem() == itemstack2.getItem() && itemstack1.isItemStackDamageable())) {
                        this.outputSlot.setInventorySlotContents(0, ItemStack.EMPTY);
                        this.maximumCost = 0;
                        return;
                    }
                    if (itemstack1.isItemStackDamageable() && !flag) {
                        int l = itemstack.getMaxDamage() - itemstack.getItemDamage();
                        int i1 = itemstack2.getMaxDamage() - itemstack2.getItemDamage();
                        int j1 = i1 + itemstack1.getMaxDamage() * 12 / 100;
                        int k1 = l + j1;
                        int l1 = itemstack1.getMaxDamage() - k1;
                        if (l1 < 0) {
                            l1 = 0;
                        }
                        if (l1 < itemstack1.getMetadata()) {
                            itemstack1.setItemDamage(l1);
                            i += 2;
                        }
                    }
                    Map<Enchantment, Integer> map1 = EnchantmentHelper.getEnchantments(itemstack2);
                    boolean flag2 = false;
                    boolean flag3 = false;
                    for (Enchantment enchantment1 : map1.keySet()) {
                        if (enchantment1 == null) continue;
                        int i2 = map.containsKey(enchantment1) ? map.get(enchantment1) : 0;
                        int j2 = map1.get(enchantment1);
                        j2 = i2 == j2 ? j2 + 1 : Math.max(j2, i2);
                        boolean flag1 = enchantment1.canApply(itemstack);
                        if (this.player.capabilities.isCreativeMode || itemstack.getItem() == Items.ENCHANTED_BOOK) {
                            flag1 = true;
                        }
                        for (Enchantment enchantment : map.keySet()) {
                            if (enchantment == enchantment1 || enchantment1.func_191560_c(enchantment)) continue;
                            flag1 = false;
                            ++i;
                        }
                        if (!flag1) {
                            flag3 = true;
                            continue;
                        }
                        flag2 = true;
                        if (j2 > enchantment1.getMaxLevel()) {
                            j2 = enchantment1.getMaxLevel();
                        }
                        map.put(enchantment1, j2);
                        int k3 = 0;
                        switch (enchantment1.getRarity()) {
                            case COMMON: {
                                k3 = 1;
                                break;
                            }
                            case UNCOMMON: {
                                k3 = 2;
                                break;
                            }
                            case RARE: {
                                k3 = 4;
                                break;
                            }
                            case VERY_RARE: {
                                k3 = 8;
                            }
                        }
                        if (flag) {
                            k3 = Math.max(1, k3 / 2);
                        }
                        i += k3 * j2;
                    }
                    if (flag3 && !flag2) {
                        this.outputSlot.setInventorySlotContents(0, ItemStack.EMPTY);
                        this.maximumCost = 0;
                        return;
                    }
                }
            }
            if (StringUtils.isBlank((CharSequence)this.repairedItemName)) {
                if (itemstack.hasDisplayName()) {
                    k = 1;
                    i += k;
                    itemstack1.clearCustomName();
                }
            } else if (!this.repairedItemName.equals(itemstack.getDisplayName())) {
                k = 1;
                i += k;
                itemstack1.setStackDisplayName(this.repairedItemName);
            }
            if (flag && !itemstack1.getItem().isBookEnchantable(itemstack1, itemstack2)) {
                itemstack1 = ItemStack.EMPTY;
            }
            this.maximumCost = j + i;
            if (i <= 0) {
                itemstack1 = ItemStack.EMPTY;
            }
            if (k == i && k > 0 && this.maximumCost >= 40) {
                this.maximumCost = 39;
            }
            if (this.maximumCost >= 40 && !this.player.capabilities.isCreativeMode) {
                itemstack1 = ItemStack.EMPTY;
            }
            if (!itemstack1.isEmpty()) {
                int k2 = itemstack1.getRepairCost();
                if (!itemstack2.isEmpty() && k2 < itemstack2.getRepairCost()) {
                    k2 = itemstack2.getRepairCost();
                }
                if (k != i || k == 0) {
                    k2 = k2 * 2 + 1;
                }
                itemstack1.setRepairCost(k2);
                EnchantmentHelper.setEnchantments(map, itemstack1);
            }
            this.outputSlot.setInventorySlotContents(0, itemstack1);
            this.detectAndSendChanges();
        }
    }

    @Override
    public void addListener(IContainerListener p_addListener_1_) {
        super.addListener(p_addListener_1_);
        p_addListener_1_.sendProgressBarUpdate(this, 0, this.maximumCost);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateProgressBar(int p_updateProgressBar_1_, int p_updateProgressBar_2_) {
        if (p_updateProgressBar_1_ == 0) {
            this.maximumCost = p_updateProgressBar_2_;
        }
    }

    @Override
    public void onContainerClosed(EntityPlayer p_onContainerClosed_1_) {
        super.onContainerClosed(p_onContainerClosed_1_);
        if (!this.world.isRemote) {
            for (int i = 0; i < this.inputSlots.getSizeInventory(); ++i) {
                ItemStack itemstack = this.inputSlots.removeStackFromSlot(i);
                if (itemstack.isEmpty()) continue;
                p_onContainerClosed_1_.dropItem(itemstack, false);
            }
        }
    }

    @Override
    public boolean canInteractWith(EntityPlayer p_canInteractWith_1_) {
        return this.world.getBlockState(this.selfPosition).getBlock() != Blocks.ANVIL ? false : p_canInteractWith_1_.getDistanceSq((double)this.selfPosition.getX() + 0.5, (double)this.selfPosition.getY() + 0.5, (double)this.selfPosition.getZ() + 0.5) <= 64.0;
    }

    @Override
    public ItemStack transferStackInSlot(EntityPlayer p_transferStackInSlot_1_, int p_transferStackInSlot_2_) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.inventorySlots.get(p_transferStackInSlot_2_);
        if (slot != null && slot.getHasStack()) {
            ItemStack itemstack1 = slot.getStack();
            itemstack = itemstack1.copy();
            if (p_transferStackInSlot_2_ == 2) {
                if (!this.mergeItemStack(itemstack1, 3, 39, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onSlotChange(itemstack1, itemstack);
            } else if (p_transferStackInSlot_2_ != 0 && p_transferStackInSlot_2_ != 1 ? p_transferStackInSlot_2_ >= 3 && p_transferStackInSlot_2_ < 39 && !this.mergeItemStack(itemstack1, 0, 2, false) : !this.mergeItemStack(itemstack1, 3, 39, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.putStack(ItemStack.EMPTY);
            } else {
                slot.onSlotChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(p_transferStackInSlot_1_, itemstack1);
        }
        return itemstack;
    }

    public void updateItemName(String p_updateItemName_1_) {
        this.repairedItemName = p_updateItemName_1_;
        if (this.getSlot(2).getHasStack()) {
            ItemStack itemstack = this.getSlot(2).getStack();
            if (StringUtils.isBlank((CharSequence)p_updateItemName_1_)) {
                itemstack.clearCustomName();
            } else {
                itemstack.setStackDisplayName(this.repairedItemName);
            }
        }
        this.updateRepairOutput();
    }
}

