/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ContainerWorkbench
extends Container {
    public InventoryCrafting craftMatrix = new InventoryCrafting(this, 3, 3);
    public IInventory craftResult = new InventoryCraftResult();
    private final World world;
    private final BlockPos pos;

    public ContainerWorkbench(InventoryPlayer p_i45800_1_, World p_i45800_2_, BlockPos p_i45800_3_) {
        this.world = p_i45800_2_;
        this.pos = p_i45800_3_;
        this.addSlotToContainer(new SlotCrafting(p_i45800_1_.player, this.craftMatrix, this.craftResult, 0, 124, 35));
        for (int lvt_4_1_ = 0; lvt_4_1_ < 3; ++lvt_4_1_) {
            for (int lvt_5_1_ = 0; lvt_5_1_ < 3; ++lvt_5_1_) {
                this.addSlotToContainer(new Slot(this.craftMatrix, lvt_5_1_ + lvt_4_1_ * 3, 30 + lvt_5_1_ * 18, 17 + lvt_4_1_ * 18));
            }
        }
        for (int lvt_4_2_ = 0; lvt_4_2_ < 3; ++lvt_4_2_) {
            for (int lvt_5_2_ = 0; lvt_5_2_ < 9; ++lvt_5_2_) {
                this.addSlotToContainer(new Slot(p_i45800_1_, lvt_5_2_ + lvt_4_2_ * 9 + 9, 8 + lvt_5_2_ * 18, 84 + lvt_4_2_ * 18));
            }
        }
        for (int lvt_4_3_ = 0; lvt_4_3_ < 9; ++lvt_4_3_) {
            this.addSlotToContainer(new Slot(p_i45800_1_, lvt_4_3_, 8 + lvt_4_3_ * 18, 142));
        }
        this.onCraftMatrixChanged(this.craftMatrix);
    }

    @Override
    public void onCraftMatrixChanged(IInventory p_onCraftMatrixChanged_1_) {
        this.craftResult.setInventorySlotContents(0, CraftingManager.getInstance().findMatchingRecipe(this.craftMatrix, this.world));
    }

    @Override
    public void onContainerClosed(EntityPlayer p_onContainerClosed_1_) {
        super.onContainerClosed(p_onContainerClosed_1_);
        if (this.world.isRemote) {
            return;
        }
        for (int lvt_2_1_ = 0; lvt_2_1_ < 9; ++lvt_2_1_) {
            ItemStack lvt_3_1_ = this.craftMatrix.removeStackFromSlot(lvt_2_1_);
            if (lvt_3_1_.isEmpty()) continue;
            p_onContainerClosed_1_.dropItem(lvt_3_1_, false);
        }
    }

    @Override
    public boolean canInteractWith(EntityPlayer p_canInteractWith_1_) {
        if (this.world.getBlockState(this.pos).getBlock() != Blocks.CRAFTING_TABLE) {
            return false;
        }
        return !(p_canInteractWith_1_.getDistanceSq((double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.5, (double)this.pos.getZ() + 0.5) > 64.0);
    }

    @Override
    public ItemStack transferStackInSlot(EntityPlayer p_transferStackInSlot_1_, int p_transferStackInSlot_2_) {
        ItemStack lvt_3_1_ = ItemStack.EMPTY;
        Slot lvt_4_1_ = (Slot)this.inventorySlots.get(p_transferStackInSlot_2_);
        if (lvt_4_1_ != null && lvt_4_1_.getHasStack()) {
            ItemStack lvt_5_1_ = lvt_4_1_.getStack();
            lvt_3_1_ = lvt_5_1_.copy();
            if (p_transferStackInSlot_2_ == 0) {
                lvt_5_1_.getItem().onCreated(lvt_5_1_, this.world, p_transferStackInSlot_1_);
                if (!this.mergeItemStack(lvt_5_1_, 10, 46, true)) {
                    return ItemStack.EMPTY;
                }
                lvt_4_1_.onSlotChange(lvt_5_1_, lvt_3_1_);
            } else if (p_transferStackInSlot_2_ >= 10 && p_transferStackInSlot_2_ < 37 ? !this.mergeItemStack(lvt_5_1_, 37, 46, false) : (p_transferStackInSlot_2_ >= 37 && p_transferStackInSlot_2_ < 46 ? !this.mergeItemStack(lvt_5_1_, 10, 37, false) : !this.mergeItemStack(lvt_5_1_, 10, 46, false))) {
                return ItemStack.EMPTY;
            }
            if (lvt_5_1_.isEmpty()) {
                lvt_4_1_.putStack(ItemStack.EMPTY);
            } else {
                lvt_4_1_.onSlotChanged();
            }
            if (lvt_5_1_.getCount() == lvt_3_1_.getCount()) {
                return ItemStack.EMPTY;
            }
            ItemStack lvt_6_1_ = lvt_4_1_.onTake(p_transferStackInSlot_1_, lvt_5_1_);
            if (p_transferStackInSlot_2_ == 0) {
                p_transferStackInSlot_1_.dropItem(lvt_6_1_, false);
            }
        }
        return lvt_3_1_;
    }

    @Override
    public boolean canMergeSlot(ItemStack p_canMergeSlot_1_, Slot p_canMergeSlot_2_) {
        return p_canMergeSlot_2_.inventory != this.craftResult && super.canMergeSlot(p_canMergeSlot_1_, p_canMergeSlot_2_);
    }
}

