/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.inventory;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class InventoryBasic
implements IInventory {
    private String inventoryTitle;
    private final int slotsCount;
    private final NonNullList<ItemStack> inventoryContents;
    private List<IInventoryChangedListener> changeListeners;
    private boolean hasCustomName;

    public InventoryBasic(String p_i1561_1_, boolean p_i1561_2_, int p_i1561_3_) {
        this.inventoryTitle = p_i1561_1_;
        this.hasCustomName = p_i1561_2_;
        this.slotsCount = p_i1561_3_;
        this.inventoryContents = NonNullList.withSize(p_i1561_3_, ItemStack.EMPTY);
    }

    @SideOnly(value=Side.CLIENT)
    public InventoryBasic(ITextComponent p_i45902_1_, int p_i45902_2_) {
        this(p_i45902_1_.getUnformattedText(), true, p_i45902_2_);
    }

    public void addInventoryChangeListener(IInventoryChangedListener p_addInventoryChangeListener_1_) {
        if (this.changeListeners == null) {
            this.changeListeners = Lists.newArrayList();
        }
        this.changeListeners.add(p_addInventoryChangeListener_1_);
    }

    public void removeInventoryChangeListener(IInventoryChangedListener p_removeInventoryChangeListener_1_) {
        this.changeListeners.remove(p_removeInventoryChangeListener_1_);
    }

    @Override
    public ItemStack getStackInSlot(int p_getStackInSlot_1_) {
        if (p_getStackInSlot_1_ < 0 || p_getStackInSlot_1_ >= this.inventoryContents.size()) {
            return ItemStack.EMPTY;
        }
        return this.inventoryContents.get(p_getStackInSlot_1_);
    }

    @Override
    public ItemStack decrStackSize(int p_decrStackSize_1_, int p_decrStackSize_2_) {
        ItemStack lvt_3_1_ = ItemStackHelper.getAndSplit(this.inventoryContents, p_decrStackSize_1_, p_decrStackSize_2_);
        if (!lvt_3_1_.isEmpty()) {
            this.markDirty();
        }
        return lvt_3_1_;
    }

    public ItemStack addItem(ItemStack p_addItem_1_) {
        ItemStack lvt_2_1_ = p_addItem_1_.copy();
        for (int lvt_3_1_ = 0; lvt_3_1_ < this.slotsCount; ++lvt_3_1_) {
            ItemStack lvt_4_1_ = this.getStackInSlot(lvt_3_1_);
            if (lvt_4_1_.isEmpty()) {
                this.setInventorySlotContents(lvt_3_1_, lvt_2_1_);
                this.markDirty();
                return ItemStack.EMPTY;
            }
            if (!ItemStack.areItemsEqual(lvt_4_1_, lvt_2_1_)) continue;
            int lvt_5_1_ = Math.min(this.getInventoryStackLimit(), lvt_4_1_.getMaxStackSize());
            int lvt_6_1_ = Math.min(lvt_2_1_.getCount(), lvt_5_1_ - lvt_4_1_.getCount());
            if (lvt_6_1_ <= 0) continue;
            lvt_4_1_.grow(lvt_6_1_);
            lvt_2_1_.shrink(lvt_6_1_);
            if (!lvt_2_1_.isEmpty()) continue;
            this.markDirty();
            return ItemStack.EMPTY;
        }
        if (lvt_2_1_.getCount() != p_addItem_1_.getCount()) {
            this.markDirty();
        }
        return lvt_2_1_;
    }

    @Override
    public ItemStack removeStackFromSlot(int p_removeStackFromSlot_1_) {
        ItemStack lvt_2_1_ = this.inventoryContents.get(p_removeStackFromSlot_1_);
        if (lvt_2_1_.isEmpty()) {
            return ItemStack.EMPTY;
        }
        this.inventoryContents.set(p_removeStackFromSlot_1_, ItemStack.EMPTY);
        return lvt_2_1_;
    }

    @Override
    public void setInventorySlotContents(int p_setInventorySlotContents_1_, ItemStack p_setInventorySlotContents_2_) {
        this.inventoryContents.set(p_setInventorySlotContents_1_, p_setInventorySlotContents_2_);
        if (!p_setInventorySlotContents_2_.isEmpty() && p_setInventorySlotContents_2_.getCount() > this.getInventoryStackLimit()) {
            p_setInventorySlotContents_2_.setCount(this.getInventoryStackLimit());
        }
        this.markDirty();
    }

    @Override
    public int getSizeInventory() {
        return this.slotsCount;
    }

    @Override
    public boolean isEmpty() {
        for (ItemStack lvt_2_1_ : this.inventoryContents) {
            if (lvt_2_1_.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getName() {
        return this.inventoryTitle;
    }

    @Override
    public boolean hasCustomName() {
        return this.hasCustomName;
    }

    public void setCustomName(String p_setCustomName_1_) {
        this.hasCustomName = true;
        this.inventoryTitle = p_setCustomName_1_;
    }

    @Override
    public ITextComponent getDisplayName() {
        if (this.hasCustomName()) {
            return new TextComponentString(this.getName());
        }
        return new TextComponentTranslation(this.getName(), new Object[0]);
    }

    @Override
    public int getInventoryStackLimit() {
        return 64;
    }

    @Override
    public void markDirty() {
        if (this.changeListeners != null) {
            for (int lvt_1_1_ = 0; lvt_1_1_ < this.changeListeners.size(); ++lvt_1_1_) {
                this.changeListeners.get(lvt_1_1_).onInventoryChanged(this);
            }
        }
    }

    @Override
    public boolean isUsableByPlayer(EntityPlayer p_isUsableByPlayer_1_) {
        return true;
    }

    @Override
    public void openInventory(EntityPlayer p_openInventory_1_) {
    }

    @Override
    public void closeInventory(EntityPlayer p_closeInventory_1_) {
    }

    @Override
    public boolean isItemValidForSlot(int p_isItemValidForSlot_1_, ItemStack p_isItemValidForSlot_2_) {
        return true;
    }

    @Override
    public int getField(int p_getField_1_) {
        return 0;
    }

    @Override
    public void setField(int p_setField_1_, int p_setField_2_) {
    }

    @Override
    public int getFieldCount() {
        return 0;
    }

    @Override
    public void clear() {
        this.inventoryContents.clear();
    }
}

