/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;

public class InventoryCrafting
implements IInventory {
    private final NonNullList<ItemStack> stackList;
    private final int inventoryWidth;
    private final int inventoryHeight;
    private final Container eventHandler;

    public InventoryCrafting(Container p_i1807_1_, int p_i1807_2_, int p_i1807_3_) {
        this.stackList = NonNullList.withSize(p_i1807_2_ * p_i1807_3_, ItemStack.EMPTY);
        this.eventHandler = p_i1807_1_;
        this.inventoryWidth = p_i1807_2_;
        this.inventoryHeight = p_i1807_3_;
    }

    @Override
    public int getSizeInventory() {
        return this.stackList.size();
    }

    @Override
    public boolean isEmpty() {
        for (ItemStack lvt_2_1_ : this.stackList) {
            if (lvt_2_1_.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ItemStack getStackInSlot(int p_getStackInSlot_1_) {
        if (p_getStackInSlot_1_ >= this.getSizeInventory()) {
            return ItemStack.EMPTY;
        }
        return this.stackList.get(p_getStackInSlot_1_);
    }

    public ItemStack getStackInRowAndColumn(int p_getStackInRowAndColumn_1_, int p_getStackInRowAndColumn_2_) {
        if (p_getStackInRowAndColumn_1_ < 0 || p_getStackInRowAndColumn_1_ >= this.inventoryWidth || p_getStackInRowAndColumn_2_ < 0 || p_getStackInRowAndColumn_2_ > this.inventoryHeight) {
            return ItemStack.EMPTY;
        }
        return this.getStackInSlot(p_getStackInRowAndColumn_1_ + p_getStackInRowAndColumn_2_ * this.inventoryWidth);
    }

    @Override
    public String getName() {
        return "container.crafting";
    }

    @Override
    public boolean hasCustomName() {
        return false;
    }

    @Override
    public ITextComponent getDisplayName() {
        if (this.hasCustomName()) {
            return new TextComponentString(this.getName());
        }
        return new TextComponentTranslation(this.getName(), new Object[0]);
    }

    @Override
    public ItemStack removeStackFromSlot(int p_removeStackFromSlot_1_) {
        return ItemStackHelper.getAndRemove(this.stackList, p_removeStackFromSlot_1_);
    }

    @Override
    public ItemStack decrStackSize(int p_decrStackSize_1_, int p_decrStackSize_2_) {
        ItemStack lvt_3_1_ = ItemStackHelper.getAndSplit(this.stackList, p_decrStackSize_1_, p_decrStackSize_2_);
        if (!lvt_3_1_.isEmpty()) {
            this.eventHandler.onCraftMatrixChanged(this);
        }
        return lvt_3_1_;
    }

    @Override
    public void setInventorySlotContents(int p_setInventorySlotContents_1_, ItemStack p_setInventorySlotContents_2_) {
        this.stackList.set(p_setInventorySlotContents_1_, p_setInventorySlotContents_2_);
        this.eventHandler.onCraftMatrixChanged(this);
    }

    @Override
    public int getInventoryStackLimit() {
        return 64;
    }

    @Override
    public void markDirty() {
    }

    @Override
    public boolean isUsableByPlayer(EntityPlayer p_isUsableByPlayer_1_) {
        return true;
    }

    @Override
    public void openInventory(EntityPlayer p_openInventory_1_) {
    }

    @Override
    public void closeInventory(EntityPlayer p_closeInventory_1_) {
    }

    @Override
    public boolean isItemValidForSlot(int p_isItemValidForSlot_1_, ItemStack p_isItemValidForSlot_2_) {
        return true;
    }

    @Override
    public int getField(int p_getField_1_) {
        return 0;
    }

    @Override
    public void setField(int p_setField_1_, int p_setField_2_) {
    }

    @Override
    public int getFieldCount() {
        return 0;
    }

    @Override
    public void clear() {
        this.stackList.clear();
    }

    public int getHeight() {
        return this.inventoryHeight;
    }

    public int getWidth() {
        return this.inventoryWidth;
    }
}

