/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntityEnderChest;

public class InventoryEnderChest
extends InventoryBasic {
    private TileEntityEnderChest associatedChest;

    public InventoryEnderChest() {
        super("container.enderchest", false, 27);
    }

    public void setChestTileEntity(TileEntityEnderChest p_setChestTileEntity_1_) {
        this.associatedChest = p_setChestTileEntity_1_;
    }

    public void loadInventoryFromNBT(NBTTagList p_loadInventoryFromNBT_1_) {
        for (int lvt_2_1_ = 0; lvt_2_1_ < this.getSizeInventory(); ++lvt_2_1_) {
            this.setInventorySlotContents(lvt_2_1_, ItemStack.EMPTY);
        }
        for (int lvt_2_2_ = 0; lvt_2_2_ < p_loadInventoryFromNBT_1_.tagCount(); ++lvt_2_2_) {
            NBTTagCompound lvt_3_1_ = p_loadInventoryFromNBT_1_.getCompoundTagAt(lvt_2_2_);
            int lvt_4_1_ = lvt_3_1_.getByte("Slot") & 0xFF;
            if (lvt_4_1_ < 0 || lvt_4_1_ >= this.getSizeInventory()) continue;
            this.setInventorySlotContents(lvt_4_1_, new ItemStack(lvt_3_1_));
        }
    }

    public NBTTagList saveInventoryToNBT() {
        NBTTagList lvt_1_1_ = new NBTTagList();
        for (int lvt_2_1_ = 0; lvt_2_1_ < this.getSizeInventory(); ++lvt_2_1_) {
            ItemStack lvt_3_1_ = this.getStackInSlot(lvt_2_1_);
            if (lvt_3_1_.isEmpty()) continue;
            NBTTagCompound lvt_4_1_ = new NBTTagCompound();
            lvt_4_1_.setByte("Slot", (byte)lvt_2_1_);
            lvt_3_1_.writeToNBT(lvt_4_1_);
            lvt_1_1_.appendTag(lvt_4_1_);
        }
        return lvt_1_1_;
    }

    @Override
    public boolean isUsableByPlayer(EntityPlayer p_isUsableByPlayer_1_) {
        if (this.associatedChest != null && !this.associatedChest.canBeUsed(p_isUsableByPlayer_1_)) {
            return false;
        }
        return super.isUsableByPlayer(p_isUsableByPlayer_1_);
    }

    @Override
    public void openInventory(EntityPlayer p_openInventory_1_) {
        if (this.associatedChest != null) {
            this.associatedChest.openChest();
        }
        super.openInventory(p_openInventory_1_);
    }

    @Override
    public void closeInventory(EntityPlayer p_closeInventory_1_) {
        if (this.associatedChest != null) {
            this.associatedChest.closeChest();
        }
        super.closeInventory(p_closeInventory_1_);
        this.associatedChest = null;
    }
}

