/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.LockCode;

public class InventoryLargeChest
implements ILockableContainer {
    private final String name;
    private final ILockableContainer upperChest;
    private final ILockableContainer lowerChest;

    public InventoryLargeChest(String p_i45905_1_, ILockableContainer p_i45905_2_, ILockableContainer p_i45905_3_) {
        this.name = p_i45905_1_;
        if (p_i45905_2_ == null) {
            p_i45905_2_ = p_i45905_3_;
        }
        if (p_i45905_3_ == null) {
            p_i45905_3_ = p_i45905_2_;
        }
        this.upperChest = p_i45905_2_;
        this.lowerChest = p_i45905_3_;
        if (p_i45905_2_.isLocked()) {
            p_i45905_3_.setLockCode(p_i45905_2_.getLockCode());
        } else if (p_i45905_3_.isLocked()) {
            p_i45905_2_.setLockCode(p_i45905_3_.getLockCode());
        }
    }

    @Override
    public int getSizeInventory() {
        return this.upperChest.getSizeInventory() + this.lowerChest.getSizeInventory();
    }

    @Override
    public boolean isEmpty() {
        return this.upperChest.isEmpty() && this.lowerChest.isEmpty();
    }

    public boolean isPartOfLargeChest(IInventory p_isPartOfLargeChest_1_) {
        return this.upperChest == p_isPartOfLargeChest_1_ || this.lowerChest == p_isPartOfLargeChest_1_;
    }

    @Override
    public String getName() {
        if (this.upperChest.hasCustomName()) {
            return this.upperChest.getName();
        }
        if (this.lowerChest.hasCustomName()) {
            return this.lowerChest.getName();
        }
        return this.name;
    }

    @Override
    public boolean hasCustomName() {
        return this.upperChest.hasCustomName() || this.lowerChest.hasCustomName();
    }

    @Override
    public ITextComponent getDisplayName() {
        if (this.hasCustomName()) {
            return new TextComponentString(this.getName());
        }
        return new TextComponentTranslation(this.getName(), new Object[0]);
    }

    @Override
    public ItemStack getStackInSlot(int p_getStackInSlot_1_) {
        if (p_getStackInSlot_1_ >= this.upperChest.getSizeInventory()) {
            return this.lowerChest.getStackInSlot(p_getStackInSlot_1_ - this.upperChest.getSizeInventory());
        }
        return this.upperChest.getStackInSlot(p_getStackInSlot_1_);
    }

    @Override
    public ItemStack decrStackSize(int p_decrStackSize_1_, int p_decrStackSize_2_) {
        if (p_decrStackSize_1_ >= this.upperChest.getSizeInventory()) {
            return this.lowerChest.decrStackSize(p_decrStackSize_1_ - this.upperChest.getSizeInventory(), p_decrStackSize_2_);
        }
        return this.upperChest.decrStackSize(p_decrStackSize_1_, p_decrStackSize_2_);
    }

    @Override
    public ItemStack removeStackFromSlot(int p_removeStackFromSlot_1_) {
        if (p_removeStackFromSlot_1_ >= this.upperChest.getSizeInventory()) {
            return this.lowerChest.removeStackFromSlot(p_removeStackFromSlot_1_ - this.upperChest.getSizeInventory());
        }
        return this.upperChest.removeStackFromSlot(p_removeStackFromSlot_1_);
    }

    @Override
    public void setInventorySlotContents(int p_setInventorySlotContents_1_, ItemStack p_setInventorySlotContents_2_) {
        if (p_setInventorySlotContents_1_ >= this.upperChest.getSizeInventory()) {
            this.lowerChest.setInventorySlotContents(p_setInventorySlotContents_1_ - this.upperChest.getSizeInventory(), p_setInventorySlotContents_2_);
        } else {
            this.upperChest.setInventorySlotContents(p_setInventorySlotContents_1_, p_setInventorySlotContents_2_);
        }
    }

    @Override
    public int getInventoryStackLimit() {
        return this.upperChest.getInventoryStackLimit();
    }

    @Override
    public void markDirty() {
        this.upperChest.markDirty();
        this.lowerChest.markDirty();
    }

    @Override
    public boolean isUsableByPlayer(EntityPlayer p_isUsableByPlayer_1_) {
        return this.upperChest.isUsableByPlayer(p_isUsableByPlayer_1_) && this.lowerChest.isUsableByPlayer(p_isUsableByPlayer_1_);
    }

    @Override
    public void openInventory(EntityPlayer p_openInventory_1_) {
        this.upperChest.openInventory(p_openInventory_1_);
        this.lowerChest.openInventory(p_openInventory_1_);
    }

    @Override
    public void closeInventory(EntityPlayer p_closeInventory_1_) {
        this.upperChest.closeInventory(p_closeInventory_1_);
        this.lowerChest.closeInventory(p_closeInventory_1_);
    }

    @Override
    public boolean isItemValidForSlot(int p_isItemValidForSlot_1_, ItemStack p_isItemValidForSlot_2_) {
        return true;
    }

    @Override
    public int getField(int p_getField_1_) {
        return 0;
    }

    @Override
    public void setField(int p_setField_1_, int p_setField_2_) {
    }

    @Override
    public int getFieldCount() {
        return 0;
    }

    @Override
    public boolean isLocked() {
        return this.upperChest.isLocked() || this.lowerChest.isLocked();
    }

    @Override
    public void setLockCode(LockCode p_setLockCode_1_) {
        this.upperChest.setLockCode(p_setLockCode_1_);
        this.lowerChest.setLockCode(p_setLockCode_1_);
    }

    @Override
    public LockCode getLockCode() {
        return this.upperChest.getLockCode();
    }

    @Override
    public String getGuiID() {
        return this.upperChest.getGuiID();
    }

    @Override
    public Container createContainer(InventoryPlayer p_createContainer_1_, EntityPlayer p_createContainer_2_) {
        return new ContainerChest(p_createContainer_1_, this, p_createContainer_2_);
    }

    @Override
    public void clear() {
        this.upperChest.clear();
        this.lowerChest.clear();
    }
}

