/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.inventory;

import net.minecraft.entity.IMerchant;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;

public class InventoryMerchant
implements IInventory {
    private final IMerchant theMerchant;
    private final NonNullList<ItemStack> theInventory = NonNullList.withSize(3, ItemStack.EMPTY);
    private final EntityPlayer player;
    private MerchantRecipe currentRecipe;
    private int currentRecipeIndex;

    public InventoryMerchant(EntityPlayer p_i1820_1_, IMerchant p_i1820_2_) {
        this.player = p_i1820_1_;
        this.theMerchant = p_i1820_2_;
    }

    @Override
    public int getSizeInventory() {
        return this.theInventory.size();
    }

    @Override
    public boolean isEmpty() {
        for (ItemStack lvt_2_1_ : this.theInventory) {
            if (lvt_2_1_.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ItemStack getStackInSlot(int p_getStackInSlot_1_) {
        return this.theInventory.get(p_getStackInSlot_1_);
    }

    @Override
    public ItemStack decrStackSize(int p_decrStackSize_1_, int p_decrStackSize_2_) {
        ItemStack lvt_3_1_ = this.theInventory.get(p_decrStackSize_1_);
        if (p_decrStackSize_1_ == 2 && !lvt_3_1_.isEmpty()) {
            return ItemStackHelper.getAndSplit(this.theInventory, p_decrStackSize_1_, lvt_3_1_.getCount());
        }
        ItemStack lvt_4_1_ = ItemStackHelper.getAndSplit(this.theInventory, p_decrStackSize_1_, p_decrStackSize_2_);
        if (!lvt_4_1_.isEmpty() && this.inventoryResetNeededOnSlotChange(p_decrStackSize_1_)) {
            this.resetRecipeAndSlots();
        }
        return lvt_4_1_;
    }

    private boolean inventoryResetNeededOnSlotChange(int p_inventoryResetNeededOnSlotChange_1_) {
        return p_inventoryResetNeededOnSlotChange_1_ == 0 || p_inventoryResetNeededOnSlotChange_1_ == 1;
    }

    @Override
    public ItemStack removeStackFromSlot(int p_removeStackFromSlot_1_) {
        return ItemStackHelper.getAndRemove(this.theInventory, p_removeStackFromSlot_1_);
    }

    @Override
    public void setInventorySlotContents(int p_setInventorySlotContents_1_, ItemStack p_setInventorySlotContents_2_) {
        this.theInventory.set(p_setInventorySlotContents_1_, p_setInventorySlotContents_2_);
        if (!p_setInventorySlotContents_2_.isEmpty() && p_setInventorySlotContents_2_.getCount() > this.getInventoryStackLimit()) {
            p_setInventorySlotContents_2_.setCount(this.getInventoryStackLimit());
        }
        if (this.inventoryResetNeededOnSlotChange(p_setInventorySlotContents_1_)) {
            this.resetRecipeAndSlots();
        }
    }

    @Override
    public String getName() {
        return "mob.villager";
    }

    @Override
    public boolean hasCustomName() {
        return false;
    }

    @Override
    public ITextComponent getDisplayName() {
        if (this.hasCustomName()) {
            return new TextComponentString(this.getName());
        }
        return new TextComponentTranslation(this.getName(), new Object[0]);
    }

    @Override
    public int getInventoryStackLimit() {
        return 64;
    }

    @Override
    public boolean isUsableByPlayer(EntityPlayer p_isUsableByPlayer_1_) {
        return this.theMerchant.getCustomer() == p_isUsableByPlayer_1_;
    }

    @Override
    public void openInventory(EntityPlayer p_openInventory_1_) {
    }

    @Override
    public void closeInventory(EntityPlayer p_closeInventory_1_) {
    }

    @Override
    public boolean isItemValidForSlot(int p_isItemValidForSlot_1_, ItemStack p_isItemValidForSlot_2_) {
        return true;
    }

    @Override
    public void markDirty() {
        this.resetRecipeAndSlots();
    }

    public void resetRecipeAndSlots() {
        this.currentRecipe = null;
        ItemStack lvt_1_1_ = this.theInventory.get(0);
        ItemStack lvt_2_1_ = this.theInventory.get(1);
        if (lvt_1_1_.isEmpty()) {
            lvt_1_1_ = lvt_2_1_;
            lvt_2_1_ = ItemStack.EMPTY;
        }
        if (lvt_1_1_.isEmpty()) {
            this.setInventorySlotContents(2, ItemStack.EMPTY);
        } else {
            MerchantRecipeList lvt_3_1_ = this.theMerchant.getRecipes(this.player);
            if (lvt_3_1_ != null) {
                MerchantRecipe lvt_4_1_ = lvt_3_1_.canRecipeBeUsed(lvt_1_1_, lvt_2_1_, this.currentRecipeIndex);
                if (lvt_4_1_ != null && !lvt_4_1_.isRecipeDisabled()) {
                    this.currentRecipe = lvt_4_1_;
                    this.setInventorySlotContents(2, lvt_4_1_.getItemToSell().copy());
                } else if (!lvt_2_1_.isEmpty()) {
                    lvt_4_1_ = lvt_3_1_.canRecipeBeUsed(lvt_2_1_, lvt_1_1_, this.currentRecipeIndex);
                    if (lvt_4_1_ != null && !lvt_4_1_.isRecipeDisabled()) {
                        this.currentRecipe = lvt_4_1_;
                        this.setInventorySlotContents(2, lvt_4_1_.getItemToSell().copy());
                    } else {
                        this.setInventorySlotContents(2, ItemStack.EMPTY);
                    }
                } else {
                    this.setInventorySlotContents(2, ItemStack.EMPTY);
                }
            }
            this.theMerchant.verifySellingItem(this.getStackInSlot(2));
        }
    }

    public MerchantRecipe getCurrentRecipe() {
        return this.currentRecipe;
    }

    public void setCurrentRecipeIndex(int p_setCurrentRecipeIndex_1_) {
        this.currentRecipeIndex = p_setCurrentRecipeIndex_1_;
        this.resetRecipeAndSlots();
    }

    @Override
    public int getField(int p_getField_1_) {
        return 0;
    }

    @Override
    public void setField(int p_setField_1_, int p_setField_2_) {
    }

    @Override
    public int getFieldCount() {
        return 0;
    }

    @Override
    public void clear() {
        this.theInventory.clear();
    }
}

