/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.inventory;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;

public class ItemStackHelper {
    public static ItemStack getAndSplit(List<ItemStack> p_getAndSplit_0_, int p_getAndSplit_1_, int p_getAndSplit_2_) {
        if (p_getAndSplit_1_ < 0 || p_getAndSplit_1_ >= p_getAndSplit_0_.size() || p_getAndSplit_0_.get(p_getAndSplit_1_).isEmpty() || p_getAndSplit_2_ <= 0) {
            return ItemStack.EMPTY;
        }
        return p_getAndSplit_0_.get(p_getAndSplit_1_).splitStack(p_getAndSplit_2_);
    }

    public static ItemStack getAndRemove(List<ItemStack> p_getAndRemove_0_, int p_getAndRemove_1_) {
        if (p_getAndRemove_1_ < 0 || p_getAndRemove_1_ >= p_getAndRemove_0_.size()) {
            return ItemStack.EMPTY;
        }
        return p_getAndRemove_0_.set(p_getAndRemove_1_, ItemStack.EMPTY);
    }

    public static NBTTagCompound saveAllItems(NBTTagCompound p_saveAllItems_0_, NonNullList<ItemStack> p_saveAllItems_1_) {
        return ItemStackHelper.saveAllItems(p_saveAllItems_0_, p_saveAllItems_1_, true);
    }

    public static NBTTagCompound saveAllItems(NBTTagCompound p_saveAllItems_0_, NonNullList<ItemStack> p_saveAllItems_1_, boolean p_saveAllItems_2_) {
        NBTTagList lvt_3_1_ = new NBTTagList();
        for (int lvt_4_1_ = 0; lvt_4_1_ < p_saveAllItems_1_.size(); ++lvt_4_1_) {
            ItemStack lvt_5_1_ = p_saveAllItems_1_.get(lvt_4_1_);
            if (lvt_5_1_.isEmpty()) continue;
            NBTTagCompound lvt_6_1_ = new NBTTagCompound();
            lvt_6_1_.setByte("Slot", (byte)lvt_4_1_);
            lvt_5_1_.writeToNBT(lvt_6_1_);
            lvt_3_1_.appendTag(lvt_6_1_);
        }
        if (!lvt_3_1_.hasNoTags() || p_saveAllItems_2_) {
            p_saveAllItems_0_.setTag("Items", lvt_3_1_);
        }
        return p_saveAllItems_0_;
    }

    public static void loadAllItems(NBTTagCompound p_loadAllItems_0_, NonNullList<ItemStack> p_loadAllItems_1_) {
        NBTTagList lvt_2_1_ = p_loadAllItems_0_.getTagList("Items", 10);
        for (int lvt_3_1_ = 0; lvt_3_1_ < lvt_2_1_.tagCount(); ++lvt_3_1_) {
            NBTTagCompound lvt_4_1_ = lvt_2_1_.getCompoundTagAt(lvt_3_1_);
            int lvt_5_1_ = lvt_4_1_.getByte("Slot") & 0xFF;
            if (lvt_5_1_ < 0 || lvt_5_1_ >= p_loadAllItems_1_.size()) continue;
            p_loadAllItems_1_.set(lvt_5_1_, new ItemStack(lvt_4_1_));
        }
    }
}

