/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.inventory;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Slot {
    private final int slotIndex;
    public final IInventory inventory;
    public int slotNumber;
    public int xPos;
    public int yPos;
    protected String backgroundName = null;
    protected ResourceLocation backgroundLocation = null;
    protected Object backgroundMap;

    public Slot(IInventory p_i1824_1_, int p_i1824_2_, int p_i1824_3_, int p_i1824_4_) {
        this.inventory = p_i1824_1_;
        this.slotIndex = p_i1824_2_;
        this.xPos = p_i1824_3_;
        this.yPos = p_i1824_4_;
    }

    public void onSlotChange(ItemStack p_onSlotChange_1_, ItemStack p_onSlotChange_2_) {
        int i = p_onSlotChange_2_.getCount() - p_onSlotChange_1_.getCount();
        if (i > 0) {
            this.onCrafting(p_onSlotChange_2_, i);
        }
    }

    protected void onCrafting(ItemStack p_onCrafting_1_, int p_onCrafting_2_) {
    }

    protected void onSwapCraft(int p_onSwapCraft_1_) {
    }

    protected void onCrafting(ItemStack p_onCrafting_1_) {
    }

    public ItemStack onTake(EntityPlayer p_onTake_1_, ItemStack p_onTake_2_) {
        this.onSlotChanged();
        return p_onTake_2_;
    }

    public boolean isItemValid(ItemStack p_isItemValid_1_) {
        return true;
    }

    public ItemStack getStack() {
        return this.inventory.getStackInSlot(this.slotIndex);
    }

    public boolean getHasStack() {
        return !this.getStack().isEmpty();
    }

    public void putStack(ItemStack p_putStack_1_) {
        this.inventory.setInventorySlotContents(this.slotIndex, p_putStack_1_);
        this.onSlotChanged();
    }

    public void onSlotChanged() {
        this.inventory.markDirty();
    }

    public int getSlotStackLimit() {
        return this.inventory.getInventoryStackLimit();
    }

    public int getItemStackLimit(ItemStack p_getItemStackLimit_1_) {
        return this.getSlotStackLimit();
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public String getSlotTexture() {
        return this.backgroundName;
    }

    public ItemStack decrStackSize(int p_decrStackSize_1_) {
        return this.inventory.decrStackSize(this.slotIndex, p_decrStackSize_1_);
    }

    public boolean isHere(IInventory p_isHere_1_, int p_isHere_2_) {
        return p_isHere_1_ == this.inventory && p_isHere_2_ == this.slotIndex;
    }

    public boolean canTakeStack(EntityPlayer p_canTakeStack_1_) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canBeHovered() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getBackgroundLocation() {
        return this.backgroundLocation == null ? TextureMap.LOCATION_BLOCKS_TEXTURE : this.backgroundLocation;
    }

    @SideOnly(value=Side.CLIENT)
    public void setBackgroundLocation(ResourceLocation p_setBackgroundLocation_1_) {
        this.backgroundLocation = p_setBackgroundLocation_1_;
    }

    public void setBackgroundName(String p_setBackgroundName_1_) {
        this.backgroundName = p_setBackgroundName_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getBackgroundSprite() {
        String name = this.getSlotTexture();
        return name == null ? null : this.getBackgroundMap().getAtlasSprite(name);
    }

    @SideOnly(value=Side.CLIENT)
    protected TextureMap getBackgroundMap() {
        if (this.backgroundMap == null) {
            this.backgroundMap = Minecraft.getMinecraft().getTextureMapBlocks();
        }
        return (TextureMap)this.backgroundMap;
    }

    public int getSlotIndex() {
        return this.slotIndex;
    }

    public boolean isSameInventory(Slot p_isSameInventory_1_) {
        return this.inventory == p_isSameInventory_1_.inventory;
    }
}

