/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.stats.AchievementList;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class SlotCrafting
extends Slot {
    private final InventoryCrafting craftMatrix;
    private final EntityPlayer player;
    private int amountCrafted;

    public SlotCrafting(EntityPlayer p_i45790_1_, InventoryCrafting p_i45790_2_, IInventory p_i45790_3_, int p_i45790_4_, int p_i45790_5_, int p_i45790_6_) {
        super(p_i45790_3_, p_i45790_4_, p_i45790_5_, p_i45790_6_);
        this.player = p_i45790_1_;
        this.craftMatrix = p_i45790_2_;
    }

    @Override
    public boolean isItemValid(ItemStack p_isItemValid_1_) {
        return false;
    }

    @Override
    public ItemStack decrStackSize(int p_decrStackSize_1_) {
        if (this.getHasStack()) {
            this.amountCrafted += Math.min(p_decrStackSize_1_, this.getStack().getCount());
        }
        return super.decrStackSize(p_decrStackSize_1_);
    }

    @Override
    protected void onCrafting(ItemStack p_onCrafting_1_, int p_onCrafting_2_) {
        this.amountCrafted += p_onCrafting_2_;
        this.onCrafting(p_onCrafting_1_);
    }

    @Override
    protected void onSwapCraft(int p_onSwapCraft_1_) {
        this.amountCrafted += p_onSwapCraft_1_;
    }

    @Override
    protected void onCrafting(ItemStack p_onCrafting_1_) {
        if (this.amountCrafted > 0) {
            p_onCrafting_1_.onCrafting(this.player.world, this.player, this.amountCrafted);
            FMLCommonHandler.instance().firePlayerCraftingEvent(this.player, p_onCrafting_1_, this.craftMatrix);
        }
        this.amountCrafted = 0;
        if (p_onCrafting_1_.getItem() == Item.getItemFromBlock(Blocks.CRAFTING_TABLE)) {
            this.player.addStat(AchievementList.BUILD_WORK_BENCH);
        }
        if (p_onCrafting_1_.getItem() instanceof ItemPickaxe) {
            this.player.addStat(AchievementList.BUILD_PICKAXE);
        }
        if (p_onCrafting_1_.getItem() == Item.getItemFromBlock(Blocks.FURNACE)) {
            this.player.addStat(AchievementList.BUILD_FURNACE);
        }
        if (p_onCrafting_1_.getItem() instanceof ItemHoe) {
            this.player.addStat(AchievementList.BUILD_HOE);
        }
        if (p_onCrafting_1_.getItem() == Items.BREAD) {
            this.player.addStat(AchievementList.MAKE_BREAD);
        }
        if (p_onCrafting_1_.getItem() == Items.CAKE) {
            this.player.addStat(AchievementList.BAKE_CAKE);
        }
        if (p_onCrafting_1_.getItem() instanceof ItemPickaxe && ((ItemPickaxe)p_onCrafting_1_.getItem()).getToolMaterial() != Item.ToolMaterial.WOOD) {
            this.player.addStat(AchievementList.BUILD_BETTER_PICKAXE);
        }
        if (p_onCrafting_1_.getItem() instanceof ItemSword) {
            this.player.addStat(AchievementList.BUILD_SWORD);
        }
        if (p_onCrafting_1_.getItem() == Item.getItemFromBlock(Blocks.ENCHANTING_TABLE)) {
            this.player.addStat(AchievementList.ENCHANTMENTS);
        }
        if (p_onCrafting_1_.getItem() == Item.getItemFromBlock(Blocks.BOOKSHELF)) {
            this.player.addStat(AchievementList.BOOKCASE);
        }
    }

    @Override
    public ItemStack onTake(EntityPlayer p_onTake_1_, ItemStack p_onTake_2_) {
        this.onCrafting(p_onTake_2_);
        ForgeHooks.setCraftingPlayer(p_onTake_1_);
        NonNullList<ItemStack> nonnulllist = CraftingManager.getInstance().getRemainingItems(this.craftMatrix, p_onTake_1_.world);
        ForgeHooks.setCraftingPlayer(null);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack = this.craftMatrix.getStackInSlot(i);
            ItemStack itemstack1 = nonnulllist.get(i);
            if (!itemstack.isEmpty()) {
                this.craftMatrix.decrStackSize(i, 1);
                itemstack = this.craftMatrix.getStackInSlot(i);
            }
            if (itemstack1.isEmpty()) continue;
            if (itemstack.isEmpty()) {
                this.craftMatrix.setInventorySlotContents(i, itemstack1);
                continue;
            }
            if (ItemStack.areItemsEqual(itemstack, itemstack1) && ItemStack.areItemStackTagsEqual(itemstack, itemstack1)) {
                itemstack1.grow(itemstack.getCount());
                this.craftMatrix.setInventorySlotContents(i, itemstack1);
                continue;
            }
            if (this.player.inventory.addItemStackToInventory(itemstack1)) continue;
            this.player.dropItem(itemstack1, false);
        }
        return p_onTake_2_;
    }
}

