/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.inventory;

import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.stats.AchievementList;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class SlotFurnaceOutput
extends Slot {
    private final EntityPlayer player;
    private int removeCount;

    public SlotFurnaceOutput(EntityPlayer p_i45793_1_, IInventory p_i45793_2_, int p_i45793_3_, int p_i45793_4_, int p_i45793_5_) {
        super(p_i45793_2_, p_i45793_3_, p_i45793_4_, p_i45793_5_);
        this.player = p_i45793_1_;
    }

    @Override
    public boolean isItemValid(ItemStack p_isItemValid_1_) {
        return false;
    }

    @Override
    public ItemStack decrStackSize(int p_decrStackSize_1_) {
        if (this.getHasStack()) {
            this.removeCount += Math.min(p_decrStackSize_1_, this.getStack().getCount());
        }
        return super.decrStackSize(p_decrStackSize_1_);
    }

    @Override
    public ItemStack onTake(EntityPlayer p_onTake_1_, ItemStack p_onTake_2_) {
        this.onCrafting(p_onTake_2_);
        super.onTake(p_onTake_1_, p_onTake_2_);
        return p_onTake_2_;
    }

    @Override
    protected void onCrafting(ItemStack p_onCrafting_1_, int p_onCrafting_2_) {
        this.removeCount += p_onCrafting_2_;
        this.onCrafting(p_onCrafting_1_);
    }

    @Override
    protected void onCrafting(ItemStack p_onCrafting_1_) {
        p_onCrafting_1_.onCrafting(this.player.world, this.player, this.removeCount);
        if (!this.player.world.isRemote) {
            int i = this.removeCount;
            float f = FurnaceRecipes.instance().getSmeltingExperience(p_onCrafting_1_);
            if (f == 0.0f) {
                i = 0;
            } else if (f < 1.0f) {
                int j = MathHelper.floor((float)i * f);
                if (j < MathHelper.ceil((float)i * f) && Math.random() < (double)((float)i * f - (float)j)) {
                    ++j;
                }
                i = j;
            }
            while (i > 0) {
                int k = EntityXPOrb.getXPSplit(i);
                i -= k;
                this.player.world.spawnEntity(new EntityXPOrb(this.player.world, this.player.posX, this.player.posY + 0.5, this.player.posZ + 0.5, k));
            }
        }
        this.removeCount = 0;
        FMLCommonHandler.instance().firePlayerSmeltedEvent(this.player, p_onCrafting_1_);
        if (p_onCrafting_1_.getItem() == Items.IRON_INGOT) {
            this.player.addStat(AchievementList.ACQUIRE_IRON);
        }
        if (p_onCrafting_1_.getItem() == Items.COOKED_FISH) {
            this.player.addStat(AchievementList.COOK_FISH);
        }
    }
}

