/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.inventory;

import net.minecraft.entity.IMerchant;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryMerchant;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.village.MerchantRecipe;

public class SlotMerchantResult
extends Slot {
    private final InventoryMerchant theMerchantInventory;
    private final EntityPlayer player;
    private int removeCount;
    private final IMerchant theMerchant;

    public SlotMerchantResult(EntityPlayer p_i1822_1_, IMerchant p_i1822_2_, InventoryMerchant p_i1822_3_, int p_i1822_4_, int p_i1822_5_, int p_i1822_6_) {
        super(p_i1822_3_, p_i1822_4_, p_i1822_5_, p_i1822_6_);
        this.player = p_i1822_1_;
        this.theMerchant = p_i1822_2_;
        this.theMerchantInventory = p_i1822_3_;
    }

    @Override
    public boolean isItemValid(ItemStack p_isItemValid_1_) {
        return false;
    }

    @Override
    public ItemStack decrStackSize(int p_decrStackSize_1_) {
        if (this.getHasStack()) {
            this.removeCount += Math.min(p_decrStackSize_1_, this.getStack().getCount());
        }
        return super.decrStackSize(p_decrStackSize_1_);
    }

    @Override
    protected void onCrafting(ItemStack p_onCrafting_1_, int p_onCrafting_2_) {
        this.removeCount += p_onCrafting_2_;
        this.onCrafting(p_onCrafting_1_);
    }

    @Override
    protected void onCrafting(ItemStack p_onCrafting_1_) {
        p_onCrafting_1_.onCrafting(this.player.world, this.player, this.removeCount);
        this.removeCount = 0;
    }

    @Override
    public ItemStack onTake(EntityPlayer p_onTake_1_, ItemStack p_onTake_2_) {
        ItemStack lvt_5_1_;
        ItemStack lvt_4_1_;
        this.onCrafting(p_onTake_2_);
        MerchantRecipe lvt_3_1_ = this.theMerchantInventory.getCurrentRecipe();
        if (lvt_3_1_ != null && (this.doTrade(lvt_3_1_, lvt_4_1_ = this.theMerchantInventory.getStackInSlot(0), lvt_5_1_ = this.theMerchantInventory.getStackInSlot(1)) || this.doTrade(lvt_3_1_, lvt_5_1_, lvt_4_1_))) {
            this.theMerchant.useRecipe(lvt_3_1_);
            p_onTake_1_.addStat(StatList.TRADED_WITH_VILLAGER);
            this.theMerchantInventory.setInventorySlotContents(0, lvt_4_1_);
            this.theMerchantInventory.setInventorySlotContents(1, lvt_5_1_);
        }
        return p_onTake_2_;
    }

    private boolean doTrade(MerchantRecipe p_doTrade_1_, ItemStack p_doTrade_2_, ItemStack p_doTrade_3_) {
        ItemStack lvt_4_1_ = p_doTrade_1_.getItemToBuy();
        ItemStack lvt_5_1_ = p_doTrade_1_.getSecondItemToBuy();
        if (p_doTrade_2_.getItem() == lvt_4_1_.getItem() && p_doTrade_2_.getCount() >= lvt_4_1_.getCount()) {
            if (!lvt_5_1_.isEmpty() && !p_doTrade_3_.isEmpty() && lvt_5_1_.getItem() == p_doTrade_3_.getItem() && p_doTrade_3_.getCount() >= lvt_5_1_.getCount()) {
                p_doTrade_2_.shrink(lvt_4_1_.getCount());
                p_doTrade_3_.shrink(lvt_5_1_.getCount());
                return true;
            }
            if (lvt_5_1_.isEmpty() && p_doTrade_3_.isEmpty()) {
                p_doTrade_2_.shrink(lvt_4_1_.getCount());
                return true;
            }
        }
        return false;
    }
}

