/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import net.minecraft.block.material.MapColor;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.text.TextFormatting;

public enum EnumDyeColor implements IStringSerializable
{
    WHITE(0, 15, "white", "white", MapColor.SNOW, TextFormatting.WHITE),
    ORANGE(1, 14, "orange", "orange", MapColor.ADOBE, TextFormatting.GOLD),
    MAGENTA(2, 13, "magenta", "magenta", MapColor.MAGENTA, TextFormatting.AQUA),
    LIGHT_BLUE(3, 12, "light_blue", "lightBlue", MapColor.LIGHT_BLUE, TextFormatting.BLUE),
    YELLOW(4, 11, "yellow", "yellow", MapColor.YELLOW, TextFormatting.YELLOW),
    LIME(5, 10, "lime", "lime", MapColor.LIME, TextFormatting.GREEN),
    PINK(6, 9, "pink", "pink", MapColor.PINK, TextFormatting.LIGHT_PURPLE),
    GRAY(7, 8, "gray", "gray", MapColor.GRAY, TextFormatting.DARK_GRAY),
    SILVER(8, 7, "silver", "silver", MapColor.SILVER, TextFormatting.GRAY),
    CYAN(9, 6, "cyan", "cyan", MapColor.CYAN, TextFormatting.DARK_AQUA),
    PURPLE(10, 5, "purple", "purple", MapColor.PURPLE, TextFormatting.DARK_PURPLE),
    BLUE(11, 4, "blue", "blue", MapColor.BLUE, TextFormatting.DARK_BLUE),
    BROWN(12, 3, "brown", "brown", MapColor.BROWN, TextFormatting.GOLD),
    GREEN(13, 2, "green", "green", MapColor.GREEN, TextFormatting.DARK_GREEN),
    RED(14, 1, "red", "red", MapColor.RED, TextFormatting.DARK_RED),
    BLACK(15, 0, "black", "black", MapColor.BLACK, TextFormatting.BLACK);

    private static final EnumDyeColor[] META_LOOKUP;
    private static final EnumDyeColor[] DYE_DMG_LOOKUP;
    private final int meta;
    private final int dyeDamage;
    private final String name;
    private final String unlocalizedName;
    private final MapColor mapColor;
    private final TextFormatting chatColor;

    private EnumDyeColor(int p_i45786_3_, int p_i45786_4_, String p_i45786_5_, String p_i45786_6_, MapColor p_i45786_7_, TextFormatting p_i45786_8_) {
        this.meta = p_i45786_3_;
        this.dyeDamage = p_i45786_4_;
        this.name = p_i45786_5_;
        this.unlocalizedName = p_i45786_6_;
        this.mapColor = p_i45786_7_;
        this.chatColor = p_i45786_8_;
    }

    public int getMetadata() {
        return this.meta;
    }

    public int getDyeDamage() {
        return this.dyeDamage;
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    public MapColor getMapColor() {
        return this.mapColor;
    }

    public static EnumDyeColor byDyeDamage(int p_byDyeDamage_0_) {
        if (p_byDyeDamage_0_ < 0 || p_byDyeDamage_0_ >= DYE_DMG_LOOKUP.length) {
            p_byDyeDamage_0_ = 0;
        }
        return DYE_DMG_LOOKUP[p_byDyeDamage_0_];
    }

    public static EnumDyeColor byMetadata(int p_byMetadata_0_) {
        if (p_byMetadata_0_ < 0 || p_byMetadata_0_ >= META_LOOKUP.length) {
            p_byMetadata_0_ = 0;
        }
        return META_LOOKUP[p_byMetadata_0_];
    }

    public String toString() {
        return this.unlocalizedName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    static {
        META_LOOKUP = new EnumDyeColor[EnumDyeColor.values().length];
        DYE_DMG_LOOKUP = new EnumDyeColor[EnumDyeColor.values().length];
        EnumDyeColor[] enumDyeColorArray = EnumDyeColor.values();
        int n = enumDyeColorArray.length;
        for (int i = 0; i < n; ++i) {
            EnumDyeColor lvt_3_1_;
            EnumDyeColor.META_LOOKUP[lvt_3_1_.getMetadata()] = lvt_3_1_ = enumDyeColorArray[i];
            EnumDyeColor.DYE_DMG_LOOKUP[lvt_3_1_.getDyeDamage()] = lvt_3_1_;
        }
    }
}

