/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.BlockDispenser;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemArmor
extends Item {
    private static final int[] MAX_DAMAGE_ARRAY = new int[]{13, 15, 16, 11};
    private static final UUID[] ARMOR_MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    public static final String[] EMPTY_SLOT_NAMES = new String[]{"minecraft:items/empty_armor_slot_boots", "minecraft:items/empty_armor_slot_leggings", "minecraft:items/empty_armor_slot_chestplate", "minecraft:items/empty_armor_slot_helmet"};
    public static final IBehaviorDispenseItem DISPENSER_BEHAVIOR = new BehaviorDefaultDispenseItem(){

        @Override
        protected ItemStack dispenseStack(IBlockSource p_dispenseStack_1_, ItemStack p_dispenseStack_2_) {
            ItemStack itemstack = ItemArmor.dispenseArmor(p_dispenseStack_1_, p_dispenseStack_2_);
            return itemstack.isEmpty() ? super.dispenseStack(p_dispenseStack_1_, p_dispenseStack_2_) : itemstack;
        }
    };
    public final EntityEquipmentSlot armorType;
    public final int damageReduceAmount;
    public final float toughness;
    public final int renderIndex;
    private final ArmorMaterial material;

    public static ItemStack dispenseArmor(IBlockSource p_dispenseArmor_0_, ItemStack p_dispenseArmor_1_) {
        BlockPos blockpos = p_dispenseArmor_0_.getBlockPos().offset(p_dispenseArmor_0_.getBlockState().getValue(BlockDispenser.FACING));
        List<EntityLivingBase> list = p_dispenseArmor_0_.getWorld().getEntitiesWithinAABB(EntityLivingBase.class, new AxisAlignedBB(blockpos), Predicates.and(EntitySelectors.NOT_SPECTATING, (Predicate)new EntitySelectors.ArmoredMob(p_dispenseArmor_1_)));
        if (list.isEmpty()) {
            return ItemStack.EMPTY;
        }
        EntityLivingBase entitylivingbase = list.get(0);
        EntityEquipmentSlot entityequipmentslot = EntityLiving.getSlotForItemStack(p_dispenseArmor_1_);
        ItemStack itemstack = p_dispenseArmor_1_.splitStack(1);
        entitylivingbase.setItemStackToSlot(entityequipmentslot, itemstack);
        if (entitylivingbase instanceof EntityLiving) {
            ((EntityLiving)entitylivingbase).setDropChance(entityequipmentslot, 2.0f);
        }
        return p_dispenseArmor_1_;
    }

    public ItemArmor(ArmorMaterial p_i46750_1_, int p_i46750_2_, EntityEquipmentSlot p_i46750_3_) {
        this.material = p_i46750_1_;
        this.armorType = p_i46750_3_;
        this.renderIndex = p_i46750_2_;
        this.damageReduceAmount = p_i46750_1_.getDamageReductionAmount(p_i46750_3_);
        this.setMaxDamage(p_i46750_1_.getDurability(p_i46750_3_));
        this.toughness = p_i46750_1_.getToughness();
        this.maxStackSize = 1;
        this.setCreativeTab(CreativeTabs.COMBAT);
        BlockDispenser.DISPENSE_BEHAVIOR_REGISTRY.putObject(this, DISPENSER_BEHAVIOR);
    }

    @SideOnly(value=Side.CLIENT)
    public EntityEquipmentSlot getEquipmentSlot() {
        return this.armorType;
    }

    @Override
    public int getItemEnchantability() {
        return this.material.getEnchantability();
    }

    public ArmorMaterial getArmorMaterial() {
        return this.material;
    }

    public boolean hasColor(ItemStack p_hasColor_1_) {
        if (this.material != ArmorMaterial.LEATHER) {
            return false;
        }
        NBTTagCompound nbttagcompound = p_hasColor_1_.getTagCompound();
        return nbttagcompound != null && nbttagcompound.hasKey("display", 10) ? nbttagcompound.getCompoundTag("display").hasKey("color", 3) : false;
    }

    public int getColor(ItemStack p_getColor_1_) {
        NBTTagCompound nbttagcompound1;
        if (this.material != ArmorMaterial.LEATHER) {
            return 0xFFFFFF;
        }
        NBTTagCompound nbttagcompound = p_getColor_1_.getTagCompound();
        if (nbttagcompound != null && (nbttagcompound1 = nbttagcompound.getCompoundTag("display")) != null && nbttagcompound1.hasKey("color", 3)) {
            return nbttagcompound1.getInteger("color");
        }
        return 10511680;
    }

    public void removeColor(ItemStack p_removeColor_1_) {
        NBTTagCompound nbttagcompound1;
        NBTTagCompound nbttagcompound;
        if (this.material == ArmorMaterial.LEATHER && (nbttagcompound = p_removeColor_1_.getTagCompound()) != null && (nbttagcompound1 = nbttagcompound.getCompoundTag("display")).hasKey("color")) {
            nbttagcompound1.removeTag("color");
        }
    }

    public void setColor(ItemStack p_setColor_1_, int p_setColor_2_) {
        if (this.material != ArmorMaterial.LEATHER) {
            throw new UnsupportedOperationException("Can't dye non-leather!");
        }
        NBTTagCompound nbttagcompound = p_setColor_1_.getTagCompound();
        if (nbttagcompound == null) {
            nbttagcompound = new NBTTagCompound();
            p_setColor_1_.setTagCompound(nbttagcompound);
        }
        NBTTagCompound nbttagcompound1 = nbttagcompound.getCompoundTag("display");
        if (!nbttagcompound.hasKey("display", 10)) {
            nbttagcompound.setTag("display", nbttagcompound1);
        }
        nbttagcompound1.setInteger("color", p_setColor_2_);
    }

    @Override
    public boolean getIsRepairable(ItemStack p_getIsRepairable_1_, ItemStack p_getIsRepairable_2_) {
        ItemStack mat = this.material.getRepairItemStack();
        if (!mat.isEmpty() && OreDictionary.itemMatches(mat, p_getIsRepairable_2_, false)) {
            return true;
        }
        return super.getIsRepairable(p_getIsRepairable_1_, p_getIsRepairable_2_);
    }

    @Override
    public ActionResult<ItemStack> onItemRightClick(World p_onItemRightClick_1_, EntityPlayer p_onItemRightClick_2_, EnumHand p_onItemRightClick_3_) {
        ItemStack itemstack = p_onItemRightClick_2_.getHeldItem(p_onItemRightClick_3_);
        EntityEquipmentSlot entityequipmentslot = EntityLiving.getSlotForItemStack(itemstack);
        ItemStack itemstack1 = p_onItemRightClick_2_.getItemStackFromSlot(entityequipmentslot);
        if (itemstack1.isEmpty()) {
            p_onItemRightClick_2_.setItemStackToSlot(entityequipmentslot, itemstack.copy());
            itemstack.setCount(0);
            return new ActionResult<ItemStack>(EnumActionResult.SUCCESS, itemstack);
        }
        return new ActionResult<ItemStack>(EnumActionResult.FAIL, itemstack);
    }

    @Override
    public Multimap<String, AttributeModifier> getItemAttributeModifiers(EntityEquipmentSlot p_getItemAttributeModifiers_1_) {
        Multimap<String, AttributeModifier> multimap = super.getItemAttributeModifiers(p_getItemAttributeModifiers_1_);
        if (p_getItemAttributeModifiers_1_ == this.armorType) {
            multimap.put((Object)SharedMonsterAttributes.ARMOR.getName(), (Object)new AttributeModifier(ARMOR_MODIFIERS[p_getItemAttributeModifiers_1_.getIndex()], "Armor modifier", this.damageReduceAmount, 0));
            multimap.put((Object)SharedMonsterAttributes.ARMOR_TOUGHNESS.getName(), (Object)new AttributeModifier(ARMOR_MODIFIERS[p_getItemAttributeModifiers_1_.getIndex()], "Armor toughness", this.toughness, 0));
        }
        return multimap;
    }

    public boolean hasOverlay(ItemStack p_hasOverlay_1_) {
        return this.material == ArmorMaterial.LEATHER || this.getColor(p_hasOverlay_1_) != 0xFFFFFF;
    }

    public static enum ArmorMaterial {
        LEATHER("leather", 5, new int[]{1, 2, 3, 1}, 15, SoundEvents.ITEM_ARMOR_EQUIP_LEATHER, 0.0f),
        CHAIN("chainmail", 15, new int[]{1, 4, 5, 2}, 12, SoundEvents.ITEM_ARMOR_EQUIP_CHAIN, 0.0f),
        IRON("iron", 15, new int[]{2, 5, 6, 2}, 9, SoundEvents.ITEM_ARMOR_EQUIP_IRON, 0.0f),
        GOLD("gold", 7, new int[]{1, 3, 5, 2}, 25, SoundEvents.ITEM_ARMOR_EQUIP_GOLD, 0.0f),
        DIAMOND("diamond", 33, new int[]{3, 6, 8, 3}, 10, SoundEvents.ITEM_ARMOR_EQUIP_DIAMOND, 2.0f);

        private final String name;
        private final int maxDamageFactor;
        private final int[] damageReductionAmountArray;
        private final int enchantability;
        private final SoundEvent soundEvent;
        private final float toughness;
        public ItemStack repairMaterial = ItemStack.EMPTY;

        private ArmorMaterial(String p_i47117_3_, int p_i47117_4_, int[] p_i47117_5_, int p_i47117_6_, SoundEvent p_i47117_7_, float p_i47117_8_) {
            this.name = p_i47117_3_;
            this.maxDamageFactor = p_i47117_4_;
            this.damageReductionAmountArray = p_i47117_5_;
            this.enchantability = p_i47117_6_;
            this.soundEvent = p_i47117_7_;
            this.toughness = p_i47117_8_;
        }

        public int getDurability(EntityEquipmentSlot p_getDurability_1_) {
            return MAX_DAMAGE_ARRAY[p_getDurability_1_.getIndex()] * this.maxDamageFactor;
        }

        public int getDamageReductionAmount(EntityEquipmentSlot p_getDamageReductionAmount_1_) {
            return this.damageReductionAmountArray[p_getDamageReductionAmount_1_.getIndex()];
        }

        public int getEnchantability() {
            return this.enchantability;
        }

        public SoundEvent getSoundEvent() {
            return this.soundEvent;
        }

        @Deprecated
        public Item getRepairItem() {
            return this == LEATHER ? Items.LEATHER : (this == CHAIN ? Items.IRON_INGOT : (this == GOLD ? Items.GOLD_INGOT : (this == IRON ? Items.IRON_INGOT : (this == DIAMOND ? Items.DIAMOND : null))));
        }

        @SideOnly(value=Side.CLIENT)
        public String getName() {
            return this.name;
        }

        public float getToughness() {
            return this.toughness;
        }

        public ArmorMaterial setRepairItem(ItemStack p_setRepairItem_1_) {
            if (!this.repairMaterial.isEmpty()) {
                throw new RuntimeException("Repair material has already been set");
            }
            if (this == LEATHER || this == CHAIN || this == GOLD || this == IRON || this == DIAMOND) {
                throw new RuntimeException("Can not change vanilla armor repair materials");
            }
            this.repairMaterial = p_setRepairItem_1_;
            return this;
        }

        public ItemStack getRepairItemStack() {
            if (!this.repairMaterial.isEmpty()) {
                return this.repairMaterial;
            }
            Item ret = this.getRepairItem();
            if (ret != null) {
                this.repairMaterial = new ItemStack(ret, 1, Short.MAX_VALUE);
            }
            return this.repairMaterial;
        }
    }
}

