/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import java.util.List;
import net.minecraft.block.BlockStandingSign;
import net.minecraft.block.BlockWallSign;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBanner
extends ItemBlock {
    public ItemBanner() {
        super(Blocks.STANDING_BANNER);
        this.maxStackSize = 16;
        this.setCreativeTab(CreativeTabs.DECORATIONS);
        this.setHasSubtypes(true);
        this.setMaxDamage(0);
    }

    @Override
    public EnumActionResult onItemUse(EntityPlayer p_onItemUse_1_, World p_onItemUse_2_, BlockPos p_onItemUse_3_, EnumHand p_onItemUse_4_, EnumFacing p_onItemUse_5_, float p_onItemUse_6_, float p_onItemUse_7_, float p_onItemUse_8_) {
        ItemStack lvt_11_1_;
        IBlockState lvt_9_1_ = p_onItemUse_2_.getBlockState(p_onItemUse_3_);
        boolean lvt_10_1_ = lvt_9_1_.getBlock().isReplaceable(p_onItemUse_2_, p_onItemUse_3_);
        if (p_onItemUse_5_ == EnumFacing.DOWN || !lvt_9_1_.getMaterial().isSolid() && !lvt_10_1_ || lvt_10_1_ && p_onItemUse_5_ != EnumFacing.UP) {
            return EnumActionResult.FAIL;
        }
        if (!p_onItemUse_1_.canPlayerEdit(p_onItemUse_3_ = p_onItemUse_3_.offset(p_onItemUse_5_), p_onItemUse_5_, lvt_11_1_ = p_onItemUse_1_.getHeldItem(p_onItemUse_4_)) || !Blocks.STANDING_BANNER.canPlaceBlockAt(p_onItemUse_2_, p_onItemUse_3_)) {
            return EnumActionResult.FAIL;
        }
        if (p_onItemUse_2_.isRemote) {
            return EnumActionResult.SUCCESS;
        }
        BlockPos blockPos = p_onItemUse_3_ = lvt_10_1_ ? p_onItemUse_3_.down() : p_onItemUse_3_;
        if (p_onItemUse_5_ == EnumFacing.UP) {
            int lvt_12_1_ = MathHelper.floor((double)((p_onItemUse_1_.rotationYaw + 180.0f) * 16.0f / 360.0f) + 0.5) & 0xF;
            p_onItemUse_2_.setBlockState(p_onItemUse_3_, Blocks.STANDING_BANNER.getDefaultState().withProperty(BlockStandingSign.ROTATION, lvt_12_1_), 3);
        } else {
            p_onItemUse_2_.setBlockState(p_onItemUse_3_, Blocks.WALL_BANNER.getDefaultState().withProperty(BlockWallSign.FACING, p_onItemUse_5_), 3);
        }
        TileEntity lvt_12_2_ = p_onItemUse_2_.getTileEntity(p_onItemUse_3_);
        if (lvt_12_2_ instanceof TileEntityBanner) {
            ((TileEntityBanner)lvt_12_2_).setItemValues(lvt_11_1_, false);
        }
        lvt_11_1_.shrink(1);
        return EnumActionResult.SUCCESS;
    }

    @Override
    public String getItemStackDisplayName(ItemStack p_getItemStackDisplayName_1_) {
        String lvt_2_1_ = "item.banner.";
        EnumDyeColor lvt_3_1_ = ItemBanner.getBaseColor(p_getItemStackDisplayName_1_);
        lvt_2_1_ = lvt_2_1_ + lvt_3_1_.getUnlocalizedName() + ".name";
        return I18n.translateToLocal(lvt_2_1_);
    }

    @SideOnly(value=Side.CLIENT)
    public static void appendHoverTextFromTileEntityTag(ItemStack p_appendHoverTextFromTileEntityTag_0_, List<String> p_appendHoverTextFromTileEntityTag_1_) {
        NBTTagCompound lvt_2_1_ = p_appendHoverTextFromTileEntityTag_0_.getSubCompound("BlockEntityTag");
        if (lvt_2_1_ == null || !lvt_2_1_.hasKey("Patterns")) {
            return;
        }
        NBTTagList lvt_3_1_ = lvt_2_1_.getTagList("Patterns", 10);
        for (int lvt_4_1_ = 0; lvt_4_1_ < lvt_3_1_.tagCount() && lvt_4_1_ < 6; ++lvt_4_1_) {
            NBTTagCompound lvt_5_1_ = lvt_3_1_.getCompoundTagAt(lvt_4_1_);
            EnumDyeColor lvt_6_1_ = EnumDyeColor.byDyeDamage(lvt_5_1_.getInteger("Color"));
            BannerPattern lvt_7_1_ = BannerPattern.byHash(lvt_5_1_.getString("Pattern"));
            if (lvt_7_1_ == null) continue;
            p_appendHoverTextFromTileEntityTag_1_.add(I18n.translateToLocal("item.banner." + lvt_7_1_.getFileName() + "." + lvt_6_1_.getUnlocalizedName()));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack p_addInformation_1_, EntityPlayer p_addInformation_2_, List<String> p_addInformation_3_, boolean p_addInformation_4_) {
        ItemBanner.appendHoverTextFromTileEntityTag(p_addInformation_1_, p_addInformation_3_);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item p_getSubItems_1_, CreativeTabs p_getSubItems_2_, NonNullList<ItemStack> p_getSubItems_3_) {
        for (EnumDyeColor lvt_7_1_ : EnumDyeColor.values()) {
            p_getSubItems_3_.add(ItemBanner.makeBanner(lvt_7_1_, null));
        }
    }

    public static ItemStack makeBanner(EnumDyeColor p_makeBanner_0_, NBTTagList p_makeBanner_1_) {
        ItemStack lvt_2_1_ = new ItemStack(Items.BANNER, 1, p_makeBanner_0_.getDyeDamage());
        if (p_makeBanner_1_ != null && !p_makeBanner_1_.hasNoTags()) {
            lvt_2_1_.getOrCreateSubCompound("BlockEntityTag").setTag("Patterns", p_makeBanner_1_.copy());
        }
        return lvt_2_1_;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public CreativeTabs getCreativeTab() {
        return CreativeTabs.DECORATIONS;
    }

    public static EnumDyeColor getBaseColor(ItemStack p_getBaseColor_0_) {
        return EnumDyeColor.byDyeDamage(p_getBaseColor_0_.getMetadata() & 0xF);
    }
}

