/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class ItemBed
extends Item {
    public ItemBed() {
        this.setCreativeTab(CreativeTabs.DECORATIONS);
    }

    @Override
    public EnumActionResult onItemUse(EntityPlayer p_onItemUse_1_, World p_onItemUse_2_, BlockPos p_onItemUse_3_, EnumHand p_onItemUse_4_, EnumFacing p_onItemUse_5_, float p_onItemUse_6_, float p_onItemUse_7_, float p_onItemUse_8_) {
        if (p_onItemUse_2_.isRemote) {
            return EnumActionResult.SUCCESS;
        }
        if (p_onItemUse_5_ != EnumFacing.UP) {
            return EnumActionResult.FAIL;
        }
        IBlockState iblockstate = p_onItemUse_2_.getBlockState(p_onItemUse_3_);
        Block block = iblockstate.getBlock();
        boolean flag = block.isReplaceable(p_onItemUse_2_, p_onItemUse_3_);
        if (!flag) {
            p_onItemUse_3_ = p_onItemUse_3_.up();
        }
        int i = MathHelper.floor((double)(p_onItemUse_1_.rotationYaw * 4.0f / 360.0f) + 0.5) & 3;
        EnumFacing enumfacing = EnumFacing.getHorizontal(i);
        BlockPos blockpos = p_onItemUse_3_.offset(enumfacing);
        ItemStack itemstack = p_onItemUse_1_.getHeldItem(p_onItemUse_4_);
        if (p_onItemUse_1_.canPlayerEdit(p_onItemUse_3_, p_onItemUse_5_, itemstack) && p_onItemUse_1_.canPlayerEdit(blockpos, p_onItemUse_5_, itemstack)) {
            boolean flag3;
            IBlockState iblockstate1 = p_onItemUse_2_.getBlockState(blockpos);
            boolean flag1 = iblockstate1.getBlock().isReplaceable(p_onItemUse_2_, blockpos);
            boolean flag2 = flag || p_onItemUse_2_.isAirBlock(p_onItemUse_3_);
            boolean bl = flag3 = flag1 || p_onItemUse_2_.isAirBlock(blockpos);
            if (flag2 && flag3 && p_onItemUse_2_.getBlockState(p_onItemUse_3_.down()).isFullyOpaque() && p_onItemUse_2_.getBlockState(blockpos.down()).isFullyOpaque()) {
                IBlockState iblockstate2 = Blocks.BED.getDefaultState().withProperty(BlockBed.OCCUPIED, false).withProperty(BlockBed.FACING, enumfacing).withProperty(BlockBed.PART, BlockBed.EnumPartType.FOOT);
                p_onItemUse_2_.setBlockState(p_onItemUse_3_, iblockstate2, 10);
                p_onItemUse_2_.setBlockState(blockpos, iblockstate2.withProperty(BlockBed.PART, BlockBed.EnumPartType.HEAD), 10);
                p_onItemUse_2_.notifyNeighborsRespectDebug(p_onItemUse_3_, block, false);
                p_onItemUse_2_.notifyNeighborsRespectDebug(blockpos, iblockstate1.getBlock(), false);
                SoundType soundtype = iblockstate2.getBlock().getSoundType(iblockstate2, p_onItemUse_2_, p_onItemUse_3_, p_onItemUse_1_);
                p_onItemUse_2_.playSound(null, p_onItemUse_3_, soundtype.getPlaceSound(), SoundCategory.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
                itemstack.shrink(1);
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.FAIL;
        }
        return EnumActionResult.FAIL;
    }
}

