/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBlock
extends Item {
    public final Block block;

    public ItemBlock(Block p_i45328_1_) {
        this.block = p_i45328_1_;
    }

    @Override
    public EnumActionResult onItemUse(EntityPlayer p_onItemUse_1_, World p_onItemUse_2_, BlockPos p_onItemUse_3_, EnumHand p_onItemUse_4_, EnumFacing p_onItemUse_5_, float p_onItemUse_6_, float p_onItemUse_7_, float p_onItemUse_8_) {
        ItemStack itemstack;
        IBlockState iblockstate = p_onItemUse_2_.getBlockState(p_onItemUse_3_);
        Block block = iblockstate.getBlock();
        if (!block.isReplaceable(p_onItemUse_2_, p_onItemUse_3_)) {
            p_onItemUse_3_ = p_onItemUse_3_.offset(p_onItemUse_5_);
        }
        if (!(itemstack = p_onItemUse_1_.getHeldItem(p_onItemUse_4_)).isEmpty() && p_onItemUse_1_.canPlayerEdit(p_onItemUse_3_, p_onItemUse_5_, itemstack) && p_onItemUse_2_.mayPlace(this.block, p_onItemUse_3_, false, p_onItemUse_5_, null)) {
            int i = this.getMetadata(itemstack.getMetadata());
            IBlockState iblockstate1 = this.block.getStateForPlacement(p_onItemUse_2_, p_onItemUse_3_, p_onItemUse_5_, p_onItemUse_6_, p_onItemUse_7_, p_onItemUse_8_, i, p_onItemUse_1_, p_onItemUse_4_);
            if (this.placeBlockAt(itemstack, p_onItemUse_1_, p_onItemUse_2_, p_onItemUse_3_, p_onItemUse_5_, p_onItemUse_6_, p_onItemUse_7_, p_onItemUse_8_, iblockstate1)) {
                SoundType soundtype = p_onItemUse_2_.getBlockState(p_onItemUse_3_).getBlock().getSoundType(p_onItemUse_2_.getBlockState(p_onItemUse_3_), p_onItemUse_2_, p_onItemUse_3_, p_onItemUse_1_);
                p_onItemUse_2_.playSound(p_onItemUse_1_, p_onItemUse_3_, soundtype.getPlaceSound(), SoundCategory.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
                itemstack.shrink(1);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public static boolean setTileEntityNBT(World p_setTileEntityNBT_0_, EntityPlayer p_setTileEntityNBT_1_, BlockPos p_setTileEntityNBT_2_, ItemStack p_setTileEntityNBT_3_) {
        TileEntity tileentity;
        MinecraftServer minecraftserver = p_setTileEntityNBT_0_.getMinecraftServer();
        if (minecraftserver == null) {
            return false;
        }
        NBTTagCompound nbttagcompound = p_setTileEntityNBT_3_.getSubCompound("BlockEntityTag");
        if (nbttagcompound != null && (tileentity = p_setTileEntityNBT_0_.getTileEntity(p_setTileEntityNBT_2_)) != null) {
            if (!(p_setTileEntityNBT_0_.isRemote || !tileentity.onlyOpsCanSetNbt() || p_setTileEntityNBT_1_ != null && p_setTileEntityNBT_1_.canUseCommandBlock())) {
                return false;
            }
            NBTTagCompound nbttagcompound1 = tileentity.writeToNBT(new NBTTagCompound());
            NBTTagCompound nbttagcompound2 = nbttagcompound1.copy();
            nbttagcompound1.merge(nbttagcompound);
            nbttagcompound1.setInteger("x", p_setTileEntityNBT_2_.getX());
            nbttagcompound1.setInteger("y", p_setTileEntityNBT_2_.getY());
            nbttagcompound1.setInteger("z", p_setTileEntityNBT_2_.getZ());
            if (!nbttagcompound1.equals(nbttagcompound2)) {
                tileentity.readFromNBT(nbttagcompound1);
                tileentity.markDirty();
                return true;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canPlaceBlockOnSide(World p_canPlaceBlockOnSide_1_, BlockPos p_canPlaceBlockOnSide_2_, EnumFacing p_canPlaceBlockOnSide_3_, EntityPlayer p_canPlaceBlockOnSide_4_, ItemStack p_canPlaceBlockOnSide_5_) {
        Block block = p_canPlaceBlockOnSide_1_.getBlockState(p_canPlaceBlockOnSide_2_).getBlock();
        if (block == Blocks.SNOW_LAYER && block.isReplaceable(p_canPlaceBlockOnSide_1_, p_canPlaceBlockOnSide_2_)) {
            p_canPlaceBlockOnSide_3_ = EnumFacing.UP;
        } else if (!block.isReplaceable(p_canPlaceBlockOnSide_1_, p_canPlaceBlockOnSide_2_)) {
            p_canPlaceBlockOnSide_2_ = p_canPlaceBlockOnSide_2_.offset(p_canPlaceBlockOnSide_3_);
        }
        return p_canPlaceBlockOnSide_1_.mayPlace(this.block, p_canPlaceBlockOnSide_2_, false, p_canPlaceBlockOnSide_3_, null);
    }

    @Override
    public String getUnlocalizedName(ItemStack p_getUnlocalizedName_1_) {
        return this.block.getUnlocalizedName();
    }

    @Override
    public String getUnlocalizedName() {
        return this.block.getUnlocalizedName();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public CreativeTabs getCreativeTab() {
        return this.block.getCreativeTabToDisplayOn();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item p_getSubItems_1_, CreativeTabs p_getSubItems_2_, NonNullList<ItemStack> p_getSubItems_3_) {
        this.block.getSubBlocks(p_getSubItems_1_, p_getSubItems_2_, p_getSubItems_3_);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack p_addInformation_1_, EntityPlayer p_addInformation_2_, List<String> p_addInformation_3_, boolean p_addInformation_4_) {
        super.addInformation(p_addInformation_1_, p_addInformation_2_, p_addInformation_3_, p_addInformation_4_);
        this.block.addInformation(p_addInformation_1_, p_addInformation_2_, p_addInformation_3_, p_addInformation_4_);
    }

    public Block getBlock() {
        return this.block;
    }

    public boolean placeBlockAt(ItemStack p_placeBlockAt_1_, EntityPlayer p_placeBlockAt_2_, World p_placeBlockAt_3_, BlockPos p_placeBlockAt_4_, EnumFacing p_placeBlockAt_5_, float p_placeBlockAt_6_, float p_placeBlockAt_7_, float p_placeBlockAt_8_, IBlockState p_placeBlockAt_9_) {
        if (!p_placeBlockAt_3_.setBlockState(p_placeBlockAt_4_, p_placeBlockAt_9_, 11)) {
            return false;
        }
        IBlockState state = p_placeBlockAt_3_.getBlockState(p_placeBlockAt_4_);
        if (state.getBlock() == this.block) {
            ItemBlock.setTileEntityNBT(p_placeBlockAt_3_, p_placeBlockAt_2_, p_placeBlockAt_4_, p_placeBlockAt_1_);
            this.block.onBlockPlacedBy(p_placeBlockAt_3_, p_placeBlockAt_4_, state, p_placeBlockAt_2_, p_placeBlockAt_1_);
        }
        return true;
    }
}

