/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import net.minecraft.block.Block;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemBlockSpecial
extends Item {
    private final Block block;

    public ItemBlockSpecial(Block p_i45329_1_) {
        this.block = p_i45329_1_;
    }

    @Override
    public EnumActionResult onItemUse(EntityPlayer p_onItemUse_1_, World p_onItemUse_2_, BlockPos p_onItemUse_3_, EnumHand p_onItemUse_4_, EnumFacing p_onItemUse_5_, float p_onItemUse_6_, float p_onItemUse_7_, float p_onItemUse_8_) {
        IBlockState iblockstate = p_onItemUse_2_.getBlockState(p_onItemUse_3_);
        Block block = iblockstate.getBlock();
        if (block == Blocks.SNOW_LAYER && iblockstate.getValue(BlockSnow.LAYERS) < 1) {
            p_onItemUse_5_ = EnumFacing.UP;
        } else if (!block.isReplaceable(p_onItemUse_2_, p_onItemUse_3_)) {
            p_onItemUse_3_ = p_onItemUse_3_.offset(p_onItemUse_5_);
        }
        ItemStack itemstack = p_onItemUse_1_.getHeldItem(p_onItemUse_4_);
        if (!itemstack.isEmpty() && p_onItemUse_1_.canPlayerEdit(p_onItemUse_3_, p_onItemUse_5_, itemstack) && p_onItemUse_2_.mayPlace(this.block, p_onItemUse_3_, false, p_onItemUse_5_, null)) {
            IBlockState iblockstate1 = this.block.getStateForPlacement(p_onItemUse_2_, p_onItemUse_3_, p_onItemUse_5_, p_onItemUse_6_, p_onItemUse_7_, p_onItemUse_8_, 0, p_onItemUse_1_, p_onItemUse_4_);
            if (!p_onItemUse_2_.setBlockState(p_onItemUse_3_, iblockstate1, 11)) {
                return EnumActionResult.FAIL;
            }
            iblockstate1 = p_onItemUse_2_.getBlockState(p_onItemUse_3_);
            if (iblockstate1.getBlock() == this.block) {
                ItemBlock.setTileEntityNBT(p_onItemUse_2_, p_onItemUse_1_, p_onItemUse_3_, itemstack);
                iblockstate1.getBlock().onBlockPlacedBy(p_onItemUse_2_, p_onItemUse_3_, iblockstate1, p_onItemUse_1_, itemstack);
            }
            SoundType soundtype = iblockstate1.getBlock().getSoundType(iblockstate1, p_onItemUse_2_, p_onItemUse_3_, p_onItemUse_1_);
            p_onItemUse_2_.playSound(p_onItemUse_1_, p_onItemUse_3_, soundtype.getPlaceSound(), SoundCategory.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
            itemstack.shrink(1);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public Block getBlock() {
        return this.block;
    }
}

