/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ItemBoat
extends Item {
    private final EntityBoat.Type type;

    public ItemBoat(EntityBoat.Type p_i46748_1_) {
        this.type = p_i46748_1_;
        this.maxStackSize = 1;
        this.setCreativeTab(CreativeTabs.TRANSPORTATION);
        this.setUnlocalizedName("boat." + p_i46748_1_.getName());
    }

    @Override
    public ActionResult<ItemStack> onItemRightClick(World p_onItemRightClick_1_, EntityPlayer p_onItemRightClick_2_, EnumHand p_onItemRightClick_3_) {
        ItemStack lvt_4_1_ = p_onItemRightClick_2_.getHeldItem(p_onItemRightClick_3_);
        float lvt_5_1_ = 1.0f;
        float lvt_6_1_ = p_onItemRightClick_2_.prevRotationPitch + (p_onItemRightClick_2_.rotationPitch - p_onItemRightClick_2_.prevRotationPitch) * 1.0f;
        float lvt_7_1_ = p_onItemRightClick_2_.prevRotationYaw + (p_onItemRightClick_2_.rotationYaw - p_onItemRightClick_2_.prevRotationYaw) * 1.0f;
        double lvt_8_1_ = p_onItemRightClick_2_.prevPosX + (p_onItemRightClick_2_.posX - p_onItemRightClick_2_.prevPosX) * 1.0;
        double lvt_10_1_ = p_onItemRightClick_2_.prevPosY + (p_onItemRightClick_2_.posY - p_onItemRightClick_2_.prevPosY) * 1.0 + (double)p_onItemRightClick_2_.getEyeHeight();
        double lvt_12_1_ = p_onItemRightClick_2_.prevPosZ + (p_onItemRightClick_2_.posZ - p_onItemRightClick_2_.prevPosZ) * 1.0;
        Vec3d lvt_14_1_ = new Vec3d(lvt_8_1_, lvt_10_1_, lvt_12_1_);
        float lvt_15_1_ = MathHelper.cos(-lvt_7_1_ * ((float)Math.PI / 180) - (float)Math.PI);
        float lvt_16_1_ = MathHelper.sin(-lvt_7_1_ * ((float)Math.PI / 180) - (float)Math.PI);
        float lvt_17_1_ = -MathHelper.cos(-lvt_6_1_ * ((float)Math.PI / 180));
        float lvt_18_1_ = MathHelper.sin(-lvt_6_1_ * ((float)Math.PI / 180));
        float lvt_19_1_ = lvt_16_1_ * lvt_17_1_;
        float lvt_20_1_ = lvt_18_1_;
        float lvt_21_1_ = lvt_15_1_ * lvt_17_1_;
        double lvt_22_1_ = 5.0;
        Vec3d lvt_24_1_ = lvt_14_1_.addVector((double)lvt_19_1_ * 5.0, (double)lvt_20_1_ * 5.0, (double)lvt_21_1_ * 5.0);
        RayTraceResult lvt_25_1_ = p_onItemRightClick_1_.rayTraceBlocks(lvt_14_1_, lvt_24_1_, true);
        if (lvt_25_1_ == null) {
            return new ActionResult<ItemStack>(EnumActionResult.PASS, lvt_4_1_);
        }
        Vec3d lvt_26_1_ = p_onItemRightClick_2_.getLook(1.0f);
        boolean lvt_27_1_ = false;
        List<Entity> lvt_28_1_ = p_onItemRightClick_1_.getEntitiesWithinAABBExcludingEntity(p_onItemRightClick_2_, p_onItemRightClick_2_.getEntityBoundingBox().addCoord(lvt_26_1_.xCoord * 5.0, lvt_26_1_.yCoord * 5.0, lvt_26_1_.zCoord * 5.0).expandXyz(1.0));
        for (int lvt_29_1_ = 0; lvt_29_1_ < lvt_28_1_.size(); ++lvt_29_1_) {
            AxisAlignedBB lvt_31_1_;
            Entity lvt_30_1_ = lvt_28_1_.get(lvt_29_1_);
            if (!lvt_30_1_.canBeCollidedWith() || !(lvt_31_1_ = lvt_30_1_.getEntityBoundingBox().expandXyz(lvt_30_1_.getCollisionBorderSize())).isVecInside(lvt_14_1_)) continue;
            lvt_27_1_ = true;
        }
        if (lvt_27_1_) {
            return new ActionResult<ItemStack>(EnumActionResult.PASS, lvt_4_1_);
        }
        if (lvt_25_1_.typeOfHit == RayTraceResult.Type.BLOCK) {
            Block lvt_29_2_ = p_onItemRightClick_1_.getBlockState(lvt_25_1_.getBlockPos()).getBlock();
            boolean lvt_30_2_ = lvt_29_2_ == Blocks.WATER || lvt_29_2_ == Blocks.FLOWING_WATER;
            EntityBoat lvt_31_2_ = new EntityBoat(p_onItemRightClick_1_, lvt_25_1_.hitVec.xCoord, lvt_30_2_ ? lvt_25_1_.hitVec.yCoord - 0.12 : lvt_25_1_.hitVec.yCoord, lvt_25_1_.hitVec.zCoord);
            lvt_31_2_.setBoatType(this.type);
            lvt_31_2_.rotationYaw = p_onItemRightClick_2_.rotationYaw;
            if (!p_onItemRightClick_1_.getCollisionBoxes(lvt_31_2_, lvt_31_2_.getEntityBoundingBox().expandXyz(-0.1)).isEmpty()) {
                return new ActionResult<ItemStack>(EnumActionResult.FAIL, lvt_4_1_);
            }
            if (!p_onItemRightClick_1_.isRemote) {
                p_onItemRightClick_1_.spawnEntity(lvt_31_2_);
            }
            if (!p_onItemRightClick_2_.capabilities.isCreativeMode) {
                lvt_4_1_.shrink(1);
            }
            p_onItemRightClick_2_.addStat(StatList.getObjectUseStats(this));
            return new ActionResult<ItemStack>(EnumActionResult.SUCCESS, lvt_4_1_);
        }
        return new ActionResult<ItemStack>(EnumActionResult.PASS, lvt_4_1_);
    }
}

