/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBow
extends Item {
    public ItemBow() {
        this.maxStackSize = 1;
        this.setMaxDamage(384);
        this.setCreativeTab(CreativeTabs.COMBAT);
        this.addPropertyOverride(new ResourceLocation("pull"), new IItemPropertyGetter(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public float apply(ItemStack p_apply_1_, World p_apply_2_, EntityLivingBase p_apply_3_) {
                return p_apply_3_ == null ? 0.0f : (p_apply_3_.getActiveItemStack().getItem() != Items.BOW ? 0.0f : (float)(p_apply_1_.getMaxItemUseDuration() - p_apply_3_.getItemInUseCount()) / 20.0f);
            }
        });
        this.addPropertyOverride(new ResourceLocation("pulling"), new IItemPropertyGetter(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public float apply(ItemStack p_apply_1_, World p_apply_2_, EntityLivingBase p_apply_3_) {
                return p_apply_3_ != null && p_apply_3_.isHandActive() && p_apply_3_.getActiveItemStack() == p_apply_1_ ? 1.0f : 0.0f;
            }
        });
    }

    private ItemStack findAmmo(EntityPlayer p_findAmmo_1_) {
        if (this.isArrow(p_findAmmo_1_.getHeldItem(EnumHand.OFF_HAND))) {
            return p_findAmmo_1_.getHeldItem(EnumHand.OFF_HAND);
        }
        if (this.isArrow(p_findAmmo_1_.getHeldItem(EnumHand.MAIN_HAND))) {
            return p_findAmmo_1_.getHeldItem(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < p_findAmmo_1_.inventory.getSizeInventory(); ++i) {
            ItemStack itemstack = p_findAmmo_1_.inventory.getStackInSlot(i);
            if (!this.isArrow(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.EMPTY;
    }

    protected boolean isArrow(ItemStack p_isArrow_1_) {
        return p_isArrow_1_.getItem() instanceof ItemArrow;
    }

    @Override
    public void onPlayerStoppedUsing(ItemStack p_onPlayerStoppedUsing_1_, World p_onPlayerStoppedUsing_2_, EntityLivingBase p_onPlayerStoppedUsing_3_, int p_onPlayerStoppedUsing_4_) {
        if (p_onPlayerStoppedUsing_3_ instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)p_onPlayerStoppedUsing_3_;
            boolean flag = entityplayer.capabilities.isCreativeMode || EnchantmentHelper.getEnchantmentLevel(Enchantments.INFINITY, p_onPlayerStoppedUsing_1_) > 0;
            ItemStack itemstack = this.findAmmo(entityplayer);
            int i = this.getMaxItemUseDuration(p_onPlayerStoppedUsing_1_) - p_onPlayerStoppedUsing_4_;
            if ((i = ForgeEventFactory.onArrowLoose(p_onPlayerStoppedUsing_1_, p_onPlayerStoppedUsing_2_, entityplayer, i, !itemstack.isEmpty() || flag)) < 0) {
                return;
            }
            if (!itemstack.isEmpty() || flag) {
                float f;
                if (itemstack.isEmpty()) {
                    itemstack = new ItemStack(Items.ARROW);
                }
                if ((double)(f = ItemBow.getArrowVelocity(i)) >= 0.1) {
                    boolean flag1;
                    boolean bl = flag1 = entityplayer.capabilities.isCreativeMode || itemstack.getItem() instanceof ItemArrow && ((ItemArrow)itemstack.getItem()).isInfinite(itemstack, p_onPlayerStoppedUsing_1_, entityplayer);
                    if (!p_onPlayerStoppedUsing_2_.isRemote) {
                        int k;
                        int j;
                        ItemArrow itemarrow = (ItemArrow)(itemstack.getItem() instanceof ItemArrow ? itemstack.getItem() : Items.ARROW);
                        EntityArrow entityarrow = itemarrow.createArrow(p_onPlayerStoppedUsing_2_, itemstack, entityplayer);
                        entityarrow.setAim(entityplayer, entityplayer.rotationPitch, entityplayer.rotationYaw, 0.0f, f * 3.0f, 1.0f);
                        if (f == 1.0f) {
                            entityarrow.setIsCritical(true);
                        }
                        if ((j = EnchantmentHelper.getEnchantmentLevel(Enchantments.POWER, p_onPlayerStoppedUsing_1_)) > 0) {
                            entityarrow.setDamage(entityarrow.getDamage() + (double)j * 0.5 + 0.5);
                        }
                        if ((k = EnchantmentHelper.getEnchantmentLevel(Enchantments.PUNCH, p_onPlayerStoppedUsing_1_)) > 0) {
                            entityarrow.setKnockbackStrength(k);
                        }
                        if (EnchantmentHelper.getEnchantmentLevel(Enchantments.FLAME, p_onPlayerStoppedUsing_1_) > 0) {
                            entityarrow.setFire(100);
                        }
                        p_onPlayerStoppedUsing_1_.damageItem(1, entityplayer);
                        if (flag1 || entityplayer.capabilities.isCreativeMode && (itemstack.getItem() == Items.SPECTRAL_ARROW || itemstack.getItem() == Items.TIPPED_ARROW)) {
                            entityarrow.pickupStatus = EntityArrow.PickupStatus.CREATIVE_ONLY;
                        }
                        p_onPlayerStoppedUsing_2_.spawnEntity(entityarrow);
                    }
                    p_onPlayerStoppedUsing_2_.playSound(null, entityplayer.posX, entityplayer.posY, entityplayer.posZ, SoundEvents.ENTITY_ARROW_SHOOT, SoundCategory.PLAYERS, 1.0f, 1.0f / (itemRand.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                    if (!flag1 && !entityplayer.capabilities.isCreativeMode) {
                        itemstack.shrink(1);
                        if (itemstack.isEmpty()) {
                            entityplayer.inventory.deleteStack(itemstack);
                        }
                    }
                    entityplayer.addStat(StatList.getObjectUseStats(this));
                }
            }
        }
    }

    public static float getArrowVelocity(int p_getArrowVelocity_0_) {
        float f = (float)p_getArrowVelocity_0_ / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    @Override
    public int getMaxItemUseDuration(ItemStack p_getMaxItemUseDuration_1_) {
        return 72000;
    }

    @Override
    public EnumAction getItemUseAction(ItemStack p_getItemUseAction_1_) {
        return EnumAction.BOW;
    }

    @Override
    public ActionResult<ItemStack> onItemRightClick(World p_onItemRightClick_1_, EntityPlayer p_onItemRightClick_2_, EnumHand p_onItemRightClick_3_) {
        boolean flag;
        ItemStack itemstack = p_onItemRightClick_2_.getHeldItem(p_onItemRightClick_3_);
        ActionResult<ItemStack> ret = ForgeEventFactory.onArrowNock(itemstack, p_onItemRightClick_1_, p_onItemRightClick_2_, p_onItemRightClick_3_, flag = !this.findAmmo(p_onItemRightClick_2_).isEmpty());
        if (ret != null) {
            return ret;
        }
        if (!p_onItemRightClick_2_.capabilities.isCreativeMode && !flag) {
            return flag ? new ActionResult<ItemStack>(EnumActionResult.PASS, itemstack) : new ActionResult<ItemStack>(EnumActionResult.FAIL, itemstack);
        }
        p_onItemRightClick_2_.setActiveHand(p_onItemRightClick_3_);
        return new ActionResult<ItemStack>(EnumActionResult.SUCCESS, itemstack);
    }

    @Override
    public int getItemEnchantability() {
        return 1;
    }
}

