/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;

public class ItemBucket
extends Item {
    private final Block containedBlock;

    public ItemBucket(Block p_i45331_1_) {
        this.maxStackSize = 1;
        this.containedBlock = p_i45331_1_;
        this.setCreativeTab(CreativeTabs.MISC);
    }

    @Override
    public ActionResult<ItemStack> onItemRightClick(World p_onItemRightClick_1_, EntityPlayer p_onItemRightClick_2_, EnumHand p_onItemRightClick_3_) {
        BlockPos blockpos1;
        RayTraceResult raytraceresult;
        boolean flag = this.containedBlock == Blocks.AIR;
        ItemStack itemstack = p_onItemRightClick_2_.getHeldItem(p_onItemRightClick_3_);
        ActionResult<ItemStack> ret = ForgeEventFactory.onBucketUse(p_onItemRightClick_2_, p_onItemRightClick_1_, itemstack, raytraceresult = this.rayTrace(p_onItemRightClick_1_, p_onItemRightClick_2_, flag));
        if (ret != null) {
            return ret;
        }
        if (raytraceresult == null) {
            return new ActionResult<ItemStack>(EnumActionResult.PASS, itemstack);
        }
        if (raytraceresult.typeOfHit != RayTraceResult.Type.BLOCK) {
            return new ActionResult<ItemStack>(EnumActionResult.PASS, itemstack);
        }
        BlockPos blockpos = raytraceresult.getBlockPos();
        if (!p_onItemRightClick_1_.isBlockModifiable(p_onItemRightClick_2_, blockpos)) {
            return new ActionResult<ItemStack>(EnumActionResult.FAIL, itemstack);
        }
        if (flag) {
            if (!p_onItemRightClick_2_.canPlayerEdit(blockpos.offset(raytraceresult.sideHit), raytraceresult.sideHit, itemstack)) {
                return new ActionResult<ItemStack>(EnumActionResult.FAIL, itemstack);
            }
            IBlockState iblockstate = p_onItemRightClick_1_.getBlockState(blockpos);
            Material material = iblockstate.getMaterial();
            if (material == Material.WATER && iblockstate.getValue(BlockLiquid.LEVEL) == 0) {
                p_onItemRightClick_1_.setBlockState(blockpos, Blocks.AIR.getDefaultState(), 11);
                p_onItemRightClick_2_.addStat(StatList.getObjectUseStats(this));
                p_onItemRightClick_2_.playSound(SoundEvents.ITEM_BUCKET_FILL, 1.0f, 1.0f);
                return new ActionResult<ItemStack>(EnumActionResult.SUCCESS, this.fillBucket(itemstack, p_onItemRightClick_2_, Items.WATER_BUCKET));
            }
            if (material == Material.LAVA && iblockstate.getValue(BlockLiquid.LEVEL) == 0) {
                p_onItemRightClick_2_.playSound(SoundEvents.ITEM_BUCKET_FILL_LAVA, 1.0f, 1.0f);
                p_onItemRightClick_1_.setBlockState(blockpos, Blocks.AIR.getDefaultState(), 11);
                p_onItemRightClick_2_.addStat(StatList.getObjectUseStats(this));
                return new ActionResult<ItemStack>(EnumActionResult.SUCCESS, this.fillBucket(itemstack, p_onItemRightClick_2_, Items.LAVA_BUCKET));
            }
            return new ActionResult<ItemStack>(EnumActionResult.FAIL, itemstack);
        }
        boolean flag1 = p_onItemRightClick_1_.getBlockState(blockpos).getBlock().isReplaceable(p_onItemRightClick_1_, blockpos);
        BlockPos blockPos = blockpos1 = flag1 && raytraceresult.sideHit == EnumFacing.UP ? blockpos : blockpos.offset(raytraceresult.sideHit);
        if (!p_onItemRightClick_2_.canPlayerEdit(blockpos1, raytraceresult.sideHit, itemstack)) {
            return new ActionResult<ItemStack>(EnumActionResult.FAIL, itemstack);
        }
        if (this.tryPlaceContainedLiquid(p_onItemRightClick_2_, p_onItemRightClick_1_, blockpos1)) {
            p_onItemRightClick_2_.addStat(StatList.getObjectUseStats(this));
            return !p_onItemRightClick_2_.capabilities.isCreativeMode ? new ActionResult<ItemStack>(EnumActionResult.SUCCESS, new ItemStack(Items.BUCKET)) : new ActionResult<ItemStack>(EnumActionResult.SUCCESS, itemstack);
        }
        return new ActionResult<ItemStack>(EnumActionResult.FAIL, itemstack);
    }

    private ItemStack fillBucket(ItemStack p_fillBucket_1_, EntityPlayer p_fillBucket_2_, Item p_fillBucket_3_) {
        if (p_fillBucket_2_.capabilities.isCreativeMode) {
            return p_fillBucket_1_;
        }
        p_fillBucket_1_.shrink(1);
        if (p_fillBucket_1_.isEmpty()) {
            return new ItemStack(p_fillBucket_3_);
        }
        if (!p_fillBucket_2_.inventory.addItemStackToInventory(new ItemStack(p_fillBucket_3_))) {
            p_fillBucket_2_.dropItem(new ItemStack(p_fillBucket_3_), false);
        }
        return p_fillBucket_1_;
    }

    public boolean tryPlaceContainedLiquid(EntityPlayer p_tryPlaceContainedLiquid_1_, World p_tryPlaceContainedLiquid_2_, BlockPos p_tryPlaceContainedLiquid_3_) {
        if (this.containedBlock == Blocks.AIR) {
            return false;
        }
        IBlockState iblockstate = p_tryPlaceContainedLiquid_2_.getBlockState(p_tryPlaceContainedLiquid_3_);
        Material material = iblockstate.getMaterial();
        boolean flag = !material.isSolid();
        boolean flag1 = iblockstate.getBlock().isReplaceable(p_tryPlaceContainedLiquid_2_, p_tryPlaceContainedLiquid_3_);
        if (!(p_tryPlaceContainedLiquid_2_.isAirBlock(p_tryPlaceContainedLiquid_3_) || flag || flag1)) {
            return false;
        }
        if (p_tryPlaceContainedLiquid_2_.provider.doesWaterVaporize() && this.containedBlock == Blocks.FLOWING_WATER) {
            int l = p_tryPlaceContainedLiquid_3_.getX();
            int i = p_tryPlaceContainedLiquid_3_.getY();
            int j = p_tryPlaceContainedLiquid_3_.getZ();
            p_tryPlaceContainedLiquid_2_.playSound(p_tryPlaceContainedLiquid_1_, p_tryPlaceContainedLiquid_3_, SoundEvents.BLOCK_FIRE_EXTINGUISH, SoundCategory.BLOCKS, 0.5f, 2.6f + (p_tryPlaceContainedLiquid_2_.rand.nextFloat() - p_tryPlaceContainedLiquid_2_.rand.nextFloat()) * 0.8f);
            for (int k = 0; k < 8; ++k) {
                p_tryPlaceContainedLiquid_2_.spawnParticle(EnumParticleTypes.SMOKE_LARGE, (double)l + Math.random(), (double)i + Math.random(), (double)j + Math.random(), 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            if (!p_tryPlaceContainedLiquid_2_.isRemote && (flag || flag1) && !material.isLiquid()) {
                p_tryPlaceContainedLiquid_2_.destroyBlock(p_tryPlaceContainedLiquid_3_, true);
            }
            SoundEvent soundevent = this.containedBlock == Blocks.FLOWING_LAVA ? SoundEvents.ITEM_BUCKET_EMPTY_LAVA : SoundEvents.ITEM_BUCKET_EMPTY;
            p_tryPlaceContainedLiquid_2_.playSound(p_tryPlaceContainedLiquid_1_, p_tryPlaceContainedLiquid_3_, soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
            p_tryPlaceContainedLiquid_2_.setBlockState(p_tryPlaceContainedLiquid_3_, this.containedBlock.getDefaultState(), 11);
        }
        return true;
    }

    @Override
    public ICapabilityProvider initCapabilities(ItemStack p_initCapabilities_1_, NBTTagCompound p_initCapabilities_2_) {
        if (this.getClass() == ItemBucket.class) {
            return new FluidBucketWrapper(p_initCapabilities_1_);
        }
        return super.initCapabilities(p_initCapabilities_1_, p_initCapabilities_2_);
    }
}

