/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;

public class ItemBucketMilk
extends Item {
    public ItemBucketMilk() {
        this.setMaxStackSize(1);
        this.setCreativeTab(CreativeTabs.MISC);
    }

    @Override
    public ItemStack onItemUseFinish(ItemStack p_onItemUseFinish_1_, World p_onItemUseFinish_2_, EntityLivingBase p_onItemUseFinish_3_) {
        if (!p_onItemUseFinish_2_.isRemote) {
            p_onItemUseFinish_3_.curePotionEffects(p_onItemUseFinish_1_);
        }
        if (p_onItemUseFinish_3_ instanceof EntityPlayer && !((EntityPlayer)p_onItemUseFinish_3_).capabilities.isCreativeMode) {
            p_onItemUseFinish_1_.shrink(1);
        }
        if (p_onItemUseFinish_3_ instanceof EntityPlayer) {
            ((EntityPlayer)p_onItemUseFinish_3_).addStat(StatList.getObjectUseStats(this));
        }
        return p_onItemUseFinish_1_.isEmpty() ? new ItemStack(Items.BUCKET) : p_onItemUseFinish_1_;
    }

    @Override
    public int getMaxItemUseDuration(ItemStack p_getMaxItemUseDuration_1_) {
        return 32;
    }

    @Override
    public EnumAction getItemUseAction(ItemStack p_getItemUseAction_1_) {
        return EnumAction.DRINK;
    }

    @Override
    public ActionResult<ItemStack> onItemRightClick(World p_onItemRightClick_1_, EntityPlayer p_onItemRightClick_2_, EnumHand p_onItemRightClick_3_) {
        p_onItemRightClick_2_.setActiveHand(p_onItemRightClick_3_);
        return new ActionResult<ItemStack>(EnumActionResult.SUCCESS, p_onItemRightClick_2_.getHeldItem(p_onItemRightClick_3_));
    }

    @Override
    public ICapabilityProvider initCapabilities(ItemStack p_initCapabilities_1_, NBTTagCompound p_initCapabilities_2_) {
        return new FluidBucketWrapper(p_initCapabilities_1_);
    }
}

