/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCarrotOnAStick
extends Item {
    public ItemCarrotOnAStick() {
        this.setCreativeTab(CreativeTabs.TRANSPORTATION);
        this.setMaxStackSize(1);
        this.setMaxDamage(25);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isFull3D() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldRotateAroundWhenRendering() {
        return true;
    }

    @Override
    public ActionResult<ItemStack> onItemRightClick(World p_onItemRightClick_1_, EntityPlayer p_onItemRightClick_2_, EnumHand p_onItemRightClick_3_) {
        ItemStack lvt_4_1_ = p_onItemRightClick_2_.getHeldItem(p_onItemRightClick_3_);
        if (p_onItemRightClick_1_.isRemote) {
            return new ActionResult<ItemStack>(EnumActionResult.PASS, lvt_4_1_);
        }
        if (p_onItemRightClick_2_.isRiding() && p_onItemRightClick_2_.getRidingEntity() instanceof EntityPig) {
            EntityPig lvt_5_1_ = (EntityPig)p_onItemRightClick_2_.getRidingEntity();
            if (lvt_4_1_.getMaxDamage() - lvt_4_1_.getMetadata() >= 7 && lvt_5_1_.boost()) {
                lvt_4_1_.damageItem(7, p_onItemRightClick_2_);
                if (lvt_4_1_.isEmpty()) {
                    ItemStack lvt_6_1_ = new ItemStack(Items.FISHING_ROD);
                    lvt_6_1_.setTagCompound(lvt_4_1_.getTagCompound());
                    return new ActionResult<ItemStack>(EnumActionResult.SUCCESS, lvt_6_1_);
                }
                return new ActionResult<ItemStack>(EnumActionResult.SUCCESS, lvt_4_1_);
            }
        }
        p_onItemRightClick_2_.addStat(StatList.getObjectUseStats(this));
        return new ActionResult<ItemStack>(EnumActionResult.PASS, lvt_4_1_);
    }
}

