/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemClock
extends Item {
    public ItemClock() {
        this.addPropertyOverride(new ResourceLocation("time"), new IItemPropertyGetter(){
            @SideOnly(value=Side.CLIENT)
            double rotation;
            @SideOnly(value=Side.CLIENT)
            double rota;
            @SideOnly(value=Side.CLIENT)
            long lastUpdateTick;

            @Override
            @SideOnly(value=Side.CLIENT)
            public float apply(ItemStack p_apply_1_, World p_apply_2_, EntityLivingBase p_apply_3_) {
                double lvt_6_2_;
                Entity lvt_5_1_;
                boolean lvt_4_1_ = p_apply_3_ != null;
                Entity entity = lvt_5_1_ = lvt_4_1_ ? p_apply_3_ : p_apply_1_.getItemFrame();
                if (p_apply_2_ == null && lvt_5_1_ != null) {
                    p_apply_2_ = lvt_5_1_.world;
                }
                if (p_apply_2_ == null) {
                    return 0.0f;
                }
                if (p_apply_2_.provider.isSurfaceWorld()) {
                    double lvt_6_1_ = p_apply_2_.getCelestialAngle(1.0f);
                } else {
                    lvt_6_2_ = Math.random();
                }
                lvt_6_2_ = this.wobble(p_apply_2_, lvt_6_2_);
                return (float)lvt_6_2_;
            }

            @SideOnly(value=Side.CLIENT)
            private double wobble(World p_wobble_1_, double p_wobble_2_) {
                if (p_wobble_1_.getTotalWorldTime() != this.lastUpdateTick) {
                    this.lastUpdateTick = p_wobble_1_.getTotalWorldTime();
                    double lvt_4_1_ = p_wobble_2_ - this.rotation;
                    lvt_4_1_ = MathHelper.positiveModulo(lvt_4_1_ + 0.5, 1.0) - 0.5;
                    this.rota += lvt_4_1_ * 0.1;
                    this.rota *= 0.9;
                    this.rotation = MathHelper.positiveModulo(this.rotation + this.rota, 1.0);
                }
                return this.rotation;
            }
        });
    }
}

