/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCompass
extends Item {
    public ItemCompass() {
        this.addPropertyOverride(new ResourceLocation("angle"), new IItemPropertyGetter(){
            @SideOnly(value=Side.CLIENT)
            double rotation;
            @SideOnly(value=Side.CLIENT)
            double rota;
            @SideOnly(value=Side.CLIENT)
            long lastUpdateTick;

            @Override
            @SideOnly(value=Side.CLIENT)
            public float apply(ItemStack p_apply_1_, World p_apply_2_, EntityLivingBase p_apply_3_) {
                double lvt_6_2_;
                Entity lvt_5_1_;
                if (p_apply_3_ == null && !p_apply_1_.isOnItemFrame()) {
                    return 0.0f;
                }
                boolean lvt_4_1_ = p_apply_3_ != null;
                Entity entity = lvt_5_1_ = lvt_4_1_ ? p_apply_3_ : p_apply_1_.getItemFrame();
                if (p_apply_2_ == null) {
                    p_apply_2_ = lvt_5_1_.world;
                }
                if (p_apply_2_.provider.isSurfaceWorld()) {
                    double lvt_8_1_ = lvt_4_1_ ? (double)lvt_5_1_.rotationYaw : this.getFrameRotation((EntityItemFrame)lvt_5_1_);
                    lvt_8_1_ = MathHelper.positiveModulo(lvt_8_1_ / 360.0, 1.0);
                    double lvt_10_1_ = this.getSpawnToAngle(p_apply_2_, lvt_5_1_) / 6.2831854820251465;
                    double lvt_6_1_ = 0.5 - (lvt_8_1_ - 0.25 - lvt_10_1_);
                } else {
                    lvt_6_2_ = Math.random();
                }
                if (lvt_4_1_) {
                    lvt_6_2_ = this.wobble(p_apply_2_, lvt_6_2_);
                }
                return MathHelper.positiveModulo((float)lvt_6_2_, 1.0f);
            }

            @SideOnly(value=Side.CLIENT)
            private double wobble(World p_wobble_1_, double p_wobble_2_) {
                if (p_wobble_1_.getTotalWorldTime() != this.lastUpdateTick) {
                    this.lastUpdateTick = p_wobble_1_.getTotalWorldTime();
                    double lvt_4_1_ = p_wobble_2_ - this.rotation;
                    lvt_4_1_ = MathHelper.positiveModulo(lvt_4_1_ + 0.5, 1.0) - 0.5;
                    this.rota += lvt_4_1_ * 0.1;
                    this.rota *= 0.8;
                    this.rotation = MathHelper.positiveModulo(this.rotation + this.rota, 1.0);
                }
                return this.rotation;
            }

            @SideOnly(value=Side.CLIENT)
            private double getFrameRotation(EntityItemFrame p_getFrameRotation_1_) {
                return MathHelper.clampAngle(180 + p_getFrameRotation_1_.facingDirection.getHorizontalIndex() * 90);
            }

            @SideOnly(value=Side.CLIENT)
            private double getSpawnToAngle(World p_getSpawnToAngle_1_, Entity p_getSpawnToAngle_2_) {
                BlockPos lvt_3_1_ = p_getSpawnToAngle_1_.getSpawnPoint();
                return Math.atan2((double)lvt_3_1_.getZ() - p_getSpawnToAngle_2_.posZ, (double)lvt_3_1_.getX() - p_getSpawnToAngle_2_.posX);
            }
        });
    }
}

