/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemDoor
extends Item {
    private final Block block;

    public ItemDoor(Block p_i45788_1_) {
        this.block = p_i45788_1_;
        this.setCreativeTab(CreativeTabs.REDSTONE);
    }

    @Override
    public EnumActionResult onItemUse(EntityPlayer p_onItemUse_1_, World p_onItemUse_2_, BlockPos p_onItemUse_3_, EnumHand p_onItemUse_4_, EnumFacing p_onItemUse_5_, float p_onItemUse_6_, float p_onItemUse_7_, float p_onItemUse_8_) {
        ItemStack itemstack;
        if (p_onItemUse_5_ != EnumFacing.UP) {
            return EnumActionResult.FAIL;
        }
        IBlockState iblockstate = p_onItemUse_2_.getBlockState(p_onItemUse_3_);
        Block block = iblockstate.getBlock();
        if (!block.isReplaceable(p_onItemUse_2_, p_onItemUse_3_)) {
            p_onItemUse_3_ = p_onItemUse_3_.offset(p_onItemUse_5_);
        }
        if (p_onItemUse_1_.canPlayerEdit(p_onItemUse_3_, p_onItemUse_5_, itemstack = p_onItemUse_1_.getHeldItem(p_onItemUse_4_)) && this.block.canPlaceBlockAt(p_onItemUse_2_, p_onItemUse_3_)) {
            EnumFacing enumfacing = EnumFacing.fromAngle(p_onItemUse_1_.rotationYaw);
            int i = enumfacing.getFrontOffsetX();
            int j = enumfacing.getFrontOffsetZ();
            boolean flag = i < 0 && p_onItemUse_8_ < 0.5f || i > 0 && p_onItemUse_8_ > 0.5f || j < 0 && p_onItemUse_6_ > 0.5f || j > 0 && p_onItemUse_6_ < 0.5f;
            ItemDoor.placeDoor(p_onItemUse_2_, p_onItemUse_3_, enumfacing, this.block, flag);
            SoundType soundtype = p_onItemUse_2_.getBlockState(p_onItemUse_3_).getBlock().getSoundType(p_onItemUse_2_.getBlockState(p_onItemUse_3_), p_onItemUse_2_, p_onItemUse_3_, p_onItemUse_1_);
            p_onItemUse_2_.playSound(p_onItemUse_1_, p_onItemUse_3_, soundtype.getPlaceSound(), SoundCategory.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
            itemstack.shrink(1);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public static void placeDoor(World p_placeDoor_0_, BlockPos p_placeDoor_1_, EnumFacing p_placeDoor_2_, Block p_placeDoor_3_, boolean p_placeDoor_4_) {
        boolean flag1;
        BlockPos blockpos = p_placeDoor_1_.offset(p_placeDoor_2_.rotateY());
        BlockPos blockpos1 = p_placeDoor_1_.offset(p_placeDoor_2_.rotateYCCW());
        int i = (p_placeDoor_0_.getBlockState(blockpos1).isNormalCube() ? 1 : 0) + (p_placeDoor_0_.getBlockState(blockpos1.up()).isNormalCube() ? 1 : 0);
        int j = (p_placeDoor_0_.getBlockState(blockpos).isNormalCube() ? 1 : 0) + (p_placeDoor_0_.getBlockState(blockpos.up()).isNormalCube() ? 1 : 0);
        boolean flag = p_placeDoor_0_.getBlockState(blockpos1).getBlock() == p_placeDoor_3_ || p_placeDoor_0_.getBlockState(blockpos1.up()).getBlock() == p_placeDoor_3_;
        boolean bl = flag1 = p_placeDoor_0_.getBlockState(blockpos).getBlock() == p_placeDoor_3_ || p_placeDoor_0_.getBlockState(blockpos.up()).getBlock() == p_placeDoor_3_;
        if ((!flag || flag1) && j <= i) {
            if (flag1 && !flag || j < i) {
                p_placeDoor_4_ = false;
            }
        } else {
            p_placeDoor_4_ = true;
        }
        BlockPos blockpos2 = p_placeDoor_1_.up();
        boolean flag2 = p_placeDoor_0_.isBlockPowered(p_placeDoor_1_) || p_placeDoor_0_.isBlockPowered(blockpos2);
        IBlockState iblockstate = p_placeDoor_3_.getDefaultState().withProperty(BlockDoor.FACING, p_placeDoor_2_).withProperty(BlockDoor.HINGE, p_placeDoor_4_ ? BlockDoor.EnumHingePosition.RIGHT : BlockDoor.EnumHingePosition.LEFT).withProperty(BlockDoor.POWERED, flag2).withProperty(BlockDoor.OPEN, flag2);
        p_placeDoor_0_.setBlockState(p_placeDoor_1_, iblockstate.withProperty(BlockDoor.HALF, BlockDoor.EnumDoorHalf.LOWER), 2);
        p_placeDoor_0_.setBlockState(blockpos2, iblockstate.withProperty(BlockDoor.HALF, BlockDoor.EnumDoorHalf.UPPER), 2);
        p_placeDoor_0_.notifyNeighborsOfStateChange(p_placeDoor_1_, p_placeDoor_3_, false);
        p_placeDoor_0_.notifyNeighborsOfStateChange(blockpos2, p_placeDoor_3_, false);
    }
}

