/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import net.minecraft.block.Block;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemDye
extends Item {
    public static final int[] DYE_COLORS = new int[]{0x1E1B1B, 11743532, 3887386, 5320730, 2437522, 8073150, 2651799, 0xABABAB, 0x434343, 14188952, 4312372, 14602026, 6719955, 12801229, 15435844, 0xF0F0F0};

    public ItemDye() {
        this.setHasSubtypes(true);
        this.setMaxDamage(0);
        this.setCreativeTab(CreativeTabs.MATERIALS);
    }

    @Override
    public String getUnlocalizedName(ItemStack p_getUnlocalizedName_1_) {
        int i = p_getUnlocalizedName_1_.getMetadata();
        return super.getUnlocalizedName() + "." + EnumDyeColor.byDyeDamage(i).getUnlocalizedName();
    }

    @Override
    public EnumActionResult onItemUse(EntityPlayer p_onItemUse_1_, World p_onItemUse_2_, BlockPos p_onItemUse_3_, EnumHand p_onItemUse_4_, EnumFacing p_onItemUse_5_, float p_onItemUse_6_, float p_onItemUse_7_, float p_onItemUse_8_) {
        ItemStack itemstack = p_onItemUse_1_.getHeldItem(p_onItemUse_4_);
        if (!p_onItemUse_1_.canPlayerEdit(p_onItemUse_3_.offset(p_onItemUse_5_), p_onItemUse_5_, itemstack)) {
            return EnumActionResult.FAIL;
        }
        EnumDyeColor enumdyecolor = EnumDyeColor.byDyeDamage(itemstack.getMetadata());
        if (enumdyecolor == EnumDyeColor.WHITE) {
            if (ItemDye.applyBonemeal(itemstack, p_onItemUse_2_, p_onItemUse_3_, p_onItemUse_1_)) {
                if (!p_onItemUse_2_.isRemote) {
                    p_onItemUse_2_.playEvent(2005, p_onItemUse_3_, 0);
                }
                return EnumActionResult.SUCCESS;
            }
        } else if (enumdyecolor == EnumDyeColor.BROWN) {
            IBlockState iblockstate = p_onItemUse_2_.getBlockState(p_onItemUse_3_);
            Block block = iblockstate.getBlock();
            if (block == Blocks.LOG && iblockstate.getValue(BlockOldLog.VARIANT) == BlockPlanks.EnumType.JUNGLE) {
                if (p_onItemUse_5_ == EnumFacing.DOWN || p_onItemUse_5_ == EnumFacing.UP) {
                    return EnumActionResult.FAIL;
                }
                if (p_onItemUse_2_.isAirBlock(p_onItemUse_3_ = p_onItemUse_3_.offset(p_onItemUse_5_))) {
                    IBlockState iblockstate1 = Blocks.COCOA.getStateForPlacement(p_onItemUse_2_, p_onItemUse_3_, p_onItemUse_5_, p_onItemUse_6_, p_onItemUse_7_, p_onItemUse_8_, 0, p_onItemUse_1_, p_onItemUse_4_);
                    p_onItemUse_2_.setBlockState(p_onItemUse_3_, iblockstate1, 10);
                    if (!p_onItemUse_1_.capabilities.isCreativeMode) {
                        itemstack.shrink(1);
                    }
                    return EnumActionResult.SUCCESS;
                }
            }
            return EnumActionResult.FAIL;
        }
        return EnumActionResult.PASS;
    }

    public static boolean applyBonemeal(ItemStack p_applyBonemeal_0_, World p_applyBonemeal_1_, BlockPos p_applyBonemeal_2_) {
        if (p_applyBonemeal_1_ instanceof WorldServer) {
            return ItemDye.applyBonemeal(p_applyBonemeal_0_, p_applyBonemeal_1_, p_applyBonemeal_2_, FakePlayerFactory.getMinecraft((WorldServer)p_applyBonemeal_1_));
        }
        return false;
    }

    public static boolean applyBonemeal(ItemStack p_applyBonemeal_0_, World p_applyBonemeal_1_, BlockPos p_applyBonemeal_2_, EntityPlayer p_applyBonemeal_3_) {
        IGrowable igrowable;
        IBlockState iblockstate = p_applyBonemeal_1_.getBlockState(p_applyBonemeal_2_);
        int hook = ForgeEventFactory.onApplyBonemeal(p_applyBonemeal_3_, p_applyBonemeal_1_, p_applyBonemeal_2_, iblockstate, p_applyBonemeal_0_);
        if (hook != 0) {
            return hook > 0;
        }
        if (iblockstate.getBlock() instanceof IGrowable && (igrowable = (IGrowable)((Object)iblockstate.getBlock())).canGrow(p_applyBonemeal_1_, p_applyBonemeal_2_, iblockstate, p_applyBonemeal_1_.isRemote)) {
            if (!p_applyBonemeal_1_.isRemote) {
                if (igrowable.canUseBonemeal(p_applyBonemeal_1_, p_applyBonemeal_1_.rand, p_applyBonemeal_2_, iblockstate)) {
                    igrowable.grow(p_applyBonemeal_1_, p_applyBonemeal_1_.rand, p_applyBonemeal_2_, iblockstate);
                }
                p_applyBonemeal_0_.shrink(1);
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static void spawnBonemealParticles(World p_spawnBonemealParticles_0_, BlockPos p_spawnBonemealParticles_1_, int p_spawnBonemealParticles_2_) {
        IBlockState iblockstate;
        if (p_spawnBonemealParticles_2_ == 0) {
            p_spawnBonemealParticles_2_ = 15;
        }
        if ((iblockstate = p_spawnBonemealParticles_0_.getBlockState(p_spawnBonemealParticles_1_)).getMaterial() != Material.AIR) {
            for (int i = 0; i < p_spawnBonemealParticles_2_; ++i) {
                double d0 = itemRand.nextGaussian() * 0.02;
                double d1 = itemRand.nextGaussian() * 0.02;
                double d2 = itemRand.nextGaussian() * 0.02;
                p_spawnBonemealParticles_0_.spawnParticle(EnumParticleTypes.VILLAGER_HAPPY, (float)p_spawnBonemealParticles_1_.getX() + itemRand.nextFloat(), (double)p_spawnBonemealParticles_1_.getY() + (double)itemRand.nextFloat() * iblockstate.getBoundingBox((IBlockAccess)p_spawnBonemealParticles_0_, (BlockPos)p_spawnBonemealParticles_1_).maxY, (double)((float)p_spawnBonemealParticles_1_.getZ() + itemRand.nextFloat()), d0, d1, d2, new int[0]);
            }
        } else {
            for (int i1 = 0; i1 < p_spawnBonemealParticles_2_; ++i1) {
                double d0 = itemRand.nextGaussian() * 0.02;
                double d1 = itemRand.nextGaussian() * 0.02;
                double d2 = itemRand.nextGaussian() * 0.02;
                p_spawnBonemealParticles_0_.spawnParticle(EnumParticleTypes.VILLAGER_HAPPY, (float)p_spawnBonemealParticles_1_.getX() + itemRand.nextFloat(), (double)p_spawnBonemealParticles_1_.getY() + (double)itemRand.nextFloat() * 1.0, (double)((float)p_spawnBonemealParticles_1_.getZ() + itemRand.nextFloat()), d0, d1, d2, new int[0]);
            }
        }
    }

    @Override
    public boolean itemInteractionForEntity(ItemStack p_itemInteractionForEntity_1_, EntityPlayer p_itemInteractionForEntity_2_, EntityLivingBase p_itemInteractionForEntity_3_, EnumHand p_itemInteractionForEntity_4_) {
        if (p_itemInteractionForEntity_3_ instanceof EntitySheep) {
            EntitySheep entitysheep = (EntitySheep)p_itemInteractionForEntity_3_;
            EnumDyeColor enumdyecolor = EnumDyeColor.byDyeDamage(p_itemInteractionForEntity_1_.getMetadata());
            if (!entitysheep.getSheared() && entitysheep.getFleeceColor() != enumdyecolor) {
                entitysheep.setFleeceColor(enumdyecolor);
                p_itemInteractionForEntity_1_.shrink(1);
            }
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item p_getSubItems_1_, CreativeTabs p_getSubItems_2_, NonNullList<ItemStack> p_getSubItems_3_) {
        for (int i = 0; i < 16; ++i) {
            p_getSubItems_3_.add(new ItemStack(p_getSubItems_1_, 1, i));
        }
    }
}

