/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import net.minecraft.block.BlockDispenser;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemElytra
extends Item {
    public ItemElytra() {
        this.maxStackSize = 1;
        this.setMaxDamage(432);
        this.setCreativeTab(CreativeTabs.TRANSPORTATION);
        this.addPropertyOverride(new ResourceLocation("broken"), new IItemPropertyGetter(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public float apply(ItemStack p_apply_1_, World p_apply_2_, EntityLivingBase p_apply_3_) {
                return ItemElytra.isBroken(p_apply_1_) ? 0.0f : 1.0f;
            }
        });
        BlockDispenser.DISPENSE_BEHAVIOR_REGISTRY.putObject(this, ItemArmor.DISPENSER_BEHAVIOR);
    }

    public static boolean isBroken(ItemStack p_isBroken_0_) {
        return p_isBroken_0_.getItemDamage() < p_isBroken_0_.getMaxDamage() - 1;
    }

    @Override
    public boolean getIsRepairable(ItemStack p_getIsRepairable_1_, ItemStack p_getIsRepairable_2_) {
        return p_getIsRepairable_2_.getItem() == Items.LEATHER;
    }

    @Override
    public ActionResult<ItemStack> onItemRightClick(World p_onItemRightClick_1_, EntityPlayer p_onItemRightClick_2_, EnumHand p_onItemRightClick_3_) {
        ItemStack lvt_4_1_ = p_onItemRightClick_2_.getHeldItem(p_onItemRightClick_3_);
        EntityEquipmentSlot lvt_5_1_ = EntityLiving.getSlotForItemStack(lvt_4_1_);
        ItemStack lvt_6_1_ = p_onItemRightClick_2_.getItemStackFromSlot(lvt_5_1_);
        if (lvt_6_1_.isEmpty()) {
            p_onItemRightClick_2_.setItemStackToSlot(lvt_5_1_, lvt_4_1_.copy());
            lvt_4_1_.setCount(0);
            return new ActionResult<ItemStack>(EnumActionResult.SUCCESS, lvt_4_1_);
        }
        return new ActionResult<ItemStack>(EnumActionResult.FAIL, lvt_4_1_);
    }
}

