/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemEnchantedBook
extends Item {
    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack p_hasEffect_1_) {
        return true;
    }

    @Override
    public boolean isEnchantable(ItemStack p_isEnchantable_1_) {
        return false;
    }

    @Override
    public EnumRarity getRarity(ItemStack p_getRarity_1_) {
        if (this.getEnchantments(p_getRarity_1_).hasNoTags()) {
            return super.getRarity(p_getRarity_1_);
        }
        return EnumRarity.UNCOMMON;
    }

    public NBTTagList getEnchantments(ItemStack p_getEnchantments_1_) {
        NBTTagCompound lvt_2_1_ = p_getEnchantments_1_.getTagCompound();
        if (lvt_2_1_ == null || !lvt_2_1_.hasKey("StoredEnchantments", 9)) {
            return new NBTTagList();
        }
        return (NBTTagList)lvt_2_1_.getTag("StoredEnchantments");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack p_addInformation_1_, EntityPlayer p_addInformation_2_, List<String> p_addInformation_3_, boolean p_addInformation_4_) {
        super.addInformation(p_addInformation_1_, p_addInformation_2_, p_addInformation_3_, p_addInformation_4_);
        NBTTagList lvt_5_1_ = this.getEnchantments(p_addInformation_1_);
        if (lvt_5_1_ != null) {
            for (int lvt_6_1_ = 0; lvt_6_1_ < lvt_5_1_.tagCount(); ++lvt_6_1_) {
                short lvt_7_1_ = lvt_5_1_.getCompoundTagAt(lvt_6_1_).getShort("id");
                short lvt_8_1_ = lvt_5_1_.getCompoundTagAt(lvt_6_1_).getShort("lvl");
                if (Enchantment.getEnchantmentByID(lvt_7_1_) == null) continue;
                p_addInformation_3_.add(Enchantment.getEnchantmentByID(lvt_7_1_).getTranslatedName(lvt_8_1_));
            }
        }
    }

    public void addEnchantment(ItemStack p_addEnchantment_1_, EnchantmentData p_addEnchantment_2_) {
        NBTTagList lvt_3_1_ = this.getEnchantments(p_addEnchantment_1_);
        boolean lvt_4_1_ = true;
        for (int lvt_5_1_ = 0; lvt_5_1_ < lvt_3_1_.tagCount(); ++lvt_5_1_) {
            NBTTagCompound lvt_6_1_ = lvt_3_1_.getCompoundTagAt(lvt_5_1_);
            if (Enchantment.getEnchantmentByID(lvt_6_1_.getShort("id")) != p_addEnchantment_2_.enchantmentobj) continue;
            if (lvt_6_1_.getShort("lvl") < p_addEnchantment_2_.enchantmentLevel) {
                lvt_6_1_.setShort("lvl", (short)p_addEnchantment_2_.enchantmentLevel);
            }
            lvt_4_1_ = false;
            break;
        }
        if (lvt_4_1_) {
            NBTTagCompound lvt_5_2_ = new NBTTagCompound();
            lvt_5_2_.setShort("id", (short)Enchantment.getEnchantmentID(p_addEnchantment_2_.enchantmentobj));
            lvt_5_2_.setShort("lvl", (short)p_addEnchantment_2_.enchantmentLevel);
            lvt_3_1_.appendTag(lvt_5_2_);
        }
        if (!p_addEnchantment_1_.hasTagCompound()) {
            p_addEnchantment_1_.setTagCompound(new NBTTagCompound());
        }
        p_addEnchantment_1_.getTagCompound().setTag("StoredEnchantments", lvt_3_1_);
    }

    public ItemStack getEnchantedItemStack(EnchantmentData p_getEnchantedItemStack_1_) {
        ItemStack lvt_2_1_ = new ItemStack(this);
        this.addEnchantment(lvt_2_1_, p_getEnchantedItemStack_1_);
        return lvt_2_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public void getAll(Enchantment p_getAll_1_, List<ItemStack> p_getAll_2_) {
        for (int lvt_3_1_ = p_getAll_1_.getMinLevel(); lvt_3_1_ <= p_getAll_1_.getMaxLevel(); ++lvt_3_1_) {
            p_getAll_2_.add(this.getEnchantedItemStack(new EnchantmentData(p_getAll_1_, lvt_3_1_)));
        }
    }
}

