/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import net.minecraft.block.BlockEndPortalFrame;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.item.EntityEnderEye;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class ItemEnderEye
extends Item {
    public ItemEnderEye() {
        this.setCreativeTab(CreativeTabs.MISC);
    }

    @Override
    public EnumActionResult onItemUse(EntityPlayer p_onItemUse_1_, World p_onItemUse_2_, BlockPos p_onItemUse_3_, EnumHand p_onItemUse_4_, EnumFacing p_onItemUse_5_, float p_onItemUse_6_, float p_onItemUse_7_, float p_onItemUse_8_) {
        IBlockState lvt_9_1_ = p_onItemUse_2_.getBlockState(p_onItemUse_3_);
        ItemStack lvt_10_1_ = p_onItemUse_1_.getHeldItem(p_onItemUse_4_);
        if (!p_onItemUse_1_.canPlayerEdit(p_onItemUse_3_.offset(p_onItemUse_5_), p_onItemUse_5_, lvt_10_1_) || lvt_9_1_.getBlock() != Blocks.END_PORTAL_FRAME || lvt_9_1_.getValue(BlockEndPortalFrame.EYE).booleanValue()) {
            return EnumActionResult.FAIL;
        }
        if (p_onItemUse_2_.isRemote) {
            return EnumActionResult.SUCCESS;
        }
        p_onItemUse_2_.setBlockState(p_onItemUse_3_, lvt_9_1_.withProperty(BlockEndPortalFrame.EYE, true), 2);
        p_onItemUse_2_.updateComparatorOutputLevel(p_onItemUse_3_, Blocks.END_PORTAL_FRAME);
        lvt_10_1_.shrink(1);
        for (int lvt_11_1_ = 0; lvt_11_1_ < 16; ++lvt_11_1_) {
            double lvt_12_1_ = (float)p_onItemUse_3_.getX() + (5.0f + itemRand.nextFloat() * 6.0f) / 16.0f;
            double lvt_14_1_ = (float)p_onItemUse_3_.getY() + 0.8125f;
            double lvt_16_1_ = (float)p_onItemUse_3_.getZ() + (5.0f + itemRand.nextFloat() * 6.0f) / 16.0f;
            double lvt_18_1_ = 0.0;
            double lvt_20_1_ = 0.0;
            double lvt_22_1_ = 0.0;
            p_onItemUse_2_.spawnParticle(EnumParticleTypes.SMOKE_NORMAL, lvt_12_1_, lvt_14_1_, lvt_16_1_, 0.0, 0.0, 0.0, new int[0]);
        }
        BlockPattern.PatternHelper lvt_11_2_ = BlockEndPortalFrame.getOrCreatePortalShape().match(p_onItemUse_2_, p_onItemUse_3_);
        if (lvt_11_2_ != null) {
            BlockPos lvt_12_2_ = lvt_11_2_.getFrontTopLeft().add(-3, 0, -3);
            for (int lvt_13_1_ = 0; lvt_13_1_ < 3; ++lvt_13_1_) {
                for (int lvt_14_2_ = 0; lvt_14_2_ < 3; ++lvt_14_2_) {
                    p_onItemUse_2_.setBlockState(lvt_12_2_.add(lvt_13_1_, 0, lvt_14_2_), Blocks.END_PORTAL.getDefaultState(), 2);
                }
            }
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public ActionResult<ItemStack> onItemRightClick(World p_onItemRightClick_1_, EntityPlayer p_onItemRightClick_2_, EnumHand p_onItemRightClick_3_) {
        BlockPos lvt_6_1_;
        ItemStack lvt_4_1_ = p_onItemRightClick_2_.getHeldItem(p_onItemRightClick_3_);
        RayTraceResult lvt_5_1_ = this.rayTrace(p_onItemRightClick_1_, p_onItemRightClick_2_, false);
        if (lvt_5_1_ != null && lvt_5_1_.typeOfHit == RayTraceResult.Type.BLOCK && p_onItemRightClick_1_.getBlockState(lvt_5_1_.getBlockPos()).getBlock() == Blocks.END_PORTAL_FRAME) {
            return new ActionResult<ItemStack>(EnumActionResult.PASS, lvt_4_1_);
        }
        p_onItemRightClick_2_.setActiveHand(p_onItemRightClick_3_);
        if (!p_onItemRightClick_1_.isRemote && (lvt_6_1_ = ((WorldServer)p_onItemRightClick_1_).getChunkProvider().getStrongholdGen(p_onItemRightClick_1_, "Stronghold", new BlockPos(p_onItemRightClick_2_), false)) != null) {
            EntityEnderEye lvt_7_1_ = new EntityEnderEye(p_onItemRightClick_1_, p_onItemRightClick_2_.posX, p_onItemRightClick_2_.posY + (double)(p_onItemRightClick_2_.height / 2.0f), p_onItemRightClick_2_.posZ);
            lvt_7_1_.moveTowards(lvt_6_1_);
            p_onItemRightClick_1_.spawnEntity(lvt_7_1_);
            p_onItemRightClick_1_.playSound(null, p_onItemRightClick_2_.posX, p_onItemRightClick_2_.posY, p_onItemRightClick_2_.posZ, SoundEvents.ENTITY_ENDEREYE_LAUNCH, SoundCategory.NEUTRAL, 0.5f, 0.4f / (itemRand.nextFloat() * 0.4f + 0.8f));
            p_onItemRightClick_1_.playEvent(null, 1003, new BlockPos(p_onItemRightClick_2_), 0);
            if (!p_onItemRightClick_2_.capabilities.isCreativeMode) {
                lvt_4_1_.shrink(1);
            }
            p_onItemRightClick_2_.addStat(StatList.getObjectUseStats(this));
            return new ActionResult<ItemStack>(EnumActionResult.SUCCESS, lvt_4_1_);
        }
        return new ActionResult<ItemStack>(EnumActionResult.SUCCESS, lvt_4_1_);
    }
}

