/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFireworkCharge;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFirework
extends Item {
    @Override
    public EnumActionResult onItemUse(EntityPlayer p_onItemUse_1_, World p_onItemUse_2_, BlockPos p_onItemUse_3_, EnumHand p_onItemUse_4_, EnumFacing p_onItemUse_5_, float p_onItemUse_6_, float p_onItemUse_7_, float p_onItemUse_8_) {
        if (!p_onItemUse_2_.isRemote) {
            ItemStack lvt_9_1_ = p_onItemUse_1_.getHeldItem(p_onItemUse_4_);
            EntityFireworkRocket lvt_10_1_ = new EntityFireworkRocket(p_onItemUse_2_, (float)p_onItemUse_3_.getX() + p_onItemUse_6_, (float)p_onItemUse_3_.getY() + p_onItemUse_7_, (float)p_onItemUse_3_.getZ() + p_onItemUse_8_, lvt_9_1_);
            p_onItemUse_2_.spawnEntity(lvt_10_1_);
            if (!p_onItemUse_1_.capabilities.isCreativeMode) {
                lvt_9_1_.shrink(1);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public ActionResult<ItemStack> onItemRightClick(World p_onItemRightClick_1_, EntityPlayer p_onItemRightClick_2_, EnumHand p_onItemRightClick_3_) {
        if (p_onItemRightClick_2_.isElytraFlying()) {
            ItemStack lvt_4_1_ = p_onItemRightClick_2_.getHeldItem(p_onItemRightClick_3_);
            if (!p_onItemRightClick_1_.isRemote) {
                EntityFireworkRocket lvt_5_1_ = new EntityFireworkRocket(p_onItemRightClick_1_, lvt_4_1_, p_onItemRightClick_2_);
                p_onItemRightClick_1_.spawnEntity(lvt_5_1_);
                if (!p_onItemRightClick_2_.capabilities.isCreativeMode) {
                    lvt_4_1_.shrink(1);
                }
            }
            return new ActionResult<ItemStack>(EnumActionResult.SUCCESS, p_onItemRightClick_2_.getHeldItem(p_onItemRightClick_3_));
        }
        return new ActionResult<ItemStack>(EnumActionResult.PASS, p_onItemRightClick_2_.getHeldItem(p_onItemRightClick_3_));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack p_addInformation_1_, EntityPlayer p_addInformation_2_, List<String> p_addInformation_3_, boolean p_addInformation_4_) {
        NBTTagList lvt_6_1_;
        NBTTagCompound lvt_5_1_ = p_addInformation_1_.getSubCompound("Fireworks");
        if (lvt_5_1_ == null) {
            return;
        }
        if (lvt_5_1_.hasKey("Flight", 99)) {
            p_addInformation_3_.add(I18n.translateToLocal("item.fireworks.flight") + " " + lvt_5_1_.getByte("Flight"));
        }
        if (!(lvt_6_1_ = lvt_5_1_.getTagList("Explosions", 10)).hasNoTags()) {
            for (int lvt_7_1_ = 0; lvt_7_1_ < lvt_6_1_.tagCount(); ++lvt_7_1_) {
                NBTTagCompound lvt_8_1_ = lvt_6_1_.getCompoundTagAt(lvt_7_1_);
                ArrayList lvt_9_1_ = Lists.newArrayList();
                ItemFireworkCharge.addExplosionInfo(lvt_8_1_, lvt_9_1_);
                if (lvt_9_1_.isEmpty()) continue;
                for (int lvt_10_1_ = 1; lvt_10_1_ < lvt_9_1_.size(); ++lvt_10_1_) {
                    lvt_9_1_.set(lvt_10_1_, "  " + (String)lvt_9_1_.get(lvt_10_1_));
                }
                p_addInformation_3_.addAll(lvt_9_1_);
            }
        }
    }
}

