/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFishFood
extends ItemFood {
    private final boolean cooked;

    public ItemFishFood(boolean p_i45338_1_) {
        super(0, 0.0f, false);
        this.cooked = p_i45338_1_;
    }

    @Override
    public int getHealAmount(ItemStack p_getHealAmount_1_) {
        FishType lvt_2_1_ = FishType.byItemStack(p_getHealAmount_1_);
        if (this.cooked && lvt_2_1_.canCook()) {
            return lvt_2_1_.getCookedHealAmount();
        }
        return lvt_2_1_.getUncookedHealAmount();
    }

    @Override
    public float getSaturationModifier(ItemStack p_getSaturationModifier_1_) {
        FishType lvt_2_1_ = FishType.byItemStack(p_getSaturationModifier_1_);
        if (this.cooked && lvt_2_1_.canCook()) {
            return lvt_2_1_.getCookedSaturationModifier();
        }
        return lvt_2_1_.getUncookedSaturationModifier();
    }

    @Override
    protected void onFoodEaten(ItemStack p_onFoodEaten_1_, World p_onFoodEaten_2_, EntityPlayer p_onFoodEaten_3_) {
        FishType lvt_4_1_ = FishType.byItemStack(p_onFoodEaten_1_);
        if (lvt_4_1_ == FishType.PUFFERFISH) {
            p_onFoodEaten_3_.addPotionEffect(new PotionEffect(MobEffects.POISON, 1200, 3));
            p_onFoodEaten_3_.addPotionEffect(new PotionEffect(MobEffects.HUNGER, 300, 2));
            p_onFoodEaten_3_.addPotionEffect(new PotionEffect(MobEffects.NAUSEA, 300, 1));
        }
        super.onFoodEaten(p_onFoodEaten_1_, p_onFoodEaten_2_, p_onFoodEaten_3_);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item p_getSubItems_1_, CreativeTabs p_getSubItems_2_, NonNullList<ItemStack> p_getSubItems_3_) {
        for (FishType lvt_7_1_ : FishType.values()) {
            if (this.cooked && !lvt_7_1_.canCook()) continue;
            p_getSubItems_3_.add(new ItemStack(this, 1, lvt_7_1_.getMetadata()));
        }
    }

    @Override
    public String getUnlocalizedName(ItemStack p_getUnlocalizedName_1_) {
        FishType lvt_2_1_ = FishType.byItemStack(p_getUnlocalizedName_1_);
        return this.getUnlocalizedName() + "." + lvt_2_1_.getUnlocalizedName() + "." + (this.cooked && lvt_2_1_.canCook() ? "cooked" : "raw");
    }

    public static enum FishType {
        COD(0, "cod", 2, 0.1f, 5, 0.6f),
        SALMON(1, "salmon", 2, 0.1f, 6, 0.8f),
        CLOWNFISH(2, "clownfish", 1, 0.1f),
        PUFFERFISH(3, "pufferfish", 1, 0.1f);

        private static final Map<Integer, FishType> META_LOOKUP;
        private final int meta;
        private final String unlocalizedName;
        private final int uncookedHealAmount;
        private final float uncookedSaturationModifier;
        private final int cookedHealAmount;
        private final float cookedSaturationModifier;
        private final boolean cookable;

        private FishType(int p_i45336_3_, String p_i45336_4_, int p_i45336_5_, float p_i45336_6_, int p_i45336_7_, float p_i45336_8_) {
            this.meta = p_i45336_3_;
            this.unlocalizedName = p_i45336_4_;
            this.uncookedHealAmount = p_i45336_5_;
            this.uncookedSaturationModifier = p_i45336_6_;
            this.cookedHealAmount = p_i45336_7_;
            this.cookedSaturationModifier = p_i45336_8_;
            this.cookable = true;
        }

        private FishType(int p_i45337_3_, String p_i45337_4_, int p_i45337_5_, float p_i45337_6_) {
            this.meta = p_i45337_3_;
            this.unlocalizedName = p_i45337_4_;
            this.uncookedHealAmount = p_i45337_5_;
            this.uncookedSaturationModifier = p_i45337_6_;
            this.cookedHealAmount = 0;
            this.cookedSaturationModifier = 0.0f;
            this.cookable = false;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String getUnlocalizedName() {
            return this.unlocalizedName;
        }

        public int getUncookedHealAmount() {
            return this.uncookedHealAmount;
        }

        public float getUncookedSaturationModifier() {
            return this.uncookedSaturationModifier;
        }

        public int getCookedHealAmount() {
            return this.cookedHealAmount;
        }

        public float getCookedSaturationModifier() {
            return this.cookedSaturationModifier;
        }

        public boolean canCook() {
            return this.cookable;
        }

        public static FishType byMetadata(int p_byMetadata_0_) {
            FishType lvt_1_1_ = META_LOOKUP.get(p_byMetadata_0_);
            if (lvt_1_1_ == null) {
                return COD;
            }
            return lvt_1_1_;
        }

        public static FishType byItemStack(ItemStack p_byItemStack_0_) {
            if (p_byItemStack_0_.getItem() instanceof ItemFishFood) {
                return FishType.byMetadata(p_byItemStack_0_.getMetadata());
            }
            return COD;
        }

        static {
            META_LOOKUP = Maps.newHashMap();
            for (FishType lvt_3_1_ : FishType.values()) {
                META_LOOKUP.put(lvt_3_1_.getMetadata(), lvt_3_1_);
            }
        }
    }
}

