/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFishingRod
extends Item {
    public ItemFishingRod() {
        this.setMaxDamage(64);
        this.setMaxStackSize(1);
        this.setCreativeTab(CreativeTabs.TOOLS);
        this.addPropertyOverride(new ResourceLocation("cast"), new IItemPropertyGetter(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public float apply(ItemStack p_apply_1_, World p_apply_2_, EntityLivingBase p_apply_3_) {
                boolean lvt_5_1_;
                if (p_apply_3_ == null) {
                    return 0.0f;
                }
                boolean lvt_4_1_ = p_apply_3_.getHeldItemMainhand() == p_apply_1_;
                boolean bl = lvt_5_1_ = p_apply_3_.getHeldItemOffhand() == p_apply_1_;
                if (p_apply_3_.getHeldItemMainhand().getItem() instanceof ItemFishingRod) {
                    lvt_5_1_ = false;
                }
                return (lvt_4_1_ || lvt_5_1_) && p_apply_3_ instanceof EntityPlayer && ((EntityPlayer)p_apply_3_).fishEntity != null ? 1.0f : 0.0f;
            }
        });
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isFull3D() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldRotateAroundWhenRendering() {
        return true;
    }

    @Override
    public ActionResult<ItemStack> onItemRightClick(World p_onItemRightClick_1_, EntityPlayer p_onItemRightClick_2_, EnumHand p_onItemRightClick_3_) {
        ItemStack lvt_4_1_ = p_onItemRightClick_2_.getHeldItem(p_onItemRightClick_3_);
        if (p_onItemRightClick_2_.fishEntity != null) {
            int lvt_5_1_ = p_onItemRightClick_2_.fishEntity.handleHookRetraction();
            lvt_4_1_.damageItem(lvt_5_1_, p_onItemRightClick_2_);
            p_onItemRightClick_2_.swingArm(p_onItemRightClick_3_);
        } else {
            p_onItemRightClick_1_.playSound(null, p_onItemRightClick_2_.posX, p_onItemRightClick_2_.posY, p_onItemRightClick_2_.posZ, SoundEvents.ENTITY_BOBBER_THROW, SoundCategory.NEUTRAL, 0.5f, 0.4f / (itemRand.nextFloat() * 0.4f + 0.8f));
            if (!p_onItemRightClick_1_.isRemote) {
                int lvt_7_1_;
                EntityFishHook lvt_5_2_ = new EntityFishHook(p_onItemRightClick_1_, p_onItemRightClick_2_);
                int lvt_6_1_ = EnchantmentHelper.func_191528_c(lvt_4_1_);
                if (lvt_6_1_ > 0) {
                    lvt_5_2_.func_191516_a(lvt_6_1_);
                }
                if ((lvt_7_1_ = EnchantmentHelper.func_191529_b(lvt_4_1_)) > 0) {
                    lvt_5_2_.func_191517_b(lvt_7_1_);
                }
                p_onItemRightClick_1_.spawnEntity(lvt_5_2_);
            }
            p_onItemRightClick_2_.swingArm(p_onItemRightClick_3_);
            p_onItemRightClick_2_.addStat(StatList.getObjectUseStats(this));
        }
        return new ActionResult<ItemStack>(EnumActionResult.SUCCESS, lvt_4_1_);
    }

    @Override
    public int getItemEnchantability() {
        return 1;
    }
}

