/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;

public class ItemFood
extends Item {
    public final int itemUseDuration = 32;
    private final int healAmount;
    private final float saturationModifier;
    private final boolean isWolfsFavoriteMeat;
    private boolean alwaysEdible;
    private PotionEffect potionId;
    private float potionEffectProbability;

    public ItemFood(int p_i45339_1_, float p_i45339_2_, boolean p_i45339_3_) {
        this.healAmount = p_i45339_1_;
        this.isWolfsFavoriteMeat = p_i45339_3_;
        this.saturationModifier = p_i45339_2_;
        this.setCreativeTab(CreativeTabs.FOOD);
    }

    public ItemFood(int p_i45340_1_, boolean p_i45340_2_) {
        this(p_i45340_1_, 0.6f, p_i45340_2_);
    }

    @Override
    public ItemStack onItemUseFinish(ItemStack p_onItemUseFinish_1_, World p_onItemUseFinish_2_, EntityLivingBase p_onItemUseFinish_3_) {
        if (p_onItemUseFinish_3_ instanceof EntityPlayer) {
            EntityPlayer lvt_4_1_ = (EntityPlayer)p_onItemUseFinish_3_;
            lvt_4_1_.getFoodStats().addStats(this, p_onItemUseFinish_1_);
            p_onItemUseFinish_2_.playSound(null, lvt_4_1_.posX, lvt_4_1_.posY, lvt_4_1_.posZ, SoundEvents.ENTITY_PLAYER_BURP, SoundCategory.PLAYERS, 0.5f, p_onItemUseFinish_2_.rand.nextFloat() * 0.1f + 0.9f);
            this.onFoodEaten(p_onItemUseFinish_1_, p_onItemUseFinish_2_, lvt_4_1_);
            lvt_4_1_.addStat(StatList.getObjectUseStats(this));
        }
        p_onItemUseFinish_1_.shrink(1);
        return p_onItemUseFinish_1_;
    }

    protected void onFoodEaten(ItemStack p_onFoodEaten_1_, World p_onFoodEaten_2_, EntityPlayer p_onFoodEaten_3_) {
        if (!p_onFoodEaten_2_.isRemote && this.potionId != null && p_onFoodEaten_2_.rand.nextFloat() < this.potionEffectProbability) {
            p_onFoodEaten_3_.addPotionEffect(new PotionEffect(this.potionId));
        }
    }

    @Override
    public int getMaxItemUseDuration(ItemStack p_getMaxItemUseDuration_1_) {
        return 32;
    }

    @Override
    public EnumAction getItemUseAction(ItemStack p_getItemUseAction_1_) {
        return EnumAction.EAT;
    }

    @Override
    public ActionResult<ItemStack> onItemRightClick(World p_onItemRightClick_1_, EntityPlayer p_onItemRightClick_2_, EnumHand p_onItemRightClick_3_) {
        ItemStack lvt_4_1_ = p_onItemRightClick_2_.getHeldItem(p_onItemRightClick_3_);
        if (p_onItemRightClick_2_.canEat(this.alwaysEdible)) {
            p_onItemRightClick_2_.setActiveHand(p_onItemRightClick_3_);
            return new ActionResult<ItemStack>(EnumActionResult.SUCCESS, lvt_4_1_);
        }
        return new ActionResult<ItemStack>(EnumActionResult.FAIL, lvt_4_1_);
    }

    public int getHealAmount(ItemStack p_getHealAmount_1_) {
        return this.healAmount;
    }

    public float getSaturationModifier(ItemStack p_getSaturationModifier_1_) {
        return this.saturationModifier;
    }

    public boolean isWolfsFavoriteMeat() {
        return this.isWolfsFavoriteMeat;
    }

    public ItemFood setPotionEffect(PotionEffect p_setPotionEffect_1_, float p_setPotionEffect_2_) {
        this.potionId = p_setPotionEffect_1_;
        this.potionEffectProbability = p_setPotionEffect_2_;
        return this;
    }

    public ItemFood setAlwaysEdible() {
        this.alwaysEdible = true;
        return this;
    }
}

