/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import com.google.common.base.Predicate;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionUtils;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class ItemGlassBottle
extends Item {
    public ItemGlassBottle() {
        this.setCreativeTab(CreativeTabs.BREWING);
    }

    @Override
    public ActionResult<ItemStack> onItemRightClick(World p_onItemRightClick_1_, EntityPlayer p_onItemRightClick_2_, EnumHand p_onItemRightClick_3_) {
        List<EntityAreaEffectCloud> lvt_4_1_ = p_onItemRightClick_1_.getEntitiesWithinAABB(EntityAreaEffectCloud.class, p_onItemRightClick_2_.getEntityBoundingBox().expandXyz(2.0), new Predicate<EntityAreaEffectCloud>(){

            public boolean apply(EntityAreaEffectCloud p_apply_1_) {
                return p_apply_1_ != null && p_apply_1_.isEntityAlive() && p_apply_1_.getOwner() instanceof EntityDragon;
            }

            public /* synthetic */ boolean apply(Object p_apply_1_) {
                return this.apply((EntityAreaEffectCloud)p_apply_1_);
            }
        });
        ItemStack lvt_5_1_ = p_onItemRightClick_2_.getHeldItem(p_onItemRightClick_3_);
        if (!lvt_4_1_.isEmpty()) {
            EntityAreaEffectCloud lvt_6_1_ = lvt_4_1_.get(0);
            lvt_6_1_.setRadius(lvt_6_1_.getRadius() - 0.5f);
            p_onItemRightClick_1_.playSound(null, p_onItemRightClick_2_.posX, p_onItemRightClick_2_.posY, p_onItemRightClick_2_.posZ, SoundEvents.ITEM_BOTTLE_FILL_DRAGONBREATH, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            return new ActionResult<ItemStack>(EnumActionResult.SUCCESS, this.turnBottleIntoItem(lvt_5_1_, p_onItemRightClick_2_, new ItemStack(Items.DRAGON_BREATH)));
        }
        RayTraceResult lvt_6_2_ = this.rayTrace(p_onItemRightClick_1_, p_onItemRightClick_2_, true);
        if (lvt_6_2_ == null) {
            return new ActionResult<ItemStack>(EnumActionResult.PASS, lvt_5_1_);
        }
        if (lvt_6_2_.typeOfHit == RayTraceResult.Type.BLOCK) {
            BlockPos lvt_7_1_ = lvt_6_2_.getBlockPos();
            if (!p_onItemRightClick_1_.isBlockModifiable(p_onItemRightClick_2_, lvt_7_1_) || !p_onItemRightClick_2_.canPlayerEdit(lvt_7_1_.offset(lvt_6_2_.sideHit), lvt_6_2_.sideHit, lvt_5_1_)) {
                return new ActionResult<ItemStack>(EnumActionResult.PASS, lvt_5_1_);
            }
            if (p_onItemRightClick_1_.getBlockState(lvt_7_1_).getMaterial() == Material.WATER) {
                p_onItemRightClick_1_.playSound(p_onItemRightClick_2_, p_onItemRightClick_2_.posX, p_onItemRightClick_2_.posY, p_onItemRightClick_2_.posZ, SoundEvents.ITEM_BOTTLE_FILL, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                return new ActionResult<ItemStack>(EnumActionResult.SUCCESS, this.turnBottleIntoItem(lvt_5_1_, p_onItemRightClick_2_, PotionUtils.addPotionToItemStack(new ItemStack(Items.POTIONITEM), PotionTypes.WATER)));
            }
        }
        return new ActionResult<ItemStack>(EnumActionResult.PASS, lvt_5_1_);
    }

    protected ItemStack turnBottleIntoItem(ItemStack p_turnBottleIntoItem_1_, EntityPlayer p_turnBottleIntoItem_2_, ItemStack p_turnBottleIntoItem_3_) {
        p_turnBottleIntoItem_1_.shrink(1);
        p_turnBottleIntoItem_2_.addStat(StatList.getObjectUseStats(this));
        if (p_turnBottleIntoItem_1_.isEmpty()) {
            return p_turnBottleIntoItem_3_;
        }
        if (!p_turnBottleIntoItem_2_.inventory.addItemStackToInventory(p_turnBottleIntoItem_3_)) {
            p_turnBottleIntoItem_2_.dropItem(p_turnBottleIntoItem_3_, false);
        }
        return p_turnBottleIntoItem_1_;
    }
}

