/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemHangingEntity
extends Item {
    private final Class<? extends EntityHanging> hangingEntityClass;

    public ItemHangingEntity(Class<? extends EntityHanging> p_i45342_1_) {
        this.hangingEntityClass = p_i45342_1_;
        this.setCreativeTab(CreativeTabs.DECORATIONS);
    }

    @Override
    public EnumActionResult onItemUse(EntityPlayer p_onItemUse_1_, World p_onItemUse_2_, BlockPos p_onItemUse_3_, EnumHand p_onItemUse_4_, EnumFacing p_onItemUse_5_, float p_onItemUse_6_, float p_onItemUse_7_, float p_onItemUse_8_) {
        ItemStack lvt_9_1_ = p_onItemUse_1_.getHeldItem(p_onItemUse_4_);
        BlockPos lvt_10_1_ = p_onItemUse_3_.offset(p_onItemUse_5_);
        if (p_onItemUse_5_ == EnumFacing.DOWN || p_onItemUse_5_ == EnumFacing.UP || !p_onItemUse_1_.canPlayerEdit(lvt_10_1_, p_onItemUse_5_, lvt_9_1_)) {
            return EnumActionResult.FAIL;
        }
        EntityHanging lvt_11_1_ = this.createEntity(p_onItemUse_2_, lvt_10_1_, p_onItemUse_5_);
        if (lvt_11_1_ != null && lvt_11_1_.onValidSurface()) {
            if (!p_onItemUse_2_.isRemote) {
                lvt_11_1_.playPlaceSound();
                p_onItemUse_2_.spawnEntity(lvt_11_1_);
            }
            lvt_9_1_.shrink(1);
        }
        return EnumActionResult.SUCCESS;
    }

    @Nullable
    private EntityHanging createEntity(World p_createEntity_1_, BlockPos p_createEntity_2_, EnumFacing p_createEntity_3_) {
        if (this.hangingEntityClass == EntityPainting.class) {
            return new EntityPainting(p_createEntity_1_, p_createEntity_2_, p_createEntity_3_);
        }
        if (this.hangingEntityClass == EntityItemFrame.class) {
            return new EntityItemFrame(p_createEntity_1_, p_createEntity_2_, p_createEntity_3_);
        }
        return null;
    }
}

