/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import com.google.common.collect.Multimap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemHoe
extends Item {
    private final float speed;
    protected Item.ToolMaterial theToolMaterial;

    public ItemHoe(Item.ToolMaterial p_i45343_1_) {
        this.theToolMaterial = p_i45343_1_;
        this.maxStackSize = 1;
        this.setMaxDamage(p_i45343_1_.getMaxUses());
        this.setCreativeTab(CreativeTabs.TOOLS);
        this.speed = p_i45343_1_.getDamageVsEntity() + 1.0f;
    }

    @Override
    public EnumActionResult onItemUse(EntityPlayer p_onItemUse_1_, World p_onItemUse_2_, BlockPos p_onItemUse_3_, EnumHand p_onItemUse_4_, EnumFacing p_onItemUse_5_, float p_onItemUse_6_, float p_onItemUse_7_, float p_onItemUse_8_) {
        ItemStack itemstack = p_onItemUse_1_.getHeldItem(p_onItemUse_4_);
        if (!p_onItemUse_1_.canPlayerEdit(p_onItemUse_3_.offset(p_onItemUse_5_), p_onItemUse_5_, itemstack)) {
            return EnumActionResult.FAIL;
        }
        int hook = ForgeEventFactory.onHoeUse(itemstack, p_onItemUse_1_, p_onItemUse_2_, p_onItemUse_3_);
        if (hook != 0) {
            return hook > 0 ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
        }
        IBlockState iblockstate = p_onItemUse_2_.getBlockState(p_onItemUse_3_);
        Block block = iblockstate.getBlock();
        if (p_onItemUse_5_ != EnumFacing.DOWN && p_onItemUse_2_.isAirBlock(p_onItemUse_3_.up())) {
            if (block == Blocks.GRASS || block == Blocks.GRASS_PATH) {
                this.setBlock(itemstack, p_onItemUse_1_, p_onItemUse_2_, p_onItemUse_3_, Blocks.FARMLAND.getDefaultState());
                return EnumActionResult.SUCCESS;
            }
            if (block == Blocks.DIRT) {
                switch (iblockstate.getValue(BlockDirt.VARIANT)) {
                    case DIRT: {
                        this.setBlock(itemstack, p_onItemUse_1_, p_onItemUse_2_, p_onItemUse_3_, Blocks.FARMLAND.getDefaultState());
                        return EnumActionResult.SUCCESS;
                    }
                    case COARSE_DIRT: {
                        this.setBlock(itemstack, p_onItemUse_1_, p_onItemUse_2_, p_onItemUse_3_, Blocks.DIRT.getDefaultState().withProperty(BlockDirt.VARIANT, BlockDirt.DirtType.DIRT));
                        return EnumActionResult.SUCCESS;
                    }
                }
            }
        }
        return EnumActionResult.PASS;
    }

    @Override
    public boolean hitEntity(ItemStack p_hitEntity_1_, EntityLivingBase p_hitEntity_2_, EntityLivingBase p_hitEntity_3_) {
        p_hitEntity_1_.damageItem(1, p_hitEntity_3_);
        return true;
    }

    protected void setBlock(ItemStack p_setBlock_1_, EntityPlayer p_setBlock_2_, World p_setBlock_3_, BlockPos p_setBlock_4_, IBlockState p_setBlock_5_) {
        p_setBlock_3_.playSound(p_setBlock_2_, p_setBlock_4_, SoundEvents.ITEM_HOE_TILL, SoundCategory.BLOCKS, 1.0f, 1.0f);
        if (!p_setBlock_3_.isRemote) {
            p_setBlock_3_.setBlockState(p_setBlock_4_, p_setBlock_5_, 11);
            p_setBlock_1_.damageItem(1, p_setBlock_2_);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isFull3D() {
        return true;
    }

    public String getMaterialName() {
        return this.theToolMaterial.toString();
    }

    @Override
    public Multimap<String, AttributeModifier> getItemAttributeModifiers(EntityEquipmentSlot p_getItemAttributeModifiers_1_) {
        Multimap<String, AttributeModifier> multimap = super.getItemAttributeModifiers(p_getItemAttributeModifiers_1_);
        if (p_getItemAttributeModifiers_1_ == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.ATTACK_DAMAGE.getName(), (Object)new AttributeModifier(ATTACK_DAMAGE_MODIFIER, "Weapon modifier", 0.0, 0));
            multimap.put((Object)SharedMonsterAttributes.ATTACK_SPEED.getName(), (Object)new AttributeModifier(ATTACK_SPEED_MODIFIER, "Weapon modifier", this.speed - 4.0f, 0));
        }
        return multimap;
    }
}

