/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemColored;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;

public class ItemLilyPad
extends ItemColored {
    public ItemLilyPad(Block p_i45357_1_) {
        super(p_i45357_1_, false);
    }

    @Override
    public ActionResult<ItemStack> onItemRightClick(World p_onItemRightClick_1_, EntityPlayer p_onItemRightClick_2_, EnumHand p_onItemRightClick_3_) {
        ItemStack itemstack = p_onItemRightClick_2_.getHeldItem(p_onItemRightClick_3_);
        RayTraceResult raytraceresult = this.rayTrace(p_onItemRightClick_1_, p_onItemRightClick_2_, true);
        if (raytraceresult == null) {
            return new ActionResult<ItemStack>(EnumActionResult.PASS, itemstack);
        }
        if (raytraceresult.typeOfHit == RayTraceResult.Type.BLOCK) {
            BlockPos blockpos = raytraceresult.getBlockPos();
            if (!p_onItemRightClick_1_.isBlockModifiable(p_onItemRightClick_2_, blockpos) || !p_onItemRightClick_2_.canPlayerEdit(blockpos.offset(raytraceresult.sideHit), raytraceresult.sideHit, itemstack)) {
                return new ActionResult<ItemStack>(EnumActionResult.FAIL, itemstack);
            }
            BlockPos blockpos1 = blockpos.up();
            IBlockState iblockstate = p_onItemRightClick_1_.getBlockState(blockpos);
            if (iblockstate.getMaterial() == Material.WATER && iblockstate.getValue(BlockLiquid.LEVEL) == 0 && p_onItemRightClick_1_.isAirBlock(blockpos1)) {
                BlockSnapshot blocksnapshot = BlockSnapshot.getBlockSnapshot(p_onItemRightClick_1_, blockpos1);
                p_onItemRightClick_1_.setBlockState(blockpos1, Blocks.WATERLILY.getDefaultState());
                if (ForgeEventFactory.onPlayerBlockPlace(p_onItemRightClick_2_, blocksnapshot, EnumFacing.UP, p_onItemRightClick_3_).isCanceled()) {
                    blocksnapshot.restore(true, false);
                    return new ActionResult<ItemStack>(EnumActionResult.FAIL, itemstack);
                }
                p_onItemRightClick_1_.setBlockState(blockpos1, Blocks.WATERLILY.getDefaultState(), 11);
                if (!p_onItemRightClick_2_.capabilities.isCreativeMode) {
                    itemstack.shrink(1);
                }
                p_onItemRightClick_2_.addStat(StatList.getObjectUseStats(this));
                p_onItemRightClick_1_.playSound(p_onItemRightClick_2_, blockpos, SoundEvents.BLOCK_WATERLILY_PLACE, SoundCategory.BLOCKS, 1.0f, 1.0f);
                return new ActionResult<ItemStack>(EnumActionResult.SUCCESS, itemstack);
            }
        }
        return new ActionResult<ItemStack>(EnumActionResult.FAIL, itemstack);
    }
}

