/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemMinecart
extends Item {
    private static final IBehaviorDispenseItem MINECART_DISPENSER_BEHAVIOR = new BehaviorDefaultDispenseItem(){
        private final BehaviorDefaultDispenseItem behaviourDefaultDispenseItem = new BehaviorDefaultDispenseItem();

        @Override
        public ItemStack dispenseStack(IBlockSource p_dispenseStack_1_, ItemStack p_dispenseStack_2_) {
            double d3;
            BlockRailBase.EnumRailDirection blockrailbase$enumraildirection;
            EnumFacing enumfacing = p_dispenseStack_1_.getBlockState().getValue(BlockDispenser.FACING);
            World world = p_dispenseStack_1_.getWorld();
            double d0 = p_dispenseStack_1_.getX() + (double)enumfacing.getFrontOffsetX() * 1.125;
            double d1 = Math.floor(p_dispenseStack_1_.getY()) + (double)enumfacing.getFrontOffsetY();
            double d2 = p_dispenseStack_1_.getZ() + (double)enumfacing.getFrontOffsetZ() * 1.125;
            BlockPos blockpos = p_dispenseStack_1_.getBlockPos().offset(enumfacing);
            IBlockState iblockstate = world.getBlockState(blockpos);
            BlockRailBase.EnumRailDirection enumRailDirection = blockrailbase$enumraildirection = iblockstate.getBlock() instanceof BlockRailBase ? ((BlockRailBase)iblockstate.getBlock()).getRailDirection(world, blockpos, iblockstate, null) : BlockRailBase.EnumRailDirection.NORTH_SOUTH;
            if (BlockRailBase.isRailBlock(iblockstate)) {
                d3 = blockrailbase$enumraildirection.isAscending() ? 0.6 : 0.1;
            } else {
                if (iblockstate.getMaterial() != Material.AIR || !BlockRailBase.isRailBlock(world.getBlockState(blockpos.down()))) {
                    return this.behaviourDefaultDispenseItem.dispense(p_dispenseStack_1_, p_dispenseStack_2_);
                }
                IBlockState iblockstate1 = world.getBlockState(blockpos.down());
                BlockRailBase.EnumRailDirection blockrailbase$enumraildirection1 = iblockstate1.getBlock() instanceof BlockRailBase ? ((BlockRailBase)iblockstate.getBlock()).getRailDirection(world, blockpos, iblockstate, null) : BlockRailBase.EnumRailDirection.NORTH_SOUTH;
                d3 = enumfacing != EnumFacing.DOWN && blockrailbase$enumraildirection1.isAscending() ? -0.4 : -0.9;
            }
            EntityMinecart entityminecart = EntityMinecart.create(world, d0, d1 + d3, d2, ((ItemMinecart)p_dispenseStack_2_.getItem()).minecartType);
            if (p_dispenseStack_2_.hasDisplayName()) {
                entityminecart.setCustomNameTag(p_dispenseStack_2_.getDisplayName());
            }
            world.spawnEntity(entityminecart);
            p_dispenseStack_2_.shrink(1);
            return p_dispenseStack_2_;
        }

        @Override
        protected void playDispenseSound(IBlockSource p_playDispenseSound_1_) {
            p_playDispenseSound_1_.getWorld().playEvent(1000, p_playDispenseSound_1_.getBlockPos(), 0);
        }
    };
    private final EntityMinecart.Type minecartType;

    public ItemMinecart(EntityMinecart.Type p_i46743_1_) {
        this.maxStackSize = 1;
        this.minecartType = p_i46743_1_;
        this.setCreativeTab(CreativeTabs.TRANSPORTATION);
        BlockDispenser.DISPENSE_BEHAVIOR_REGISTRY.putObject(this, MINECART_DISPENSER_BEHAVIOR);
    }

    @Override
    public EnumActionResult onItemUse(EntityPlayer p_onItemUse_1_, World p_onItemUse_2_, BlockPos p_onItemUse_3_, EnumHand p_onItemUse_4_, EnumFacing p_onItemUse_5_, float p_onItemUse_6_, float p_onItemUse_7_, float p_onItemUse_8_) {
        IBlockState iblockstate = p_onItemUse_2_.getBlockState(p_onItemUse_3_);
        if (!BlockRailBase.isRailBlock(iblockstate)) {
            return EnumActionResult.FAIL;
        }
        ItemStack itemstack = p_onItemUse_1_.getHeldItem(p_onItemUse_4_);
        if (!p_onItemUse_2_.isRemote) {
            BlockRailBase.EnumRailDirection blockrailbase$enumraildirection = iblockstate.getBlock() instanceof BlockRailBase ? ((BlockRailBase)iblockstate.getBlock()).getRailDirection(p_onItemUse_2_, p_onItemUse_3_, iblockstate, null) : BlockRailBase.EnumRailDirection.NORTH_SOUTH;
            double d0 = 0.0;
            if (blockrailbase$enumraildirection.isAscending()) {
                d0 = 0.5;
            }
            EntityMinecart entityminecart = EntityMinecart.create(p_onItemUse_2_, (double)p_onItemUse_3_.getX() + 0.5, (double)p_onItemUse_3_.getY() + 0.0625 + d0, (double)p_onItemUse_3_.getZ() + 0.5, this.minecartType);
            if (itemstack.hasDisplayName()) {
                entityminecart.setCustomNameTag(itemstack.getDisplayName());
            }
            p_onItemUse_2_.spawnEntity(entityminecart);
        }
        itemstack.shrink(1);
        return EnumActionResult.SUCCESS;
    }
}

