/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemMonsterPlacer
extends Item {
    public ItemMonsterPlacer() {
        this.setCreativeTab(CreativeTabs.MISC);
    }

    @Override
    public String getItemStackDisplayName(ItemStack p_getItemStackDisplayName_1_) {
        String lvt_2_1_ = ("" + I18n.translateToLocal(this.getUnlocalizedName() + ".name")).trim();
        String lvt_3_1_ = EntityList.getTranslationName(ItemMonsterPlacer.getNamedIdFrom(p_getItemStackDisplayName_1_));
        if (lvt_3_1_ != null) {
            lvt_2_1_ = lvt_2_1_ + " " + I18n.translateToLocal("entity." + lvt_3_1_ + ".name");
        }
        return lvt_2_1_;
    }

    @Override
    public EnumActionResult onItemUse(EntityPlayer p_onItemUse_1_, World p_onItemUse_2_, BlockPos p_onItemUse_3_, EnumHand p_onItemUse_4_, EnumFacing p_onItemUse_5_, float p_onItemUse_6_, float p_onItemUse_7_, float p_onItemUse_8_) {
        TileEntity lvt_12_1_;
        ItemStack lvt_9_1_ = p_onItemUse_1_.getHeldItem(p_onItemUse_4_);
        if (p_onItemUse_2_.isRemote) {
            return EnumActionResult.SUCCESS;
        }
        if (!p_onItemUse_1_.canPlayerEdit(p_onItemUse_3_.offset(p_onItemUse_5_), p_onItemUse_5_, lvt_9_1_)) {
            return EnumActionResult.FAIL;
        }
        IBlockState lvt_10_1_ = p_onItemUse_2_.getBlockState(p_onItemUse_3_);
        Block lvt_11_1_ = lvt_10_1_.getBlock();
        if (lvt_11_1_ == Blocks.MOB_SPAWNER && (lvt_12_1_ = p_onItemUse_2_.getTileEntity(p_onItemUse_3_)) instanceof TileEntityMobSpawner) {
            MobSpawnerBaseLogic lvt_13_1_ = ((TileEntityMobSpawner)lvt_12_1_).getSpawnerBaseLogic();
            lvt_13_1_.setEntityId(ItemMonsterPlacer.getNamedIdFrom(lvt_9_1_));
            lvt_12_1_.markDirty();
            p_onItemUse_2_.notifyBlockUpdate(p_onItemUse_3_, lvt_10_1_, lvt_10_1_, 3);
            if (!p_onItemUse_1_.capabilities.isCreativeMode) {
                lvt_9_1_.shrink(1);
            }
            return EnumActionResult.SUCCESS;
        }
        BlockPos lvt_12_2_ = p_onItemUse_3_.offset(p_onItemUse_5_);
        double lvt_13_2_ = this.getYOffset(p_onItemUse_2_, lvt_12_2_);
        Entity lvt_15_1_ = ItemMonsterPlacer.spawnCreature(p_onItemUse_2_, ItemMonsterPlacer.getNamedIdFrom(lvt_9_1_), (double)lvt_12_2_.getX() + 0.5, (double)lvt_12_2_.getY() + lvt_13_2_, (double)lvt_12_2_.getZ() + 0.5);
        if (lvt_15_1_ != null) {
            if (lvt_15_1_ instanceof EntityLivingBase && lvt_9_1_.hasDisplayName()) {
                lvt_15_1_.setCustomNameTag(lvt_9_1_.getDisplayName());
            }
            ItemMonsterPlacer.applyItemEntityDataToEntity(p_onItemUse_2_, p_onItemUse_1_, lvt_9_1_, lvt_15_1_);
            if (!p_onItemUse_1_.capabilities.isCreativeMode) {
                lvt_9_1_.shrink(1);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    protected double getYOffset(World p_getYOffset_1_, BlockPos p_getYOffset_2_) {
        AxisAlignedBB lvt_3_1_ = new AxisAlignedBB(p_getYOffset_2_).addCoord(0.0, -1.0, 0.0);
        List<AxisAlignedBB> lvt_4_1_ = p_getYOffset_1_.getCollisionBoxes(null, lvt_3_1_);
        if (lvt_4_1_.isEmpty()) {
            return 0.0;
        }
        double lvt_5_1_ = lvt_3_1_.minY;
        for (AxisAlignedBB lvt_8_1_ : lvt_4_1_) {
            lvt_5_1_ = Math.max(lvt_8_1_.maxY, lvt_5_1_);
        }
        return lvt_5_1_ - (double)p_getYOffset_2_.getY();
    }

    public static void applyItemEntityDataToEntity(World p_applyItemEntityDataToEntity_0_, EntityPlayer p_applyItemEntityDataToEntity_1_, ItemStack p_applyItemEntityDataToEntity_2_, Entity p_applyItemEntityDataToEntity_3_) {
        MinecraftServer lvt_4_1_ = p_applyItemEntityDataToEntity_0_.getMinecraftServer();
        if (lvt_4_1_ == null || p_applyItemEntityDataToEntity_3_ == null) {
            return;
        }
        NBTTagCompound lvt_5_1_ = p_applyItemEntityDataToEntity_2_.getTagCompound();
        if (lvt_5_1_ != null && lvt_5_1_.hasKey("EntityTag", 10)) {
            if (!(p_applyItemEntityDataToEntity_0_.isRemote || !p_applyItemEntityDataToEntity_3_.ignoreItemEntityData() || p_applyItemEntityDataToEntity_1_ != null && lvt_4_1_.getPlayerList().canSendCommands(p_applyItemEntityDataToEntity_1_.getGameProfile()))) {
                return;
            }
            NBTTagCompound lvt_6_1_ = p_applyItemEntityDataToEntity_3_.writeToNBT(new NBTTagCompound());
            UUID lvt_7_1_ = p_applyItemEntityDataToEntity_3_.getUniqueID();
            lvt_6_1_.merge(lvt_5_1_.getCompoundTag("EntityTag"));
            p_applyItemEntityDataToEntity_3_.setUniqueId(lvt_7_1_);
            p_applyItemEntityDataToEntity_3_.readFromNBT(lvt_6_1_);
        }
    }

    @Override
    public ActionResult<ItemStack> onItemRightClick(World p_onItemRightClick_1_, EntityPlayer p_onItemRightClick_2_, EnumHand p_onItemRightClick_3_) {
        ItemStack lvt_4_1_ = p_onItemRightClick_2_.getHeldItem(p_onItemRightClick_3_);
        if (p_onItemRightClick_1_.isRemote) {
            return new ActionResult<ItemStack>(EnumActionResult.PASS, lvt_4_1_);
        }
        RayTraceResult lvt_5_1_ = this.rayTrace(p_onItemRightClick_1_, p_onItemRightClick_2_, true);
        if (lvt_5_1_ == null || lvt_5_1_.typeOfHit != RayTraceResult.Type.BLOCK) {
            return new ActionResult<ItemStack>(EnumActionResult.PASS, lvt_4_1_);
        }
        BlockPos lvt_6_1_ = lvt_5_1_.getBlockPos();
        if (!(p_onItemRightClick_1_.getBlockState(lvt_6_1_).getBlock() instanceof BlockLiquid)) {
            return new ActionResult<ItemStack>(EnumActionResult.PASS, lvt_4_1_);
        }
        if (!p_onItemRightClick_1_.isBlockModifiable(p_onItemRightClick_2_, lvt_6_1_) || !p_onItemRightClick_2_.canPlayerEdit(lvt_6_1_, lvt_5_1_.sideHit, lvt_4_1_)) {
            return new ActionResult<ItemStack>(EnumActionResult.FAIL, lvt_4_1_);
        }
        Entity lvt_7_1_ = ItemMonsterPlacer.spawnCreature(p_onItemRightClick_1_, ItemMonsterPlacer.getNamedIdFrom(lvt_4_1_), (double)lvt_6_1_.getX() + 0.5, (double)lvt_6_1_.getY() + 0.5, (double)lvt_6_1_.getZ() + 0.5);
        if (lvt_7_1_ == null) {
            return new ActionResult<ItemStack>(EnumActionResult.PASS, lvt_4_1_);
        }
        if (lvt_7_1_ instanceof EntityLivingBase && lvt_4_1_.hasDisplayName()) {
            lvt_7_1_.setCustomNameTag(lvt_4_1_.getDisplayName());
        }
        ItemMonsterPlacer.applyItemEntityDataToEntity(p_onItemRightClick_1_, p_onItemRightClick_2_, lvt_4_1_, lvt_7_1_);
        if (!p_onItemRightClick_2_.capabilities.isCreativeMode) {
            lvt_4_1_.shrink(1);
        }
        p_onItemRightClick_2_.addStat(StatList.getObjectUseStats(this));
        return new ActionResult<ItemStack>(EnumActionResult.SUCCESS, lvt_4_1_);
    }

    @Nullable
    public static Entity spawnCreature(World p_spawnCreature_0_, ResourceLocation p_spawnCreature_1_, double p_spawnCreature_2_, double p_spawnCreature_4_, double p_spawnCreature_6_) {
        if (p_spawnCreature_1_ == null || !EntityList.ENTITY_EGGS.containsKey(p_spawnCreature_1_)) {
            return null;
        }
        Entity lvt_8_1_ = null;
        for (int lvt_9_1_ = 0; lvt_9_1_ < 1; ++lvt_9_1_) {
            lvt_8_1_ = EntityList.createEntityByIDFromName(p_spawnCreature_1_, p_spawnCreature_0_);
            if (!(lvt_8_1_ instanceof EntityLiving)) continue;
            EntityLiving lvt_10_1_ = (EntityLiving)lvt_8_1_;
            lvt_8_1_.setLocationAndAngles(p_spawnCreature_2_, p_spawnCreature_4_, p_spawnCreature_6_, MathHelper.wrapDegrees(p_spawnCreature_0_.rand.nextFloat() * 360.0f), 0.0f);
            lvt_10_1_.rotationYawHead = lvt_10_1_.rotationYaw;
            lvt_10_1_.renderYawOffset = lvt_10_1_.rotationYaw;
            lvt_10_1_.onInitialSpawn(p_spawnCreature_0_.getDifficultyForLocation(new BlockPos(lvt_10_1_)), null);
            p_spawnCreature_0_.spawnEntity(lvt_8_1_);
            lvt_10_1_.playLivingSound();
        }
        return lvt_8_1_;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item p_getSubItems_1_, CreativeTabs p_getSubItems_2_, NonNullList<ItemStack> p_getSubItems_3_) {
        for (EntityList.EntityEggInfo lvt_5_1_ : EntityList.ENTITY_EGGS.values()) {
            ItemStack lvt_6_1_ = new ItemStack(p_getSubItems_1_, 1);
            ItemMonsterPlacer.applyEntityIdToItemStack(lvt_6_1_, lvt_5_1_.spawnedID);
            p_getSubItems_3_.add(lvt_6_1_);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void applyEntityIdToItemStack(ItemStack p_applyEntityIdToItemStack_0_, ResourceLocation p_applyEntityIdToItemStack_1_) {
        NBTTagCompound lvt_2_1_ = p_applyEntityIdToItemStack_0_.hasTagCompound() ? p_applyEntityIdToItemStack_0_.getTagCompound() : new NBTTagCompound();
        NBTTagCompound lvt_3_1_ = new NBTTagCompound();
        lvt_3_1_.setString("id", p_applyEntityIdToItemStack_1_.toString());
        lvt_2_1_.setTag("EntityTag", lvt_3_1_);
        p_applyEntityIdToItemStack_0_.setTagCompound(lvt_2_1_);
    }

    @Nullable
    public static ResourceLocation getNamedIdFrom(ItemStack p_getNamedIdFrom_0_) {
        NBTTagCompound lvt_1_1_ = p_getNamedIdFrom_0_.getTagCompound();
        if (lvt_1_1_ == null) {
            return null;
        }
        if (!lvt_1_1_.hasKey("EntityTag", 10)) {
            return null;
        }
        NBTTagCompound lvt_2_1_ = lvt_1_1_.getCompoundTag("EntityTag");
        if (!lvt_2_1_.hasKey("id", 8)) {
            return null;
        }
        String lvt_3_1_ = lvt_2_1_.getString("id");
        ResourceLocation lvt_4_1_ = new ResourceLocation(lvt_3_1_);
        if (!lvt_3_1_.contains(":")) {
            lvt_2_1_.setString("id", lvt_4_1_.toString());
        }
        return lvt_4_1_;
    }
}

